/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.framework.core.dsl.integration.internal;

import java.util.Collection;
import java.util.HashSet;
import org.eclipse.emf.common.util.EList;
import org.eclipse.osee.framework.core.data.IAccessContextId;
import org.eclipse.osee.framework.core.dsl.integration.AccessModelInterpreter;
import org.eclipse.osee.framework.core.dsl.integration.ArtifactDataProvider;
import org.eclipse.osee.framework.core.dsl.integration.RestrictionHandler;
import org.eclipse.osee.framework.core.dsl.integration.internal.ArtifactMatchInterpreter;
import org.eclipse.osee.framework.core.dsl.oseeDsl.AccessContext;
import org.eclipse.osee.framework.core.dsl.oseeDsl.HierarchyRestriction;
import org.eclipse.osee.framework.core.dsl.oseeDsl.ObjectRestriction;
import org.eclipse.osee.framework.core.dsl.oseeDsl.XArtifactMatcher;
import org.eclipse.osee.framework.core.model.access.AccessDetailCollector;
import org.eclipse.osee.framework.core.model.access.Scope;
import org.eclipse.osee.framework.jdk.core.type.OseeCoreException;
import org.eclipse.osee.framework.jdk.core.util.Conditions;
import org.eclipse.osee.framework.jdk.core.util.Strings;

public class AccessModelInterpreterImpl
implements AccessModelInterpreter {
    private final ArtifactDataProvider provider;
    private final ArtifactMatchInterpreter matcher;
    private final Collection<RestrictionHandler<?>> restrictionHandlers;

    public AccessModelInterpreterImpl(ArtifactDataProvider provider, ArtifactMatchInterpreter matcher, RestrictionHandler<?> ... restricitionHandlers) {
        this.provider = provider;
        this.matcher = matcher;
        this.restrictionHandlers = new HashSet();
        RestrictionHandler<?>[] restrictionHandlerArray = restricitionHandlers;
        int n = restricitionHandlers.length;
        int n2 = 0;
        while (n2 < n) {
            RestrictionHandler<?> handler = restrictionHandlerArray[n2];
            this.restrictionHandlers.add(handler);
            ++n2;
        }
    }

    @Override
    public AccessContext getContext(Collection<AccessContext> contexts, IAccessContextId contextId) throws OseeCoreException {
        Conditions.checkNotNull(contexts, (String)"accessContext collection");
        Conditions.checkNotNull((Object)contextId, (String)"accessContextId");
        AccessContext toReturn = null;
        for (AccessContext accessContext : contexts) {
            if (!((String)contextId.getGuid()).equals(Strings.unquote((String)accessContext.getGuid()))) continue;
            toReturn = accessContext;
        }
        return toReturn;
    }

    @Override
    public void computeAccessDetails(AccessDetailCollector collector, AccessContext context, Object objectToCheck) throws OseeCoreException {
        Conditions.checkNotNull((Object)collector, (String)"accessDetailCollector");
        Conditions.checkNotNull((Object)context, (String)"accessContext");
        Conditions.checkNotNull((Object)objectToCheck, (String)"objectToCheck");
        if (this.provider.isApplicable(objectToCheck)) {
            ArtifactDataProvider.ArtifactProxy data = this.provider.asCastedObject(objectToCheck);
            Conditions.checkNotNull((Object)data, (String)"artifactData", (String)"artifact data provider returned null - provider has an isApplicable error", (Object[])new Object[0]);
            this.collectApplicable(collector, context, data);
        }
    }

    private void collectApplicable(AccessDetailCollector collector, AccessContext context, ArtifactDataProvider.ArtifactProxy artifactData) throws OseeCoreException {
        Scope scope = this.getScope(context);
        this.processContext(collector, context, artifactData, scope);
        for (AccessContext superContext : context.getSuperAccessContexts()) {
            this.collectApplicable(collector, superContext, artifactData);
        }
    }

    private Scope getScope(AccessContext context) {
        Scope scope = new Scope();
        this.scopeHelper(scope, context);
        return scope;
    }

    private void scopeHelper(Scope scope, AccessContext context) {
        for (AccessContext parent : context.getSuperAccessContexts()) {
            this.scopeHelper(scope, parent);
        }
        scope.add(context.getName());
    }

    private void processContext(AccessDetailCollector collector, AccessContext context, ArtifactDataProvider.ArtifactProxy artifactData, Scope scope) throws OseeCoreException {
        this.collectRestrictions(collector, artifactData, (Collection<ObjectRestriction>)context.getAccessRules(), scope);
        EList restrictions = context.getHierarchyRestrictions();
        Collection<ArtifactDataProvider.ArtifactProxy> proxyHierarchy = artifactData.getHierarchy();
        for (HierarchyRestriction hierarchy : restrictions) {
            XArtifactMatcher artifactRef = hierarchy.getArtifactMatcherRef();
            if (!this.matcher.matches(artifactRef, proxyHierarchy)) continue;
            String tag = String.format("childOf-%s", artifactRef.getName());
            Scope child = scope.clone().addSubPath(tag);
            this.collectRestrictions(collector, artifactData, (Collection<ObjectRestriction>)hierarchy.getAccessRules(), child);
        }
    }

    private void collectRestrictions(AccessDetailCollector collector, ArtifactDataProvider.ArtifactProxy artifactData, Collection<ObjectRestriction> restrictions, Scope scope) throws OseeCoreException {
        for (ObjectRestriction objectRestriction : restrictions) {
            for (RestrictionHandler<?> restrictionHandler : this.restrictionHandlers) {
                restrictionHandler.process(objectRestriction, artifactData, collector, scope);
            }
        }
    }
}

