/*
 * Decompiled with CFR 0.152.
 */
package com.lowagie.toolbox.plugins;

import com.lowagie.text.pdf.PRStream;
import com.lowagie.text.pdf.PdfName;
import com.lowagie.text.pdf.PdfObject;
import com.lowagie.text.pdf.PdfReader;
import com.lowagie.text.pdf.PdfStream;
import com.lowagie.toolbox.AbstractTool;
import com.lowagie.toolbox.arguments.AbstractArgument;
import com.lowagie.toolbox.arguments.FileArgument;
import com.lowagie.toolbox.arguments.filters.PdfFilter;
import com.lowagie.toolbox.swing.EventDispatchingThread;
import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Image;
import java.awt.Toolkit;
import java.io.File;
import java.io.IOException;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JInternalFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSpinner;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class ImageXRefViewer
extends AbstractTool {
    int total_number_of_pictures = 0;
    JSpinner jSpinner = new JSpinner();
    JPanel image_panel = new JPanel();
    CardLayout layout = new CardLayout();

    public ImageXRefViewer() {
        this.arguments.add(new FileArgument(this, "srcfile", "The file you want to inspect", false, new PdfFilter()));
    }

    protected File getDestPathPDF() throws InstantiationException {
        throw new InstantiationException("There is no file to show.");
    }

    protected void createFrame() {
        this.internalFrame = new JInternalFrame("View Image XObjects", true, false, true);
        this.internalFrame.setSize(500, 300);
        this.internalFrame.setJMenuBar(this.getMenubar());
        this.internalFrame.getContentPane().setLayout(new BorderLayout());
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout());
        this.internalFrame.getContentPane().add((Component)jPanel, "Center");
        this.image_panel.setLayout(this.layout);
        this.jSpinner.addChangeListener(new SpinnerListener(this));
        this.image_panel.setBorder(BorderFactory.createEtchedBorder());
        JScrollPane jScrollPane = new JScrollPane();
        jScrollPane.setViewportView(this.image_panel);
        jPanel.add((Component)jScrollPane, "Center");
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new BorderLayout());
        jPanel2.add((Component)this.jSpinner, "Center");
        JLabel jLabel = new JLabel();
        jLabel.setHorizontalAlignment(0);
        jLabel.setText("images");
        jPanel2.add((Component)jLabel, "North");
        jPanel.add((Component)jPanel2, "North");
        System.out.println("=== Image XObject Viewer OPENED ===");
    }

    public void valueHasChanged(AbstractArgument abstractArgument) {
    }

    public void propertyChange(ChangeEvent changeEvent) {
        int n = Integer.parseInt(this.jSpinner.getValue().toString());
        if (n < 0) {
            n = 0;
            this.jSpinner.setValue("0");
        }
        if (n >= this.total_number_of_pictures) {
            n = this.total_number_of_pictures - 1;
            this.jSpinner.setValue(String.valueOf(n));
        }
        this.layout.show(this.image_panel, String.valueOf(n));
        this.image_panel.repaint();
    }

    public static void main(String[] stringArray) {
        ImageXRefViewer imageXRefViewer = new ImageXRefViewer();
        if (stringArray.length < 1) {
            System.err.println(imageXRefViewer.getUsage());
        }
        imageXRefViewer.setMainArguments(stringArray);
        imageXRefViewer.execute();
    }

    public void execute() {
        this.total_number_of_pictures = 0;
        try {
            if (this.getValue("srcfile") == null) {
                throw new InstantiationException("You need to choose a sourcefile");
            }
            EventDispatchingThread eventDispatchingThread = new EventDispatchingThread(){

                public Object construct() {
                    try {
                        PdfReader pdfReader = new PdfReader(((File)ImageXRefViewer.this.getValue("srcfile")).getAbsolutePath());
                        for (int i = 0; i < pdfReader.getXrefSize(); ++i) {
                            PdfStream pdfStream;
                            PdfObject pdfObject;
                            PdfObject pdfObject2 = pdfReader.getPdfObject(i);
                            if (pdfObject2 == null || !pdfObject2.isStream() || (pdfObject = (pdfStream = (PdfStream)pdfObject2).get(PdfName.SUBTYPE)) == null || !pdfObject.toString().equals(PdfName.IMAGE.toString())) continue;
                            System.out.println("total_number_of_pictures: " + ImageXRefViewer.this.total_number_of_pictures);
                            System.out.println("height:" + pdfStream.get(PdfName.HEIGHT));
                            System.out.println("width:" + pdfStream.get(PdfName.WIDTH));
                            System.out.println("bitspercomponent:" + pdfStream.get(PdfName.BITSPERCOMPONENT));
                            byte[] byArray = PdfReader.getStreamBytesRaw((PRStream)pdfStream);
                            Image image = Toolkit.getDefaultToolkit().createImage(byArray);
                            ImageIcon imageIcon = new ImageIcon(image);
                            JLabel jLabel = new JLabel();
                            jLabel.setIcon(imageIcon);
                            ImageXRefViewer.this.image_panel.add((Component)jLabel, String.valueOf(ImageXRefViewer.this.total_number_of_pictures++));
                        }
                    }
                    catch (InstantiationException instantiationException) {
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                    ImageXRefViewer.this.internalFrame.setCursor(Cursor.getDefaultCursor());
                    return null;
                }
            };
            this.internalFrame.setCursor(Cursor.getPredefinedCursor(3));
            eventDispatchingThread.start();
        }
        catch (Exception exception) {
            JOptionPane.showMessageDialog(this.internalFrame, exception.getMessage(), exception.getClass().getName(), 0);
            System.err.println(exception.getMessage());
        }
    }

    static {
        ImageXRefViewer.addVersion("$Id: ImageXRefViewer.java 3271 2008-04-18 20:39:42Z xlv $");
    }

    class SpinnerListener
    implements ChangeListener {
        private ImageXRefViewer adaptee;

        SpinnerListener(ImageXRefViewer imageXRefViewer2) {
            this.adaptee = imageXRefViewer2;
        }

        public void stateChanged(ChangeEvent changeEvent) {
            this.adaptee.propertyChange(changeEvent);
        }
    }
}

