/*
 * Decompiled with CFR 0.152.
 */
package com.lowagie.toolbox.arguments;

import com.lowagie.toolbox.AbstractTool;
import com.lowagie.toolbox.arguments.AbstractArgument;
import com.lowagie.toolbox.arguments.filters.DirFilter;
import com.lowagie.toolbox.swing.PdfInformationPanel;
import java.awt.event.ActionEvent;
import java.io.File;
import javax.swing.JFileChooser;
import javax.swing.filechooser.FileFilter;

public class FileArgument
extends AbstractArgument {
    protected FileFilter filter;
    protected boolean newFile;
    PdfInformationPanel label = null;

    public FileArgument() {
    }

    public FileArgument(AbstractTool abstractTool, String string, String string2, boolean bl, FileFilter fileFilter) {
        super(abstractTool, string, string2, null);
        this.newFile = bl;
        this.filter = fileFilter;
    }

    public FileArgument(AbstractTool abstractTool, String string, String string2, boolean bl) {
        this(abstractTool, string, string2, bl, null);
    }

    public Object getArgument() throws InstantiationException {
        if (this.value == null) {
            return null;
        }
        try {
            return new File(this.value.toString());
        }
        catch (Exception exception) {
            throw new InstantiationException(exception.getMessage());
        }
    }

    public void actionPerformed(ActionEvent actionEvent) {
        JFileChooser jFileChooser = new JFileChooser();
        if (this.filter != null) {
            jFileChooser.setFileFilter(this.filter);
            if (this.filter instanceof DirFilter) {
                jFileChooser.setFileSelectionMode(1);
            }
        }
        if (this.label != null) {
            jFileChooser.setAccessory(this.label);
            jFileChooser.addPropertyChangeListener("SelectedFileChangedProperty", this.label);
        }
        if (this.newFile) {
            jFileChooser.showSaveDialog(this.tool.getInternalFrame());
        } else {
            jFileChooser.showOpenDialog(this.tool.getInternalFrame());
        }
        try {
            this.setValue(jFileChooser.getSelectedFile());
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    public FileFilter getFilter() {
        return this.filter;
    }

    public void setFilter(FileFilter fileFilter) {
        this.filter = fileFilter;
    }

    public PdfInformationPanel getLabel() {
        return this.label;
    }

    public void setLabel(PdfInformationPanel pdfInformationPanel) {
        this.label = pdfInformationPanel;
    }
}

