/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.activity.internal.jaxrs;

import java.util.ArrayList;
import javax.ws.rs.NotFoundException;
import javax.ws.rs.core.Response;
import org.eclipse.osee.activity.api.ActivityEntry;
import org.eclipse.osee.activity.api.ActivityEntryId;
import org.eclipse.osee.activity.api.ActivityLog;
import org.eclipse.osee.activity.api.ActivityLogEndpoint;
import org.eclipse.osee.activity.api.ActivityType;
import org.eclipse.osee.activity.api.DefaultActivityType;
import org.eclipse.osee.framework.jdk.core.type.MutableBoolean;
import org.eclipse.osee.framework.jdk.core.util.Conditions;
import org.eclipse.osee.framework.jdk.core.util.Lib;

public final class ActivityLogResource
implements ActivityLogEndpoint {
    private final ActivityLog activityLog;

    public ActivityLogResource(ActivityLog activityLog) {
        this.activityLog = activityLog;
    }

    public ActivityEntry getEntry(Long entryId) {
        Conditions.checkNotNull((Object)entryId, (String)"activity entry id");
        final ActivityEntry entry = new ActivityEntry(entryId);
        final MutableBoolean found = new MutableBoolean(false);
        this.activityLog.queryEntry(entryId, new ActivityLog.ActivityDataHandler(){

            public void onData(Long entryId, Long parentId, Long typeId, Long accountId, Long serverId, Long clientId, Long startTime, Long duration, Integer status, String messageArgs) {
                found.setValue(true);
                entry.setAccountId(accountId);
                entry.setClientId(clientId);
                entry.setDuration(duration);
                entry.setMessageArgs(messageArgs);
                entry.setParentId(parentId);
                entry.setServerId(serverId);
                entry.setStartTime(startTime);
                entry.setStatus(status);
                entry.setTypeId(typeId);
            }
        });
        if (!found.getValue()) {
            throw new NotFoundException("Activity Entry for entry id [" + entryId + "] was not found");
        }
        return entry;
    }

    public ActivityEntryId createEntry(Long typeId, Long parentId, Integer status, String message) {
        Long entryId = this.activityLog.createEntry(typeId, parentId, status, new Object[]{message});
        ActivityEntryId entity = new ActivityEntryId(entryId);
        return entity;
    }

    public Response updateEntry(Long entryId, Integer statusId) {
        this.activityLog.updateEntry(entryId, statusId);
        return Response.ok().build();
    }

    public DefaultActivityType[] getActivityTypes() {
        final ArrayList types = new ArrayList();
        this.activityLog.queryActivityTypes(new ActivityLog.ActivityTypeDataHandler(){

            public void onData(Long typeId, Long logLevel, String module, String messageFormat) {
                DefaultActivityType type = new DefaultActivityType();
                type.setTypeId(typeId);
                type.setLogLevel(logLevel);
                type.setModule(module);
                type.setMessageFormat(messageFormat);
                types.add(type);
            }
        });
        return types.toArray(new DefaultActivityType[0]);
    }

    public DefaultActivityType getActivityType(Long typeId) {
        Conditions.checkNotNull((Object)typeId, (String)"activity type id");
        final MutableBoolean found = new MutableBoolean(false);
        final DefaultActivityType type = new DefaultActivityType();
        this.activityLog.queryActivityType(typeId, new ActivityLog.ActivityTypeDataHandler(){

            public void onData(Long typeId, Long logLevel, String module, String messageFormat) {
                found.setValue(true);
                type.setTypeId(typeId);
                type.setLogLevel(logLevel);
                type.setModule(module);
                type.setMessageFormat(messageFormat);
            }
        });
        if (!found.getValue()) {
            throw new NotFoundException("Activity Type for type id [" + typeId + "] was not found");
        }
        return type;
    }

    public DefaultActivityType createActivityType(Long typeId, Long logLevel, String module, String messageFormat) {
        if (!this.activityLog.activityTypeExists(typeId)) {
            return this.newActivityHelper(typeId, logLevel, module, messageFormat);
        }
        return this.getActivityType(typeId);
    }

    public DefaultActivityType createActivityType(Long logLevel, String module, String messageFormat) {
        Long typeId = Lib.generateUuid();
        return this.newActivityHelper(typeId, logLevel, module, messageFormat);
    }

    private DefaultActivityType newActivityHelper(Long typeId, Long logLevel, String module, String messageFormat) {
        DefaultActivityType type = new DefaultActivityType();
        type.setTypeId(typeId);
        type.setLogLevel(logLevel);
        type.setModule(module);
        type.setMessageFormat(messageFormat);
        this.activityLog.createActivityTypes(new ActivityType[]{type});
        return type;
    }
}

