/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.activity.internal.jaxrs;

import javax.annotation.Priority;
import javax.ws.rs.container.ContainerRequestContext;
import javax.ws.rs.container.ContainerRequestFilter;
import javax.ws.rs.container.PreMatching;
import javax.ws.rs.ext.Provider;
import org.eclipse.osee.activity.ActivityConstants;
import org.eclipse.osee.activity.api.Activity;
import org.eclipse.osee.activity.api.ActivityLog;
import org.eclipse.osee.activity.api.ActivityType;
import org.eclipse.osee.framework.jdk.core.util.Strings;
import org.eclipse.osee.logger.Log;

@PreMatching
@Priority(value=3000)
@Provider
public class ActivityLogRequestFilter
implements ContainerRequestFilter {
    private Log logger;
    private ActivityLog activityLog;

    public void setActivityLogger(ActivityLog activityLog) {
        this.activityLog = activityLog;
    }

    public void setLogger(Log logger) {
        this.logger = logger;
    }

    public void filter(ContainerRequestContext context) {
        if (this.activityLog.isEnabled()) {
            try {
                String message = String.format("%s %s", context.getMethod(), context.getUriInfo().getPath());
                Long serverId = this.getServerId(context);
                Long clientId = ActivityConstants.DEFAULT_CLIENT_ID;
                if (Strings.isNumeric((String)((String)context.getHeaders().getFirst((Object)"osee.client.id")))) {
                    clientId = Long.valueOf((String)context.getHeaders().getFirst((Object)"osee.client.id"));
                }
                Long accountId = ActivityConstants.DEFAULT_ACCOUNT_ID;
                if (Strings.isNumeric((String)((String)context.getHeaders().getFirst((Object)"osee.account.id")))) {
                    accountId = Long.valueOf((String)context.getHeaders().getFirst((Object)"osee.account.id"));
                }
                Long entryId = this.activityLog.createActivityThread((ActivityType)Activity.JAXRS_METHOD_CALL, accountId, serverId, clientId, new Object[]{message});
                context.setProperty("X-osee-activity-log-entryId", (Object)entryId);
            }
            catch (Throwable th) {
                this.logger.error(th, "Error during ActivityContainerRequestFilter", new Object[0]);
            }
        }
    }

    private Long getServerId(ContainerRequestContext context) {
        Long toReturn = ActivityConstants.DEFAULT_SERVER_ID;
        return toReturn;
    }
}

