/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.activity.internal;

import java.lang.management.ManagementFactory;
import java.lang.management.ThreadInfo;
import java.lang.management.ThreadMXBean;
import java.util.Arrays;

public class ThreadActivity {
    private final ThreadMXBean threadMxBean = ManagementFactory.getThreadMXBean();
    private static final int ConvertToMillSec = 1000000;

    public String getThreadActivity(int sampleWindowMs) {
        ThreadInfo[] threadInfos = this.threadMxBean.dumpAllThreads(false, false);
        ThreadStats[] threadStats = new ThreadStats[threadInfos.length];
        int i = 0;
        while (i < threadStats.length) {
            threadStats[i] = new ThreadStats(threadInfos[i], this.threadMxBean.getThreadCpuTime(threadInfos[i].getThreadId()));
            ++i;
        }
        StringBuilder sb = new StringBuilder(400);
        try {
            Thread.sleep(sampleWindowMs);
        }
        catch (InterruptedException ex) {
            sb.append(ex);
        }
        ThreadStats[] threadStatsArray = threadStats;
        int n = threadStats.length;
        int n2 = 0;
        while (n2 < n) {
            ThreadStats stat = threadStatsArray[n2];
            stat.setCpuTimeElapsed();
            ++n2;
        }
        Arrays.sort(threadStats, (t1, t2) -> Long.compare(t1.cpuTimeElapsed, t2.cpuTimeElapsed));
        int n3 = Math.max(threadStats.length - 15, 0);
        int i2 = threadStats.length - 1;
        while (i2 >= n3) {
            if (threadStats[i2].cpuTimeElapsed == 0L) break;
            sb.append(threadStats[i2].threadInfo.getThreadName());
            sb.append("(");
            sb.append(threadStats[i2].threadInfo.getThreadId());
            sb.append("), ");
            sb.append(threadStats[i2].cpuTimeElapsed / 1000000L);
            sb.append(", ");
            sb.append(threadStats[i2].cpuTime / 1000000L);
            sb.append(", ");
            StackTraceElement[] stackTrace = threadStats[i2].threadInfo.getStackTrace();
            if (stackTrace.length > 0) {
                int stackCount = Math.min(4, stackTrace.length);
                int j = 0;
                while (j < stackCount) {
                    sb.append(stackTrace[j]);
                    sb.append(' ');
                    ++j;
                }
            }
            sb.append("\n");
            --i2;
        }
        return sb.toString();
    }

    private class ThreadStats {
        final ThreadInfo threadInfo;
        long cpuTime;
        long cpuTimeElapsed;

        public ThreadStats(ThreadInfo threadInfo, long cpuTime) {
            this.threadInfo = threadInfo;
            this.cpuTime = cpuTime;
        }

        public void setCpuTimeElapsed() {
            long currentCpuTime = ThreadActivity.this.threadMxBean.getThreadCpuTime(this.threadInfo.getThreadId());
            this.cpuTimeElapsed = currentCpuTime - this.cpuTime;
            this.cpuTime = currentCpuTime;
        }
    }
}

