/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.activity.internal;

import java.util.Arrays;
import java.util.Calendar;
import java.util.function.Consumer;
import org.eclipse.osee.activity.ActivityStorage;
import org.eclipse.osee.activity.api.ActivityLog;
import org.eclipse.osee.activity.api.ActivityType;
import org.eclipse.osee.jdbc.JdbcClient;
import org.eclipse.osee.jdbc.JdbcService;
import org.eclipse.osee.jdbc.JdbcStatement;

public class DatabaseActivityStorage
implements ActivityStorage {
    private static final String SELECT_ENTRY = "SELECT * FROM osee_activity WHERE entry_id = ?";
    private static final String INSERT_ENTRIES = "INSERT INTO osee_activity (entry_id, parent_id, type_id, account_id, server_id, client_id, start_time, duration, status, msg_args) VALUES (?,?,?,?,?,?,?,?,?,?)";
    private static final String UPDATE_ENTRIES = "UPDATE osee_activity set status = ?, duration = ? where entry_id = ?";
    private static final String SELECT_ALL_TYPES = "SELECT * FROM osee_activity_type";
    private static final String SELECT_TYPE = "SELECT * FROM osee_activity_type WHERE type_id = ?";
    private static final String INSERT_TYPE = "INSERT INTO osee_activity_type (type_id, log_level, module, msg_format) VALUES (?,?,?,?)";
    private static final String COUNT_TYPE = "SELECT count(1) FROM osee_activity_type WHERE type_id = ?";
    private static final String DELETE_ENTRIES = "DELETE FROM osee_activity WHERE start_time <= ?";
    private JdbcService jdbcService;

    public void setJdbcService(JdbcService jdbcService) {
        this.jdbcService = jdbcService;
    }

    private JdbcClient getJdbcClient() {
        return this.jdbcService.getClient();
    }

    @Override
    public void selectEntry(Long entryId, ActivityLog.ActivityDataHandler handler) {
        this.getJdbcClient().runQuery((Consumer)new ActivityEntryProcessor(handler), SELECT_ENTRY, new Object[]{entryId});
    }

    @Override
    public int addEntries(Iterable<Object[]> newEntries) {
        return this.getJdbcClient().runBatchUpdate(INSERT_ENTRIES, newEntries);
    }

    @Override
    public int updateEntries(Iterable<Object[]> updatedEntries) {
        return this.getJdbcClient().runBatchUpdate(UPDATE_ENTRIES, updatedEntries);
    }

    private void addLogType(ActivityType type) {
        Long typeId = type.getTypeId();
        Long logLevel = type.getLogLevel();
        String module = type.getModule();
        String messageFormat = type.getMessageFormat();
        this.getJdbcClient().runPreparedUpdate(INSERT_TYPE, new Object[]{typeId, logLevel, module, messageFormat});
    }

    @Override
    public void addActivityTypes(ActivityType ... types) {
        this.addActivityTypes(Arrays.asList(types));
    }

    @Override
    public void addActivityTypes(Iterable<ActivityType> types) {
        for (ActivityType type : types) {
            this.addLogType(type);
        }
    }

    @Override
    public void selectTypes(ActivityLog.ActivityTypeDataHandler handler) {
        this.getJdbcClient().runQuery((Consumer)new ActivityTypeProcessor(handler), SELECT_ALL_TYPES, new Object[0]);
    }

    @Override
    public void selectType(Long typeId, ActivityLog.ActivityTypeDataHandler handler) {
        this.getJdbcClient().runQuery((Consumer)new ActivityTypeProcessor(handler), SELECT_TYPE, new Object[]{typeId});
    }

    @Override
    public boolean typeExists(Long typeId) {
        return (Long)this.getJdbcClient().fetch((Object)-1L, COUNT_TYPE, new Object[]{typeId}) > 0L;
    }

    @Override
    public void cleanEntries(int daysToKeep) {
        Calendar cal = Calendar.getInstance();
        if (daysToKeep > 0) {
            daysToKeep = -daysToKeep;
        }
        cal.add(5, daysToKeep);
        this.getJdbcClient().runPreparedUpdate(DELETE_ENTRIES, new Object[]{cal.getTimeInMillis()});
    }

    private static class ActivityEntryProcessor
    implements Consumer<JdbcStatement> {
        private final ActivityLog.ActivityDataHandler handler;

        public ActivityEntryProcessor(ActivityLog.ActivityDataHandler handler) {
            this.handler = handler;
        }

        @Override
        public void accept(JdbcStatement chStmt) {
            Long entryId = chStmt.getLong("entry_id");
            Long parentId = chStmt.getLong("parent_id");
            Long typeId = chStmt.getLong("type_id");
            Long accountId = chStmt.getLong("account_id");
            Long serverId = chStmt.getLong("server_id");
            Long clientId = chStmt.getLong("client_id");
            Long startTime = chStmt.getLong("start_time");
            Long duration = chStmt.getLong("duration");
            Integer status = chStmt.getInt("status");
            String messageArgs = chStmt.getString("msg_args");
            this.handler.onData(entryId, parentId, typeId, accountId, serverId, clientId, startTime, duration, status, messageArgs);
        }
    }

    private static class ActivityTypeProcessor
    implements Consumer<JdbcStatement> {
        private final ActivityLog.ActivityTypeDataHandler handler;

        public ActivityTypeProcessor(ActivityLog.ActivityTypeDataHandler handler) {
            this.handler = handler;
        }

        @Override
        public void accept(JdbcStatement chStmt) {
            Long typeId = chStmt.getLong("type_id");
            Long logLevel = chStmt.getLong("log_level");
            String module = chStmt.getString("module");
            String messageFormat = chStmt.getString("msg_format");
            this.handler.onData(typeId, logLevel, module, messageFormat);
        }
    }
}

