/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.activity.internal;

import java.util.Iterator;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.eclipse.osee.activity.internal.ActivityMonitor;

public final class ActivityMonitorImpl
implements ActivityMonitor {
    private final ConcurrentHashMap<Thread, Object[]> threadToUser = new ConcurrentHashMap();

    @Override
    public Object[] getThreadRootEntry() {
        return this.threadToUser.get(Thread.currentThread());
    }

    @Override
    public synchronized Iterable<Thread> getActiveThreads() {
        Set threads = this.threadToUser.keySet();
        Iterator threadIter = threads.iterator();
        while (threadIter.hasNext()) {
            if (((Thread)threadIter.next()).isAlive()) continue;
            threadIter.remove();
        }
        return threads;
    }

    @Override
    public void addActivityThread(Object[] activityEntry) {
        this.threadToUser.put(Thread.currentThread(), activityEntry);
    }

    @Override
    public void removeActivityThread() {
        this.threadToUser.remove(Thread.currentThread());
    }
}

