/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.activity.internal;

import java.net.UnknownHostException;
import java.util.Calendar;
import java.util.HashMap;
import java.util.Map;
import java.util.Random;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import org.eclipse.osee.activity.ActivityConstants;
import org.eclipse.osee.activity.ActivityStorage;
import org.eclipse.osee.activity.api.Activity;
import org.eclipse.osee.activity.api.ActivityLog;
import org.eclipse.osee.activity.api.ActivityType;
import org.eclipse.osee.activity.internal.ActivityMonitorImpl;
import org.eclipse.osee.activity.internal.ActivityUtil;
import org.eclipse.osee.activity.internal.ThreadActivity;
import org.eclipse.osee.executor.admin.ExecutorAdmin;
import org.eclipse.osee.framework.core.data.OrcsTypesData;
import org.eclipse.osee.framework.core.enums.SystemUser;
import org.eclipse.osee.framework.jdk.core.type.DrainingIterator;
import org.eclipse.osee.framework.jdk.core.type.Id;
import org.eclipse.osee.framework.jdk.core.type.OseeArgumentException;
import org.eclipse.osee.framework.jdk.core.util.Collections;
import org.eclipse.osee.framework.jdk.core.util.Lib;
import org.eclipse.osee.framework.jdk.core.util.Network;
import org.eclipse.osee.framework.jdk.core.util.Strings;
import org.eclipse.osee.logger.Log;
import org.eclipse.osee.orcs.SystemPreferences;

public class ActivityLogImpl
implements ActivityLog,
Callable<Void> {
    private static final int HALF_HOUR = 1800000;
    private static final int FIVE_MINUTES = 300000;
    private final ConcurrentHashMap<Long, Object[]> newEntities = new ConcurrentHashMap();
    private final ConcurrentHashMap<Long, Object[]> updatedEntities = new ConcurrentHashMap();
    private final ThreadActivity threadActivity = new ThreadActivity();
    private static final Object[] EMPTY_ARRAY = new Object[0];
    private Log logger;
    private ExecutorAdmin executorAdmin;
    private ActivityStorage storage;
    private SystemPreferences preferences;
    private final AtomicBoolean initialized = new AtomicBoolean(false);
    private ActivityMonitorImpl activityMonitor;
    private volatile long freshnessMillis;
    private volatile int exceptionLineCount;
    private volatile int executorPoolSize;
    private volatile long lastFlushTime;
    private volatile int cleanerKeepDays;
    private volatile boolean enabled = ActivityConstants.DEFAULT_ACTIVITY_LOGGER__ENABLED;

    public void setLogger(Log logger) {
        this.logger = logger;
    }

    public void setActivityStorage(ActivityStorage storage) {
        this.storage = storage;
    }

    public void setExecutorAdmin(ExecutorAdmin executorAdmin) {
        this.executorAdmin = executorAdmin;
    }

    public void setSystemPreferences(SystemPreferences preferences) {
        this.preferences = preferences;
    }

    public void start(Map<String, Object> properties) throws Exception {
        this.activityMonitor = new ActivityMonitorImpl();
        this.executorAdmin.schedule(this::continuouslyLogThreadActivity);
        this.update(properties);
    }

    private Void continuouslyLogThreadActivity() {
        Long port;
        String portString = System.getProperty("org.osgi.service.http.port");
        try {
            port = Long.valueOf(portString);
        }
        catch (Exception exception) {
            port = Id.SENTINEL;
        }
        String host = "";
        try {
            host = Network.getValidIP().getCanonicalHostName();
        }
        catch (UnknownHostException ex) {
            this.logger.warn((Throwable)ex, "Error getting host for start of tread activity logging", new Object[0]);
        }
        Long threadActivityParententryId = this.createActivityThread((ActivityType)Activity.THREAD_ACTIVITY, SystemUser.OseeSystem.getId(), port, ActivityConstants.DEFAULT_CLIENT_ID, "Start of thread activity logging thread on " + host);
        while (true) {
            String sampleWindowMsStr;
            int sampleWindowMs;
            String threadActivity;
            if ((threadActivity = this.getThreadActivity(sampleWindowMs = Strings.isValid((String)(sampleWindowMsStr = this.preferences.getCachedValue("thread.activity.sample.window." + OrcsTypesData.OSEE_TYPE_VERSION, 1800000L))) ? Integer.parseInt(sampleWindowMsStr) : 300000)).isEmpty()) {
                continue;
            }
            this.createEntry((ActivityType)Activity.THREAD_ACTIVITY, threadActivityParententryId, COMPLETE_STATUS, threadActivity);
        }
    }

    public void stop() {
        this.flush(true);
        try {
            this.executorAdmin.shutdown(ActivityConstants.ACTIVITY_LOGGER__EXECUTOR_ID);
        }
        catch (Throwable th) {
            this.logger.error(th, "Error shutting down executor [%s]", new Object[]{ActivityConstants.ACTIVITY_LOGGER__EXECUTOR_ID});
        }
    }

    public void queryEntry(Long entryId, ActivityLog.ActivityDataHandler handler) {
        this.storage.selectEntry(entryId, handler);
    }

    public void update(Map<String, Object> properties) {
        int newCleanerKeepDays;
        block14: {
            this.freshnessMillis = ActivityUtil.get(properties, ActivityConstants.ACTIVITY_LOGGER__WRITE_RATE_IN_MILLIS, ActivityConstants.DEFAULT_ACTIVITY_LOGGER__WRITE_RATE_IN_MILLIS);
            this.exceptionLineCount = ActivityUtil.get(properties, ActivityConstants.ACTIVITY_LOGGER__STACKTRACE_LINE_COUNT, ActivityConstants.DEFAULT_ACTIVITY_LOGGER__STACKTRACE_LINE_COUNT);
            int newExecutorPoolSize = ActivityUtil.get(properties, ActivityConstants.ACTIVITY_LOGGER__EXECUTOR_POOL_SIZE, ActivityConstants.DEFAULT_ACTIVITY_LOGGER__EXECUTOR_POOL_SIZE);
            String value = (String)properties.get(ActivityConstants.ACTIVITY_LOGGER__ENABLED);
            newCleanerKeepDays = ActivityUtil.get(properties, ActivityConstants.ACTIVITY_LOGGER__CLEANER_KEEP_DAYS, ActivityConstants.DEFAULT_ACTIVITY_LOGGER__CLEANER_KEEP_DAYS);
            if (Strings.isValid((String)value)) {
                this.enabled = Boolean.valueOf(value);
            }
            if (newExecutorPoolSize != this.executorPoolSize) {
                this.executorPoolSize = newExecutorPoolSize;
                try {
                    try {
                        this.executorAdmin.shutdown(ActivityConstants.ACTIVITY_LOGGER__EXECUTOR_ID);
                    }
                    catch (Throwable th) {
                        this.logger.error(th, "Error shutting down executor [%s]", new Object[]{ActivityConstants.ACTIVITY_LOGGER__EXECUTOR_ID});
                        try {
                            this.executorAdmin.createFixedPoolExecutor(ActivityConstants.ACTIVITY_LOGGER__EXECUTOR_ID, this.executorPoolSize);
                        }
                        catch (Throwable th2) {
                            this.logger.error(th2, "Error creating new executor for [%s]", new Object[]{ActivityConstants.ACTIVITY_LOGGER__EXECUTOR_ID});
                        }
                        break block14;
                    }
                }
                catch (Throwable throwable) {
                    try {
                        this.executorAdmin.createFixedPoolExecutor(ActivityConstants.ACTIVITY_LOGGER__EXECUTOR_ID, this.executorPoolSize);
                    }
                    catch (Throwable th) {
                        this.logger.error(th, "Error creating new executor for [%s]", new Object[]{ActivityConstants.ACTIVITY_LOGGER__EXECUTOR_ID});
                    }
                    throw throwable;
                }
                try {
                    this.executorAdmin.createFixedPoolExecutor(ActivityConstants.ACTIVITY_LOGGER__EXECUTOR_ID, this.executorPoolSize);
                }
                catch (Throwable th) {
                    this.logger.error(th, "Error creating new executor for [%s]", new Object[]{ActivityConstants.ACTIVITY_LOGGER__EXECUTOR_ID});
                }
            }
        }
        if (newCleanerKeepDays != this.cleanerKeepDays) {
            this.cleanerKeepDays = newCleanerKeepDays;
            this.setupCleaner();
        }
    }

    private void setupCleaner() {
        Callable<Void> cleaner = new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                ActivityLogImpl.this.storage.cleanEntries(ActivityLogImpl.this.cleanerKeepDays);
                return null;
            }
        };
        Random random = new Random();
        Calendar start = Calendar.getInstance();
        start.set(11, random.nextInt(4));
        start.set(12, random.nextInt(180));
        int day = start.get(6);
        start.set(6, day + 1);
        long startMil = start.getTimeInMillis();
        long curMil = System.currentTimeMillis();
        long startAfter = TimeUnit.MILLISECONDS.toMinutes(startMil - curMil);
        this.executorAdmin.shutdown(ActivityConstants.ACTIVITY_LOGGER__CLEANER_EXECUTOR_ID);
        this.executorAdmin.scheduleAtFixedRate(ActivityConstants.ACTIVITY_LOGGER__CLEANER_EXECUTOR_ID, (Callable)cleaner, startAfter, 1440L, TimeUnit.MINUTES);
    }

    public Long createEntry(ActivityType type, Object ... messageArgs) {
        return this.createEntry(type.getTypeId(), COMPLETE_STATUS, messageArgs);
    }

    public Long createUpdateableEntry(ActivityType type, Object ... messageArgs) {
        return this.createEntry(type.getTypeId(), INITIAL_STATUS, messageArgs);
    }

    public Long createEntry(ActivityType type, Long parentId, Integer status, Object ... messageArgs) {
        return this.createEntry(type.getTypeId(), parentId, status, messageArgs);
    }

    public Long createEntry(Long typeId, Integer status, Object ... messageArgs) {
        if (this.enabled) {
            Object[] threadRootEntry = this.activityMonitor.getThreadRootEntry();
            Long entryId = threadRootEntry == null ? LogEntry.SENTINAL : LogEntry.ENTRY_ID.from(threadRootEntry);
            return this.createEntry(typeId, entryId, status, messageArgs);
        }
        return 0L;
    }

    public Long createEntry(Long typeId, Long parentId, Integer status, Object ... messageArgs) {
        if (this.enabled) {
            Object[] rootEntry = this.activityMonitor.getThreadRootEntry();
            Long accountId = rootEntry == null ? LogEntry.SENTINAL : LogEntry.ACCOUNT_ID.from(rootEntry);
            Long serverId = rootEntry == null ? LogEntry.SENTINAL : LogEntry.SERVER_ID.from(rootEntry);
            Long clientId = rootEntry == null ? LogEntry.SENTINAL : LogEntry.CLIENT_ID.from(rootEntry);
            Object[] entry = this.createEntry(parentId, typeId, accountId, serverId, clientId, this.computeDuration(), status, messageArgs);
            return LogEntry.ENTRY_ID.from(entry);
        }
        return 0L;
    }

    public Long createEntry(Long accountId, Long clientId, Long typeId, Long parentId, Integer status, String ... messageArgs) {
        Object[] rootEntry = this.activityMonitor.getThreadRootEntry();
        Long serverId = LogEntry.SERVER_ID.from(rootEntry);
        Object[] entry = this.createEntry(parentId, typeId, accountId, serverId, clientId, this.computeDuration(), status, (Object[])messageArgs);
        return LogEntry.ENTRY_ID.from(entry);
    }

    private Object[] createEntry(Long parentId, Long typeId, Long accountId, Long serverId, Long clientId, Long duration, Integer status, Object ... messageArgs) {
        Object[] entry = EMPTY_ARRAY;
        if (this.enabled) {
            try {
                Long entryId = Lib.generateUuid();
                Long startTime = System.currentTimeMillis();
                String fullMsg = null;
                String messageFormat = this.getTypeMessageFormat(typeId);
                fullMsg = Strings.isValid((String)messageFormat) ? String.format(messageFormat, messageArgs) : Collections.toString((String)"\n", (Object[])messageArgs);
                String msg = fullMsg.substring(0, Math.min(fullMsg.length(), 4000));
                entry = new Object[]{entryId, parentId, typeId, accountId, serverId, clientId, startTime, duration, status, msg};
                this.newEntities.put(entryId, entry);
                if (fullMsg.length() > 4000) {
                    Long parentCursor = entryId;
                    int i = 4000;
                    while (i < fullMsg.length()) {
                        Long continueEntryId = Lib.generateUuid();
                        Object[] continueEntry = new Object[]{continueEntryId, parentCursor, Activity.MSG_CONTINUATION.getTypeId(), accountId, serverId, clientId, startTime, duration, status, fullMsg.substring(i, Math.min(fullMsg.length(), i + 4000))};
                        this.newEntities.put(continueEntryId, continueEntry);
                        parentCursor = continueEntryId;
                        i += 4000;
                    }
                }
                this.flush(false);
            }
            catch (Throwable th) {
                this.logger.error(th, "Error ActivityLog.createEntry", new Object[0]);
            }
        }
        return entry;
    }

    private String getTypeMessageFormat(Long typeId) {
        return new ActivityTypeMessageRetriever(typeId).get();
    }

    public Long createThrowableEntry(ActivityType type, Throwable throwable) {
        Long entryId = -1L;
        if (this.enabled) {
            try {
                String message = ActivityUtil.captureStackTrace(throwable, this.exceptionLineCount);
                entryId = this.createEntry(type.getTypeId(), ABNORMALLY_ENDED_STATUS, message);
            }
            catch (Throwable th) {
                this.logger.error(th, "logging failed in ActivityLogImpl.createThrowableEntry", new Object[0]);
            }
        }
        return entryId;
    }

    public boolean updateEntry(Long entryId, Integer status) {
        boolean modified = false;
        if (this.enabled) {
            try {
                if (!this.updateIfNew(entryId, status)) {
                    Object[] data = this.updatedEntities.get(entryId);
                    if (data == null || data.length < LogEntry.STATUS.ordinal()) {
                        this.addUpdatedEntryToMap(entryId, status);
                    } else {
                        data[LogEntry.STATUS.ordinal()] = status;
                        if (!this.updatedEntities.containsKey(entryId)) {
                            this.addUpdatedEntryToMap(entryId, status);
                        }
                    }
                    modified = true;
                }
            }
            catch (Throwable th) {
                this.logger.error(th, "Error in ActivityLog.updateEntry", new Object[0]);
            }
        }
        return modified;
    }

    private void addUpdatedEntryToMap(Long entryId, Integer status) {
        this.updatedEntities.put(entryId, new Object[]{status, this.computeDuration(), entryId});
    }

    private Long computeDuration() {
        long timeOfUpdate = System.currentTimeMillis();
        Object[] rootEntry = this.activityMonitor.getThreadRootEntry();
        timeOfUpdate = rootEntry == null ? LogEntry.SENTINAL : timeOfUpdate - LogEntry.START_TIME.from(rootEntry);
        return timeOfUpdate;
    }

    private boolean updateIfNew(Long entryId, Integer status) {
        Object[] data = this.newEntities.get(entryId);
        if (data == null) {
            return false;
        }
        data[LogEntry.STATUS.ordinal()] = status;
        data[LogEntry.DURATION.ordinal()] = this.computeDuration();
        return this.newEntities.containsKey(entryId);
    }

    @Override
    public Void call() {
        if (this.enabled) {
            if (!this.initialized.getAndSet(true)) {
                this.initialize();
            }
            if (!this.newEntities.isEmpty()) {
                try {
                    this.storage.addEntries((Iterable<Object[]>)new DrainingIterator(this.newEntities.values().iterator()));
                }
                catch (Throwable ex) {
                    this.logger.error(ex, "Exception while storing updates to the activity log", new Object[0]);
                }
            }
            if (!this.updatedEntities.isEmpty()) {
                try {
                    this.storage.updateEntries((Iterable<Object[]>)new DrainingIterator(this.updatedEntities.values().iterator()));
                }
                catch (Throwable ex) {
                    this.logger.error(ex, "Exception while storing updates to the activity log", new Object[0]);
                }
            }
        } else {
            this.newEntities.clear();
            this.updatedEntities.clear();
        }
        return null;
    }

    private void flush(boolean force) {
        long currentTime = System.currentTimeMillis();
        if (force || currentTime - this.lastFlushTime > this.freshnessMillis) {
            try {
                try {
                    this.executorAdmin.schedule(ActivityConstants.ACTIVITY_LOGGER__EXECUTOR_ID, (Callable)this);
                }
                catch (Exception ex) {
                    this.logger.error((Throwable)ex, "Error scheduling activity log callable", new Object[0]);
                    this.lastFlushTime = currentTime;
                }
            }
            finally {
                this.lastFlushTime = currentTime;
            }
        }
    }

    private void initialize() {
        try {
            final HashMap<Long, Activity> types = new HashMap<Long, Activity>(4);
            Activity[] activityArray = Activity.values();
            int n = activityArray.length;
            int n2 = 0;
            while (n2 < n) {
                Activity type = activityArray[n2];
                types.put(type.getTypeId(), type);
                ++n2;
            }
            this.storage.selectTypes(new ActivityLog.ActivityTypeDataHandler(){

                public void onData(Long typeId, Long logLevel, String module, String messageFormat) {
                    types.remove(typeId);
                }
            });
            if (!types.isEmpty()) {
                this.storage.addActivityTypes(types.values());
            }
        }
        catch (Throwable ex) {
            this.initialized.set(false);
            this.logger.error(ex, "Exception while initializing activity types", new Object[0]);
        }
    }

    public void completeEntry(Long entryId) {
        this.updateEntry(entryId, COMPLETE_STATUS);
    }

    public void endEntryAbnormally(Long entryId) {
        this.updateEntry(entryId, ABNORMALLY_ENDED_STATUS);
    }

    public void endEntryAbnormally(Long entryId, Integer status) {
        if (status > COMPLETE_STATUS) {
            this.updateEntry(entryId, status);
        } else {
            this.endEntryAbnormally(entryId);
        }
    }

    public Long createActivityThread(ActivityType type, Long accountId, Long serverId, Long clientId, Object ... messageArgs) {
        return this.createActivityThread(ActivityConstants.ROOT_ENTRY_ID, type, accountId, serverId, clientId, messageArgs);
    }

    public Long createActivityThread(Long parentId, ActivityType type, Long accountId, Long serverId, Long clientId, Object ... messageArgs) {
        Object[] entry = this.createEntry(parentId, type.getTypeId(), accountId, serverId, clientId, 0L, 0, messageArgs);
        this.activityMonitor.addActivityThread(entry);
        return LogEntry.ENTRY_ID.from(entry);
    }

    public void createActivityTypes(ActivityType ... types) {
        this.storage.addActivityTypes(types);
    }

    public void queryActivityType(Long typeId, ActivityLog.ActivityTypeDataHandler handler) {
        this.storage.selectType(typeId, handler);
    }

    public boolean activityTypeExists(Long typeId) {
        return this.storage.typeExists(typeId);
    }

    public void queryActivityTypes(ActivityLog.ActivityTypeDataHandler handler) {
        this.storage.selectTypes(handler);
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public void unInitialize() {
        this.initialized.set(false);
    }

    public String getThreadActivity(int sampleWindowMs) {
        return this.threadActivity.getThreadActivity(sampleWindowMs);
    }

    private class ActivityTypeMessageRetriever
    implements ActivityLog.ActivityTypeDataHandler {
        private final Long typeId;
        private String messageFormat = null;

        public ActivityTypeMessageRetriever(Long typeId) {
            this.typeId = typeId;
        }

        public void onData(Long typeId, Long logLevel, String module, String messageFormat) {
            this.messageFormat = messageFormat;
        }

        public String get() {
            ActivityLogImpl.this.queryActivityType(this.typeId, this);
            return this.messageFormat;
        }
    }

    public static enum LogEntry {
        ENTRY_ID,
        PARENT_ID,
        TYPE_ID,
        ACCOUNT_ID,
        SERVER_ID,
        CLIENT_ID,
        START_TIME,
        DURATION,
        STATUS,
        MESSAGE_ARGS;

        public static final Long SENTINAL;

        static {
            SENTINAL = -1L;
        }

        Long from(Object[] entry) {
            Object obj = entry[this.ordinal()];
            if (obj instanceof Long) {
                return (Long)entry[this.ordinal()];
            }
            throw new OseeArgumentException("LogEntryIndex.from may only be used with values of type Long", new Object[0]);
        }
    }
}

