/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.ats.dsl.validation;

import java.util.HashSet;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.osee.ats.dsl.AttributeResolverService;
import org.eclipse.osee.ats.dsl.atsDsl.AtsDsl;
import org.eclipse.osee.ats.dsl.atsDsl.AtsDslPackage;
import org.eclipse.osee.ats.dsl.atsDsl.AttrDef;
import org.eclipse.osee.ats.dsl.atsDsl.AttrWidget;
import org.eclipse.osee.ats.dsl.atsDsl.Composite;
import org.eclipse.osee.ats.dsl.atsDsl.CreateTaskRule;
import org.eclipse.osee.ats.dsl.atsDsl.LayoutDef;
import org.eclipse.osee.ats.dsl.atsDsl.LayoutItem;
import org.eclipse.osee.ats.dsl.atsDsl.LayoutType;
import org.eclipse.osee.ats.dsl.atsDsl.ReviewRule;
import org.eclipse.osee.ats.dsl.atsDsl.StateDef;
import org.eclipse.osee.ats.dsl.atsDsl.ToState;
import org.eclipse.osee.ats.dsl.atsDsl.WidgetDef;
import org.eclipse.osee.ats.dsl.atsDsl.WorkDef;
import org.eclipse.osee.ats.dsl.validation.AbstractAtsDslJavaValidator;
import org.eclipse.osee.ats.dsl.validation.AtsNamesAreUniqueValidator;
import org.eclipse.osee.framework.jdk.core.type.OseeCoreException;
import org.eclipse.osee.framework.jdk.core.util.Strings;
import org.eclipse.xtext.validation.Check;
import org.eclipse.xtext.validation.ComposedChecks;
import org.eclipse.xtext.validation.ImportUriValidator;

@ComposedChecks(validators={ImportUriValidator.class, AtsNamesAreUniqueValidator.class})
public class AtsDslJavaValidator
extends AbstractAtsDslJavaValidator {
    @Check
    public void checkPercentWeights(AtsDsl atsDsl) {
        if (atsDsl.getWorkDef() == null) {
            return;
        }
        int weight = 0;
        for (WorkDef workDef : atsDsl.getWorkDef()) {
            for (StateDef state : workDef.getStates()) {
                weight += state.getPercentWeight();
            }
            if (weight == 0 || weight == 100) continue;
            for (StateDef state : workDef.getStates()) {
                String message = String.format("State Percent Weights must add to 0 or 100; currently [%s].", weight);
                this.error(message, state, (EStructuralFeature)AtsDslPackage.Literals.STATE_DEF__PERCENT_WEIGHT, 8, "percent_weights", new String[0]);
            }
        }
    }

    @Check
    public void checkOrdinalUnique(AtsDsl atsDsl) {
        if (atsDsl.getWorkDef() == null) {
            return;
        }
        HashSet<Integer> ordinals = new HashSet<Integer>();
        for (WorkDef workDef : atsDsl.getWorkDef()) {
            for (StateDef state : workDef.getStates()) {
                if (ordinals.contains(state.getOrdinal())) {
                    String message = String.format("Ordinals must be unique [%s].", state.getOrdinal());
                    this.error(message, state, (EStructuralFeature)AtsDslPackage.Literals.STATE_DEF__ORDINAL, 3, "unique_ordinals", new String[0]);
                    continue;
                }
                ordinals.add(state.getOrdinal());
            }
        }
    }

    @Check
    public void checkDefaultToState(AtsDsl atsDsl) {
        if (atsDsl.getWorkDef() == null) {
            return;
        }
        for (WorkDef workDef : atsDsl.getWorkDef()) {
            for (StateDef state : workDef.getStates()) {
                ToState asDefaultToState = null;
                for (ToState toState : state.getTransitionStates()) {
                    String message;
                    if (toState.getOptions().contains((Object)"AsDefault")) {
                        if (asDefaultToState != null) {
                            message = String.format("Only One AsDefault state allowed [%s].", toState.getState().getName());
                            this.error(message, toState, (EStructuralFeature)AtsDslPackage.Literals.STATE_DEF__TRANSITION_STATES, 4, "single_as_default", new String[0]);
                        } else {
                            asDefaultToState = toState;
                        }
                    }
                    if (toState.getState() == null || toState.getState().getName() == null || !toState.getState().getName().equals(state.getName())) continue;
                    message = String.format("State should not transition to itself [%s].", toState.getState().getName());
                    this.error(message, toState, (EStructuralFeature)AtsDslPackage.Literals.STATE_DEF__TRANSITION_STATES, 4, "no_transition_to_self", new String[0]);
                }
            }
        }
    }

    @Check
    public void checkAttributeNameValidity(AtsDsl atsDsl) {
        if (atsDsl.getWorkDef() == null) {
            return;
        }
        for (WorkDef workDef : atsDsl.getWorkDef()) {
            for (WidgetDef widget : workDef.getWidgetDefs()) {
                String attributeName = widget.getAttributeName();
                this.validateAttributeName(attributeName, widget, (EStructuralFeature)AtsDslPackage.Literals.WIDGET_DEF__ATTRIBUTE_NAME, 1);
            }
        }
        for (WorkDef workDef : atsDsl.getWorkDef()) {
            for (StateDef state : workDef.getStates()) {
                LayoutType layout = state.getLayout();
                if (!(layout instanceof LayoutDef)) continue;
                this.validateAttributeNames(((LayoutDef)layout).getLayoutItems());
            }
        }
    }

    @Check
    public void checkAttributeNameValidity(CreateTaskRule createRule) {
        if (createRule.getAttributes().isEmpty()) {
            return;
        }
        for (AttrDef attribute : createRule.getAttributes()) {
            this.validateAttributeName(Strings.unquote((String)attribute.getName()), createRule, (EStructuralFeature)AtsDslPackage.Literals.CREATE_TASK_RULE__ATTRIBUTES, 8);
        }
    }

    @Check
    public void checkAttributeNameValidity(ReviewRule reviewRule) {
        if (reviewRule.getAttributes().isEmpty()) {
            return;
        }
        for (AttrDef attribute : reviewRule.getAttributes()) {
            this.validateAttributeName(Strings.unquote((String)attribute.getName()), reviewRule, (EStructuralFeature)AtsDslPackage.Literals.REVIEW_RULE__ATTRIBUTES, 8);
        }
    }

    private void validateAttributeNames(EList<LayoutItem> layoutItems) {
        for (LayoutItem item : layoutItems) {
            if (item instanceof AttrWidget) {
                this.validateAttributeName(((AttrWidget)item).getAttributeName(), item, (EStructuralFeature)AtsDslPackage.Literals.ATTR_WIDGET__ATTRIBUTE_NAME, 0);
                continue;
            }
            if (!(item instanceof Composite)) continue;
            this.validateAttributeNames(((Composite)item).getLayoutItems());
        }
    }

    private void validateAttributeName(String attributeName, EObject source, EStructuralFeature eFeature, int feature) {
        if (Strings.isValid((String)attributeName)) {
            try {
                boolean valid = AttributeResolverService.get().getAttributeResolver().isAttributeNamed(attributeName);
                if (!valid) {
                    String message = String.format("Attribute type [%s] not defined in database .", attributeName);
                    this.warning(message, source, eFeature, feature, "attribute_type_undefined", new String[0]);
                }
            }
            catch (OseeCoreException ex) {
                String message = String.format("Exception [%s] accessing attribute type [%s].", ex.getLocalizedMessage(), attributeName);
                this.error(message, source, eFeature, feature, "attribute_type_exception", new String[0]);
                return;
            }
        }
    }
}

