/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.ats.dsl.formatting;

import java.util.Arrays;
import java.util.List;
import java.util.Stack;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.osee.ats.dsl.services.AtsDslGrammarAccess;
import org.eclipse.xtext.AbstractElement;
import org.eclipse.xtext.GrammarUtil;
import org.eclipse.xtext.Keyword;
import org.eclipse.xtext.formatting.IIndentationInformation;
import org.eclipse.xtext.formatting.impl.AbstractDeclarativeFormatter;
import org.eclipse.xtext.formatting.impl.FormattingConfig;

public class AtsDslFormatter
extends AbstractDeclarativeFormatter
implements IIndentationInformation {
    private final List<String> KEYWORDS = Arrays.asList("attributeName", "version", "staticId", "baselineBranchUuid", "workDefinition", "teamDefinition", "privileged", "userDefinition", "actionableItem", "allowCreateBranch", "allowCommitBranch", "isAdmin", "userId", "email", "children", "released", "next", "team", "member", "lead", "xWidgetName", "defaultValue", "height", "option", "id", "description", "layoutCopyFrom", "attributeWidget", "to", "ordinal", "layout", "composite", "startState", "rule", "widget", "relatedToState", "blockingType", "decisionReview", "onEvent", "peerReview", "autoTransitionToDecision", "numColumns");

    private boolean isKeywordEntry(String current) {
        return this.KEYWORDS.contains(current);
    }

    protected void configureFormatting(FormattingConfig c) {
        AtsDslGrammarAccess access = (AtsDslGrammarAccess)this.getGrammarAccess();
        c.setAutoLinewrap(120);
        List keywords = GrammarUtil.containedKeywords((EObject)access.getGrammar());
        Stack<Keyword> openBraceStack = new Stack<Keyword>();
        for (Keyword currentKeyword : keywords) {
            String current = currentKeyword.getValue();
            if ("{".equals(current)) {
                openBraceStack.add(currentKeyword);
                c.setLinewrap().after((EObject)currentKeyword);
                continue;
            }
            if ("}".equals(current)) {
                c.setLinewrap().before((EObject)currentKeyword);
                c.setLinewrap().after((EObject)currentKeyword);
                if (openBraceStack.isEmpty()) continue;
                c.setIndentation((AbstractElement)openBraceStack.pop(), (AbstractElement)currentKeyword);
                continue;
            }
            if (";".equals(current)) {
                c.setSpace("").before((EObject)currentKeyword);
                c.setLinewrap(1).after((EObject)currentKeyword);
                continue;
            }
            if ("state".equals(current)) {
                c.setLinewrap(2).before((EObject)currentKeyword);
                continue;
            }
            if ("widgetDefinition".equals(current)) {
                c.setLinewrap(2).before((EObject)currentKeyword);
                continue;
            }
            if ("teamDefinition".equals(current)) {
                c.setLinewrap(2).before((EObject)currentKeyword);
                continue;
            }
            if (!this.isKeywordEntry(current)) continue;
            c.setLinewrap().before((EObject)currentKeyword);
        }
        c.setLinewrap(0, 1, 2).before((EObject)access.getSL_COMMENTRule());
        c.setLinewrap(0, 1, 2).before((EObject)access.getML_COMMENTRule());
        c.setLinewrap(0, 1, 1).after((EObject)access.getML_COMMENTRule());
    }

    public String getIndentString() {
        return "   ";
    }
}

