/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.ats.dsl.atsDsl;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.Enumerator;

public enum BooleanDef implements Enumerator
{
    NONE(0, "None", "None"),
    TRUE(1, "True", "True"),
    FALSE(2, "False", "False");

    public static final int NONE_VALUE = 0;
    public static final int TRUE_VALUE = 1;
    public static final int FALSE_VALUE = 2;
    private static final BooleanDef[] VALUES_ARRAY;
    public static final List<BooleanDef> VALUES;
    private final int value;
    private final String name;
    private final String literal;

    static {
        VALUES_ARRAY = new BooleanDef[]{NONE, TRUE, FALSE};
        VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));
    }

    public static BooleanDef get(String literal) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            BooleanDef result = VALUES_ARRAY[i];
            if (result.toString().equals(literal)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static BooleanDef getByName(String name) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            BooleanDef result = VALUES_ARRAY[i];
            if (result.getName().equals(name)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static BooleanDef get(int value) {
        switch (value) {
            case 0: {
                return NONE;
            }
            case 1: {
                return TRUE;
            }
            case 2: {
                return FALSE;
            }
        }
        return null;
    }

    private BooleanDef(int value, String name, String literal) {
        this.value = value;
        this.name = name;
        this.literal = literal;
    }

    public int getValue() {
        return this.value;
    }

    public String getName() {
        return this.name;
    }

    public String getLiteral() {
        return this.literal;
    }

    public String toString() {
        return this.literal;
    }
}

