/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.ats.dsl;

import java.io.IOException;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.Iterator;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.osee.ats.dsl.AtsDslResourceProvider;
import org.eclipse.osee.ats.dsl.AtsDslStandaloneSetup;
import org.eclipse.osee.ats.dsl.IResourceProvider;
import org.eclipse.osee.ats.dsl.atsDsl.AtsDsl;
import org.eclipse.xtext.resource.SaveOptions;
import org.eclipse.xtext.resource.XtextResourceSet;

public final class ModelUtil {
    protected ModelUtil() {
    }

    public static AtsDsl loadModel(String uri, String xTextData) throws Exception {
        return ModelUtil.loadModel(uri, xTextData, new AtsDslResourceProvider());
    }

    public static AtsDsl loadModel(String uri, String xTextData, IResourceProvider resourceProvider) throws Exception {
        AtsDsl atsDsl = resourceProvider.getContents(uri, xTextData);
        Iterator<String> iterator = resourceProvider.getErrors().iterator();
        if (iterator.hasNext()) {
            String error = iterator.next();
            throw new IllegalStateException(error);
        }
        return atsDsl;
    }

    public static void saveModel(AtsDsl model, String uri, OutputStream outputStream) throws IOException {
        AtsDslStandaloneSetup.doSetup();
        XtextResourceSet resourceSet = new XtextResourceSet();
        Resource resource = resourceSet.createResource(URI.createURI((String)uri));
        resource.getContents().add((Object)model);
        HashMap options = new HashMap();
        SaveOptions saveOptions = SaveOptions.getOptions(options);
        resource.save(outputStream, saveOptions.toOptionsMap());
    }
}

