/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.ats.dsl;

import com.google.inject.Injector;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.osee.ats.dsl.AtsDslStandaloneSetup;
import org.eclipse.osee.ats.dsl.IResourceProvider;
import org.eclipse.osee.ats.dsl.atsDsl.AtsDsl;
import org.eclipse.osee.ats.dsl.atsDsl.impl.AtsDslFactoryImpl;
import org.eclipse.osee.framework.jdk.core.type.OseeArgumentException;
import org.eclipse.xtext.resource.XtextResource;
import org.eclipse.xtext.resource.XtextResourceSet;

public class AtsDslResourceProvider
implements IResourceProvider {
    private Resource resource;

    @Override
    public Collection<String> getErrors() {
        LinkedList<String> errors = new LinkedList<String>();
        Iterator iterator = this.resource.getErrors().iterator();
        if (iterator.hasNext()) {
            Resource.Diagnostic diagnostic = (Resource.Diagnostic)iterator.next();
            throw new IllegalStateException(diagnostic.toString());
        }
        return errors;
    }

    @Override
    public AtsDsl getContents(String uri, String xTextData) throws Exception {
        AtsDslStandaloneSetup setup = new AtsDslStandaloneSetup();
        Injector injector = setup.createInjectorAndDoEMFRegistration();
        XtextResourceSet set = (XtextResourceSet)injector.getInstance(XtextResourceSet.class);
        set.addLoadOption((Object)XtextResource.OPTION_RESOLVE_ALL, (Object)Boolean.TRUE);
        this.resource = set.createResource(URI.createURI((String)uri));
        this.resource.load((InputStream)new ByteArrayInputStream(xTextData.getBytes("UTF-8")), set.getLoadOptions());
        EList contents = this.resource.getContents();
        if (contents.size() == 1) {
            return (AtsDsl)contents.get(0);
        }
        if (contents.isEmpty()) {
            return AtsDslFactoryImpl.init().createAtsDsl();
        }
        throw new OseeArgumentException("Unexpected contents size > 1 in AtsDslResourceProvicer", new Object[]{contents.toString()});
    }
}

