/*
 * Decompiled with CFR 0.152.
 */
package org.flywaydb.core.internal.dbsupport.postgresql;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.flywaydb.core.internal.dbsupport.Delimiter;
import org.flywaydb.core.internal.dbsupport.SqlStatementBuilder;

public class PostgreSQLSqlStatementBuilder
extends SqlStatementBuilder {
    private static final Delimiter COPY_DELIMITER = new Delimiter("\\.", true);
    static final String DOLLAR_QUOTE_REGEX = "(\\$[A-Za-z0-9_]*\\$).*";
    private boolean firstLine = true;
    private boolean pgCopy;

    @Override
    protected String extractAlternateOpenQuote(String token) {
        Matcher matcher = Pattern.compile(DOLLAR_QUOTE_REGEX).matcher(token);
        if (matcher.find()) {
            return matcher.group(1);
        }
        return null;
    }

    @Override
    protected Delimiter changeDelimiterIfNecessary(String line, Delimiter delimiter) {
        if (this.firstLine) {
            this.firstLine = false;
            if (line.matches("COPY|COPY\\s.*")) {
                this.pgCopy = true;
                return COPY_DELIMITER;
            }
        }
        return this.pgCopy ? COPY_DELIMITER : delimiter;
    }

    @Override
    public boolean isPgCopy() {
        return this.pgCopy;
    }
}

