/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.define.report.api;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlTransient;
import org.eclipse.osee.define.report.api.DataRight;
import org.eclipse.osee.define.report.api.DataRightAnchor;
import org.eclipse.osee.define.report.api.DataRightId;
import org.eclipse.osee.define.report.api.PageOrientation;
import org.eclipse.osee.framework.jdk.core.util.Strings;

@XmlRootElement
public class DataRightResult {
    @XmlTransient
    private List<DataRightAnchor> dataRightAnchors;
    @XmlTransient
    private List<DataRight> dataRights;
    private Map<DataRightId, DataRight> dataRightIdToDataRight;
    private Map<String, DataRightAnchor> guidToAnchor;

    @XmlElement
    public Collection<DataRightAnchor> getDataRightAnchors() {
        if (this.dataRightAnchors == null) {
            this.dataRightAnchors = new ArrayList<DataRightAnchor>();
        }
        return this.dataRightAnchors;
    }

    public void setDataRightAnchors(List<DataRightAnchor> dataRightAnchors) {
        this.dataRightAnchors = dataRightAnchors;
    }

    @XmlElement
    public Collection<DataRight> getDataRights() {
        if (this.dataRights == null) {
            this.dataRights = new ArrayList<DataRight>();
        }
        return this.dataRights;
    }

    public void setDataRights(List<DataRight> dataRights) {
        this.dataRights = dataRights;
    }

    public String getContent(String guid, PageOrientation orientation) {
        this.checkInitialized();
        String footer = null;
        String portrait = String.format("%s <w:pgMar w:top=\"1440\" w:right=\"1440\" w:bottom=\"1440\" w:left=\"1440\" w:header=\"432\" w:footer=\"432\" w:gutter=\"0\"/><w:cols w:space=\"720\"/>", "<w:pgSz w:w=\"12240\" w:h=\"15840\"/>");
        String landscape = String.format("%s <w:pgMar w:top=\"1440\" w:right=\"1440\" w:bottom=\"1440\" w:left=\"1440\" w:header=\"432\" w:footer=\"432\" w:gutter=\"0\"/><w:cols w:space=\"720\"/>", "<w:pgSz w:w=\"15840\" w:h=\"12240\" w:orient=\"landscape\"/>");
        String page_adds = orientation.isLandscape() ? landscape : portrait;
        DataRightAnchor anchor = this.guidToAnchor.get(guid);
        if (anchor != null) {
            boolean isSetDataRightFooter = anchor.isSetDataRightFooter();
            boolean isContinuous = anchor.isContinuous();
            if (isSetDataRightFooter) {
                DataRight dataRight;
                DataRightId key = anchor.getDataRightId();
                if (key != null && (dataRight = this.dataRightIdToDataRight.get(key)) != null) {
                    footer = this.normalize(dataRight.getContent());
                    footer = String.format("<w:p><w:pPr><w:spacing w:after=\"0\"/><w:sectPr>%s</w:sectPr></w:pPr></w:p>", String.valueOf(footer) + page_adds);
                }
            } else if (!isContinuous) {
                footer = String.format("<w:p><w:pPr><w:spacing w:after=\"0\"/><w:sectPr>%s</w:sectPr></w:pPr></w:p>", page_adds);
            }
        }
        return Strings.isValid(footer) ? footer : "";
    }

    private String normalize(String partialFooter) {
        String toReturn = partialFooter;
        if ("NO DATA RIGHTS ARTIFACT FOUND".equals(toReturn)) {
            toReturn = String.format("<w:r><w:t>%s</w:t></w:r>", toReturn);
        }
        return toReturn;
    }

    public void reset() {
        this.dataRightIdToDataRight = null;
        this.guidToAnchor = null;
    }

    private void checkInitialized() {
        if (this.dataRightIdToDataRight == null || this.guidToAnchor == null) {
            this.dataRightIdToDataRight = new HashMap<DataRightId, DataRight>();
            this.guidToAnchor = new HashMap<String, DataRightAnchor>();
            for (DataRightAnchor anchor : this.dataRightAnchors) {
                this.guidToAnchor.put(anchor.getId(), anchor);
            }
            for (DataRight dataRight : this.dataRights) {
                this.dataRightIdToDataRight.put(dataRight.getId(), dataRight);
            }
        }
    }
}

