/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.nebula.widgets.xviewer.core.model;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.nebula.widgets.xviewer.core.model.XViewerColumn;

public class ColumnData {
    List<XViewerColumn> columns = new ArrayList<XViewerColumn>();
    Map<String, XViewerColumn> idToColumn = new HashMap<String, XViewerColumn>();
    private static Pattern pattern = Pattern.compile("<xCol>(.*?)</xCol>");

    public List<XViewerColumn> setFromXml(String xml) {
        this.columns.clear();
        Matcher columnMatch = pattern.matcher(xml);
        while (columnMatch.find()) {
            String colXml = columnMatch.group(1);
            XViewerColumn xCol = new XViewerColumn(null, colXml);
            this.columns.add(xCol);
            this.idToColumn.put(xCol.getId(), xCol);
        }
        return this.columns;
    }

    public XViewerColumn getXColumn(String id) {
        return this.idToColumn.get(id);
    }

    public String getXml(boolean visibleColumnsOnly) {
        StringBuffer sb = new StringBuffer();
        for (XViewerColumn xCol : this.columns) {
            if (visibleColumnsOnly && (!visibleColumnsOnly || !xCol.isShow())) continue;
            sb.append(xCol.toXml());
        }
        return sb.toString();
    }

    public List<XViewerColumn> getColumns() {
        return this.columns;
    }

    public void setColumns(List<XViewerColumn> columns) {
        this.columns = columns;
        this.idToColumn.clear();
        for (XViewerColumn xCol : columns) {
            this.idToColumn.put(xCol.getId(), xCol);
        }
    }

    public String toString() {
        return "ColumnData [columns=" + this.columns + "]";
    }
}

