/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.orcs.rest.internal.writers;

import java.io.IOException;
import java.io.OutputStream;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Collection;
import java.util.List;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.ext.MessageBodyWriter;
import javax.ws.rs.ext.Provider;
import org.codehaus.jackson.JsonFactory;
import org.codehaus.jackson.JsonGenerator;
import org.codehaus.jackson.map.ObjectMapper;
import org.eclipse.osee.framework.core.data.AttributeTypeId;
import org.eclipse.osee.framework.core.data.AttributeTypeToken;
import org.eclipse.osee.framework.jdk.core.type.ResultSet;
import org.eclipse.osee.jaxrs.mvc.IdentityView;
import org.eclipse.osee.orcs.OrcsApi;
import org.eclipse.osee.orcs.data.ArtifactReadable;
import org.eclipse.osee.orcs.data.AttributeTypes;

@Provider
public class ArtifactJsonWriter
implements MessageBodyWriter<Object> {
    private JsonFactory jsonFactory;
    private OrcsApi orcsApi;

    public void setOrcsApi(OrcsApi orcsApi) {
        this.orcsApi = orcsApi;
    }

    public void start() {
        ObjectMapper mapper = new ObjectMapper();
        SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd HH:mm a z");
        mapper.setDateFormat((DateFormat)df);
        this.jsonFactory = mapper.getJsonFactory();
    }

    public void stop() {
        this.jsonFactory = null;
    }

    public long getSize(Object object, Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType) {
        return -1L;
    }

    public boolean isWriteable(Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType) {
        boolean result = false;
        if (Iterable.class.isAssignableFrom(type) && genericType.getClass().isAssignableFrom(ArtifactReadable.class) && MediaType.APPLICATION_JSON_TYPE.equals((Object)mediaType)) {
            result = true;
        }
        return result;
    }

    private boolean matches(Class<? extends Annotation> toMatch, Annotation[] annotations) {
        Annotation[] annotationArray = annotations;
        int n = annotations.length;
        int n2 = 0;
        while (n2 < n) {
            Annotation annotation = annotationArray[n2];
            if (annotation.annotationType().isAssignableFrom(toMatch)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    private AttributeTypes getAttibuteTypes() {
        return this.orcsApi.getOrcsTypes().getAttributeTypes();
    }

    public void writeTo(Object object, Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType, MultivaluedMap<String, Object> httpHeaders, OutputStream entityStream) throws IOException, WebApplicationException {
        JsonGenerator writer = null;
        if (type.isAssignableFrom(ArtifactReadable.class)) {
            ArtifactReadable artifact = (ArtifactReadable)object;
            try {
                writer = this.jsonFactory.createJsonGenerator(entityStream);
                writer.writeStartObject();
                writer.writeNumberField("uuid", artifact.getUuid().longValue());
                if (this.matches(IdentityView.class, annotations)) {
                    writer.writeStringField("Name", artifact.getName());
                } else {
                    AttributeTypes attributeTypes = this.getAttibuteTypes();
                    Collection attrTypes = attributeTypes.getAll();
                    ResultSet attributes = artifact.getAttributes();
                    if (!attributes.isEmpty()) {
                        for (AttributeTypeToken attrType : attrTypes) {
                            Object value2;
                            List attributeValues;
                            if (!artifact.isAttributeTypeValid((AttributeTypeId)attrType) || (attributeValues = artifact.getAttributeValues((AttributeTypeId)attrType)).isEmpty()) continue;
                            if (attributeValues.size() > 1) {
                                writer.writeArrayFieldStart(attrType.getName());
                                for (Object value2 : attributeValues) {
                                    writer.writeObject(value2);
                                }
                                writer.writeEndArray();
                                continue;
                            }
                            if (attributeValues.size() != 1) continue;
                            value2 = attributeValues.iterator().next();
                            writer.writeObjectField(attrType.getName(), value2);
                        }
                    }
                }
                writer.writeEndObject();
            }
            finally {
                if (writer != null) {
                    writer.flush();
                }
            }
        }
    }
}

