/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.orcs.rest.internal.writer;

import org.eclipse.osee.framework.core.util.XResultData;
import org.eclipse.osee.framework.jdk.core.type.OseeCoreException;
import org.eclipse.osee.framework.jdk.core.util.Strings;
import org.eclipse.osee.framework.jdk.core.util.io.xml.RowProcessor;
import org.eclipse.osee.orcs.rest.internal.writer.OrcsWriterFactory;
import org.eclipse.osee.orcs.rest.internal.writer.OrcsWriterUtil;
import org.eclipse.osee.orcs.rest.model.writer.reader.OwBranch;
import org.eclipse.osee.orcs.rest.model.writer.reader.OwCollector;

public class OrcsWriterSheetProcessorForSettings
implements RowProcessor {
    private final OwCollector collector;
    private int rowCount = 0;
    private final OrcsWriterFactory factory;

    public OrcsWriterSheetProcessorForSettings(OwCollector collector, XResultData result) {
        this.collector = collector;
        this.factory = new OrcsWriterFactory(collector);
    }

    public void detectedRowAndColumnCounts(int rowCount, int columnCount) {
    }

    public void foundStartOfWorksheet(String sheetName) throws OseeCoreException {
    }

    public void processCommentRow(String[] row) {
    }

    public void processEmptyRow() {
    }

    public void processHeaderRow(String[] headerRow) {
    }

    public void processRow(String[] row) throws OseeCoreException {
        ++this.rowCount;
        int colCount = 0;
        while (colCount < row.length) {
            if (colCount == 0) {
                String persistComment;
                String key = row[colCount];
                if (key.equals("BRANCH TOKEN")) {
                    String branchTokenStr = row[1];
                    if (Strings.isValid((String)branchTokenStr)) {
                        OwBranch branchToken = this.factory.getOrCreateBranchToken(branchTokenStr);
                        this.collector.setBranch(branchToken);
                        branchToken.setData(OrcsWriterUtil.getData("Instructions and Settings", this.rowCount, colCount, branchTokenStr));
                    }
                } else if (key.equals("AS USER ID")) {
                    String userId = row[1];
                    if (Strings.isValid((String)userId)) {
                        this.collector.setAsUserId(userId);
                    }
                } else if (key.equals("PERSIST COMMENT") && Strings.isValid((String)(persistComment = row[1]))) {
                    this.collector.setPersistComment(persistComment);
                }
            }
            ++colCount;
        }
    }

    public void reachedEndOfWorksheet() {
    }
}

