/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.orcs.rest.internal.writer;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URI;
import org.eclipse.osee.framework.core.util.XResultData;
import org.eclipse.osee.framework.jdk.core.type.OseeCoreException;
import org.eclipse.osee.framework.jdk.core.util.io.xml.ExcelSaxHandler;
import org.eclipse.osee.framework.jdk.core.util.io.xml.RowProcessor;
import org.eclipse.osee.orcs.rest.internal.writer.OrcsWriterSheetProcessorForCreateUpdate;
import org.eclipse.osee.orcs.rest.internal.writer.OrcsWriterSheetProcessorForDelete;
import org.eclipse.osee.orcs.rest.internal.writer.OrcsWriterSheetProcessorForSettings;
import org.eclipse.osee.orcs.rest.model.writer.reader.OwCollector;
import org.xml.sax.ContentHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.XMLReaderFactory;

public class OrcsWriterExcelReader {
    private OwCollector collector;
    private final XResultData result;

    public OrcsWriterExcelReader(XResultData result) {
        this.result = result;
    }

    public void run(URI source) throws SAXException, IOException, UnsupportedEncodingException, MalformedURLException {
        this.collector = new OwCollector();
        XMLReader xmlReader = XMLReaderFactory.createXMLReader();
        xmlReader.setContentHandler((ContentHandler)new ExcelSaxHandler((RowProcessor)new ExcelRowProcessor(this.collector, this.result), true));
        InputStreamReader inputStreamReader = new InputStreamReader(source.toURL().openStream(), "UTF-8");
        xmlReader.parse(new InputSource(inputStreamReader));
        inputStreamReader.close();
    }

    public void run(InputStream source) throws SAXException, IOException, UnsupportedEncodingException, MalformedURLException {
        this.collector = new OwCollector();
        XMLReader xmlReader = XMLReaderFactory.createXMLReader();
        xmlReader.setContentHandler((ContentHandler)new ExcelSaxHandler((RowProcessor)new ExcelRowProcessor(this.collector, this.result), true));
        xmlReader.parse(new InputSource(source));
    }

    public OwCollector getCollector() {
        return this.collector;
    }

    private static final class ExcelRowProcessor
    implements RowProcessor {
        private final OwCollector collector;
        private OrcsWriterSheetProcessorForCreateUpdate createSheet;
        private OrcsWriterSheetProcessorForSettings settingsSheet;
        private String sheetName = "";
        private final XResultData result;
        private OrcsWriterSheetProcessorForCreateUpdate updateSheet;
        private OrcsWriterSheetProcessorForDelete deleteSheet;
        private boolean skipSheet = true;

        public ExcelRowProcessor(OwCollector collector, XResultData result) {
            this.collector = collector;
            this.result = result;
        }

        public void detectedRowAndColumnCounts(int rowCount, int columnCount) {
        }

        public void foundStartOfWorksheet(String sheetName) throws OseeCoreException {
            this.sheetName = sheetName;
            if (sheetName.equals("CREATE")) {
                this.createSheet = new OrcsWriterSheetProcessorForCreateUpdate(this.collector, this.result, true);
                this.skipSheet = false;
            } else if (sheetName.equals("UPDATE")) {
                this.updateSheet = new OrcsWriterSheetProcessorForCreateUpdate(this.collector, this.result, false);
                this.skipSheet = false;
            } else if (sheetName.equals("Instructions and Settings")) {
                this.settingsSheet = new OrcsWriterSheetProcessorForSettings(this.collector, this.result);
                this.skipSheet = false;
            } else if (sheetName.equals("DELETE")) {
                this.deleteSheet = new OrcsWriterSheetProcessorForDelete(this.collector, this.result);
                this.skipSheet = false;
            } else {
                this.skipSheet = true;
            }
        }

        public void processCommentRow(String[] row) {
        }

        public void processEmptyRow() {
        }

        public void processHeaderRow(String[] headerRow) {
            if (this.skipSheet) {
                return;
            }
            if (this.isCreateSheet()) {
                this.createSheet.processHeaderRow(headerRow);
            } else if (this.isUpdateSheet()) {
                this.updateSheet.processHeaderRow(headerRow);
            } else if (this.isDeleteSheet()) {
                this.deleteSheet.processHeaderRow(headerRow);
            }
        }

        private boolean isCreateSheet() {
            return this.sheetName.equals("CREATE");
        }

        private boolean isDeleteSheet() {
            return this.sheetName.equals("DELETE");
        }

        private boolean isUpdateSheet() {
            return this.sheetName.equals("UPDATE");
        }

        private boolean isSettingsSheet() {
            return this.sheetName.equals("Instructions and Settings");
        }

        public void processRow(String[] row) throws OseeCoreException {
            if (this.skipSheet) {
                return;
            }
            if (this.isCreateSheet()) {
                this.processCreateSheetRow(row);
            } else if (this.isUpdateSheet()) {
                this.processUpdateSheetRow(row);
            } else if (this.isSettingsSheet()) {
                this.settingsSheet.processRow(row);
            } else if (this.isDeleteSheet()) {
                this.processDeleteSheetRow(row);
            }
        }

        private void processDeleteSheetRow(String[] row) {
            this.deleteSheet.processRow(row);
        }

        private void processUpdateSheetRow(String[] row) {
            this.updateSheet.processRow(row);
        }

        private void processCreateSheetRow(String[] row) {
            this.createSheet.processRow(row);
        }

        public void reachedEndOfWorksheet() {
            this.skipSheet = true;
        }
    }
}

