/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.orcs.rest.internal.writer;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import org.eclipse.osee.framework.core.data.AttributeTypeToken;
import org.eclipse.osee.framework.core.data.IArtifactType;
import org.eclipse.osee.framework.core.data.IOseeBranch;
import org.eclipse.osee.framework.core.data.IRelationType;
import org.eclipse.osee.framework.core.data.RelationTypeToken;
import org.eclipse.osee.framework.core.enums.CoreArtifactTokens;
import org.eclipse.osee.framework.core.enums.CoreArtifactTypes;
import org.eclipse.osee.framework.core.enums.CoreAttributeTypes;
import org.eclipse.osee.framework.core.enums.CoreBranches;
import org.eclipse.osee.framework.core.enums.CoreRelationTypes;
import org.eclipse.osee.framework.core.enums.SystemUser;
import org.eclipse.osee.framework.jdk.core.util.Lib;
import org.eclipse.osee.orcs.OrcsApi;
import org.eclipse.osee.orcs.rest.internal.writer.OwFactory;
import org.eclipse.osee.orcs.rest.model.writer.OrcsWriterToken;
import org.eclipse.osee.orcs.rest.model.writer.config.OrcsWriterInputConfig;
import org.eclipse.osee.orcs.rest.model.writer.config.OrcsWriterRelationSide;
import org.eclipse.osee.orcs.rest.model.writer.reader.OwArtifact;
import org.eclipse.osee.orcs.rest.model.writer.reader.OwArtifactToken;
import org.eclipse.osee.orcs.rest.model.writer.reader.OwArtifactType;
import org.eclipse.osee.orcs.rest.model.writer.reader.OwAttributeType;
import org.eclipse.osee.orcs.rest.model.writer.reader.OwBranch;
import org.eclipse.osee.orcs.rest.model.writer.reader.OwCollector;
import org.eclipse.osee.orcs.rest.model.writer.reader.OwRelation;
import org.eclipse.osee.orcs.rest.model.writer.reader.OwRelationType;

public class OrcsWriterCollectorGenerator {
    private OrcsApi orcsApi;
    private final OrcsWriterInputConfig config;
    private OwCollector collector;

    public OrcsWriterCollectorGenerator() {
        this(null);
    }

    public OrcsWriterCollectorGenerator(OrcsWriterInputConfig config) {
        this.config = config;
    }

    private void init(OrcsApi orcsApi) {
        this.orcsApi = orcsApi;
        this.collector = new OwCollector();
    }

    public OwCollector run(OrcsApi providedOrcs) {
        this.init(providedOrcs);
        this.collector.setPersistComment("Put Comment Here");
        this.collector.setAsUserId(SystemUser.OseeSystem.getUserId());
        this.collector.getBranch().setName(CoreBranches.COMMON.getName());
        this.collector.getBranch().setId(CoreBranches.COMMON.getId());
        this.collector.getBranch().setData(String.format("[%s]-[%s]", CoreBranches.COMMON.getName(), CoreBranches.COMMON.getId()));
        this.createInstructions();
        this.createCreateSheet();
        this.createUpdateSheet();
        this.createDeleteSheet();
        this.createBranchSheet();
        this.createArtifactTokenSheet();
        this.createArtifactTypeSheet();
        this.createAttributeTypeSheet();
        this.createRelationTypeSheet();
        return this.collector;
    }

    private void createInstructions() {
        StringBuilder sb = new StringBuilder();
        sb.append("ORCS Writer provides Create, Update and Delete capabilities through JSON or an Excel spreadsheet\n");
        sb.append("   - Download an Example Excel Workbook (<server>/orcs/writer/sheet) or ");
        sb.append("Example JSON (<server>/orcs/writer/sheet.json)\n");
        sb.append("   - Make modifications to the input. CREATE, MODIFY, DELETE, BRANCH tabs/structures are the only items\n");
        sb.append("     that will be read. Token and Type tabs/structures are for reference only and should be used\n");
        sb.append("     in the CREATE, MODIFY and DELETE tabs/structures.\n");
        sb.append("   - On BRANCH tab, delete all but the single branch to apply changes to.\n");
        sb.append("   - Use <server>/orcs/writer/ui/main.html to validate sheet/json and then apply changes to branch.");
        this.collector.setInstructions(sb.toString());
    }

    private void createCreateSheet() {
        OwArtifactToken folder = this.createFolder();
        this.createSoftwareRequirement(folder, "1");
        this.createSoftwareRequirement(folder, "2");
    }

    private void createSoftwareRequirement(OwArtifactToken folderToken, String number) {
        Long reqId = Lib.generateArtifactIdAsInt();
        String name = "Software Requirement " + number;
        OwArtifact softwareReq = OwFactory.createArtifact(CoreArtifactTypes.SoftwareRequirement, name, reqId);
        OwFactory.createAttribute(softwareReq, CoreAttributeTypes.StaticId, "static id field " + number);
        this.collector.getCreate().add(softwareReq);
        OwRelation relation = new OwRelation();
        relation.setType(OwFactory.createRelationType(this.orcsApi, CoreRelationTypes.Default_Hierarchical__Parent));
        relation.setArtToken(folderToken);
        softwareReq.getRelations().add(relation);
    }

    private OwArtifactToken createFolder() {
        Long folderId = Lib.generateArtifactIdAsInt();
        String folderName = "Orcs Writer Import Folder";
        OwArtifact folder = OwFactory.createArtifact(CoreArtifactTypes.Folder, folderName, folderId);
        this.collector.getCreate().add(folder);
        OwRelation relation = new OwRelation();
        relation.setType(OwFactory.createRelationType(this.orcsApi, CoreRelationTypes.Default_Hierarchical__Parent));
        relation.setArtToken(OwFactory.createArtifactToken(CoreArtifactTokens.DefaultHierarchyRoot));
        folder.getRelations().add(relation);
        return OwFactory.createArtifactToken(folderName, folderId);
    }

    private void createUpdateSheet() {
        OwArtifact userGroupArt = OwFactory.createArtifact(CoreArtifactTypes.Folder, CoreArtifactTokens.UserGroups.getName(), CoreArtifactTokens.UserGroups.getId());
        OwFactory.createAttribute(userGroupArt, CoreAttributeTypes.StaticId, "test static id");
        OwFactory.createAttribute(userGroupArt, CoreAttributeTypes.Annotation, "test annotation");
        this.collector.getUpdate().add(userGroupArt);
    }

    private void createDeleteSheet() {
        this.collector.getDelete();
    }

    private void createArtifactTokenSheet() {
        if (this.config == null) {
            OwArtifactToken owToken = OwFactory.createArtifactToken(CoreArtifactTokens.DefaultHierarchyRoot);
            this.collector.getArtTokens().add(owToken);
        } else {
            for (OrcsWriterToken token : this.config.getIncludeTokens()) {
                OwArtifactToken owToken = OwFactory.createArtifactToken(token.getName(), token.getId());
                this.collector.getArtTokens().add(owToken);
            }
        }
    }

    private void createArtifactTypeSheet() {
        HashMap<String, IArtifactType> types = new HashMap<String, IArtifactType>(100);
        if (this.config == null) {
            for (IArtifactType type : this.orcsApi.getOrcsTypes().getArtifactTypes().getAll()) {
                types.put(type.getName(), type);
            }
        } else {
            for (Long typeId : this.config.getIncludeArtifactTypes()) {
                IArtifactType type = (IArtifactType)this.orcsApi.getOrcsTypes().getArtifactTypes().get(typeId);
                if (type == null) continue;
                types.put(type.getName(), type);
            }
        }
        ArrayList typeNames = new ArrayList();
        typeNames.addAll(types.keySet());
        Collections.sort(typeNames);
        for (String typeName : typeNames) {
            IArtifactType type = (IArtifactType)types.get(typeName);
            OwArtifactType owType = OwFactory.createArtifactType(type);
            this.collector.getArtTypes().add(owType);
        }
    }

    private void createBranchSheet() {
        HashMap<String, IOseeBranch> branches = new HashMap<String, IOseeBranch>(500);
        for (IOseeBranch branch : this.orcsApi.getQueryFactory().branchQuery().getResults()) {
            branches.put(branch.getName(), branch);
        }
        ArrayList branchNames = new ArrayList();
        branchNames.addAll(branches.keySet());
        Collections.sort(branchNames);
        for (String branchName : branchNames) {
            IOseeBranch type = (IOseeBranch)branches.get(branchName);
            OwBranch owBranch = OwFactory.createBranchToken(type);
            this.collector.getBranches().add(owBranch);
        }
    }

    private void createAttributeTypeSheet() {
        HashMap<String, AttributeTypeToken> types = new HashMap<String, AttributeTypeToken>(100);
        if (this.config == null) {
            for (AttributeTypeToken type : this.orcsApi.getOrcsTypes().getAttributeTypes().getAll()) {
                types.put(type.getName(), type);
            }
        } else {
            for (Long typeId : this.config.getIncludeAttributeTypes()) {
                AttributeTypeToken type = (AttributeTypeToken)this.orcsApi.getOrcsTypes().getAttributeTypes().get(typeId);
                if (type == null) continue;
                types.put(type.getName(), type);
            }
        }
        ArrayList typeNames = new ArrayList();
        typeNames.addAll(types.keySet());
        Collections.sort(typeNames);
        for (String typeName : typeNames) {
            AttributeTypeToken type = (AttributeTypeToken)types.get(typeName);
            OwAttributeType owType = OwFactory.createAttributeType(type);
            this.collector.getAttrTypes().add(owType);
        }
    }

    private void createRelationTypeSheet() {
        RelationTypeToken type;
        HashMap<String, RelationTypeToken> types = new HashMap<String, RelationTypeToken>(100);
        if (this.config == null) {
            for (RelationTypeToken type2 : this.orcsApi.getOrcsTypes().getRelationTypes().getAll()) {
                types.put(type2.getName(), type2);
            }
        } else {
            for (OrcsWriterRelationSide token : this.config.getIncludeRelationTypes()) {
                Long relationTypeId = token.getRelationTypeId();
                type = (RelationTypeToken)this.orcsApi.getOrcsTypes().getRelationTypes().get(relationTypeId);
                if (type == null) continue;
                types.put(type.getName(), type);
            }
        }
        ArrayList typeNames = new ArrayList();
        typeNames.addAll(types.keySet());
        Collections.sort(typeNames);
        for (String typeName : typeNames) {
            type = (RelationTypeToken)types.get(typeName);
            this.writeRelationType(type);
        }
    }

    private void writeRelationType(RelationTypeToken type) {
        String sideAName = this.orcsApi.getOrcsTypes().getRelationTypes().getSideAName((IRelationType)type);
        OwRelationType owType = OwFactory.createRelationType(type, sideAName, true);
        this.collector.getRelTypes().add(owType);
        String sideBName = this.orcsApi.getOrcsTypes().getRelationTypes().getSideBName((IRelationType)type);
        owType = OwFactory.createRelationType(type, sideBName, false);
        this.collector.getRelTypes().add(owType);
    }
}

