/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.orcs.rest.internal.writer;

import org.eclipse.osee.framework.core.data.AttributeTypeId;
import org.eclipse.osee.framework.core.data.AttributeTypeToken;
import org.eclipse.osee.framework.core.data.BranchId;
import org.eclipse.osee.framework.core.enums.CoreAttributeTypes;
import org.eclipse.osee.framework.core.enums.CoreBranches;
import org.eclipse.osee.framework.core.enums.QueryOption;
import org.eclipse.osee.orcs.OrcsApi;
import org.eclipse.osee.orcs.rest.internal.writer.IOrcsValidationHelper;
import org.eclipse.osee.orcs.search.BranchQuery;
import org.eclipse.osee.orcs.search.QueryBuilder;

public class OrcsValidationHelperAdapter
implements IOrcsValidationHelper {
    private final OrcsApi orcsApi;

    public OrcsValidationHelperAdapter(OrcsApi orcsApi) {
        this.orcsApi = orcsApi;
    }

    @Override
    public boolean isBranchExists(BranchId branch) {
        return ((BranchQuery)this.orcsApi.getQueryFactory().branchQuery().andId(branch)).getResultsAsId().size() == 1;
    }

    @Override
    public boolean isUserExists(String userId) {
        return ((QueryBuilder)this.orcsApi.getQueryFactory().fromBranch((BranchId)CoreBranches.COMMON).and((AttributeTypeId)CoreAttributeTypes.UserId, userId, new QueryOption[0])).getResults().getAtMostOneOrNull() != null;
    }

    @Override
    public boolean isArtifactExists(BranchId branch, long artifactUuid) {
        int matchedArtifacts = ((QueryBuilder)this.orcsApi.getQueryFactory().fromBranch(branch).andUuid(artifactUuid)).getResults().size();
        return matchedArtifacts == 1;
    }

    @Override
    public boolean isArtifactTypeExist(long artifactTypeUuid) {
        return this.orcsApi.getOrcsTypes().getArtifactTypes().get(Long.valueOf(artifactTypeUuid)) != null;
    }

    @Override
    public boolean isRelationTypeExist(long relationTypeUuid) {
        return this.orcsApi.getOrcsTypes().getRelationTypes().get(Long.valueOf(relationTypeUuid)) != null;
    }

    @Override
    public boolean isAttributeTypeExists(long attributeTypeUuid) {
        return this.orcsApi.getOrcsTypes().getAttributeTypes().get(Long.valueOf(attributeTypeUuid)) != null;
    }

    @Override
    public boolean isAttributeTypeExists(String attributeTypeName) {
        for (AttributeTypeToken type : this.orcsApi.getOrcsTypes().getAttributeTypes().getAll()) {
            if (!type.getName().equals(attributeTypeName)) continue;
            return true;
        }
        return false;
    }
}

