/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.orcs.rest.internal.writer;

import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.xml.bind.DatatypeConverter;
import org.eclipse.osee.framework.core.data.ArtifactId;
import org.eclipse.osee.framework.core.data.ArtifactToken;
import org.eclipse.osee.framework.core.data.AttributeTypeId;
import org.eclipse.osee.framework.core.data.AttributeTypeToken;
import org.eclipse.osee.framework.core.data.BranchId;
import org.eclipse.osee.framework.core.data.IArtifactType;
import org.eclipse.osee.framework.core.data.IRelationType;
import org.eclipse.osee.framework.core.data.RelationTypeSide;
import org.eclipse.osee.framework.core.enums.CoreAttributeTypes;
import org.eclipse.osee.framework.core.enums.CoreBranches;
import org.eclipse.osee.framework.core.enums.QueryOption;
import org.eclipse.osee.framework.core.enums.RelationSide;
import org.eclipse.osee.framework.core.exception.OseeWrappedException;
import org.eclipse.osee.framework.core.util.XResultData;
import org.eclipse.osee.framework.jdk.core.type.OseeArgumentException;
import org.eclipse.osee.framework.jdk.core.type.OseeCoreException;
import org.eclipse.osee.framework.jdk.core.util.DateUtil;
import org.eclipse.osee.framework.jdk.core.util.GUID;
import org.eclipse.osee.framework.jdk.core.util.Lib;
import org.eclipse.osee.framework.jdk.core.util.Strings;
import org.eclipse.osee.orcs.OrcsApi;
import org.eclipse.osee.orcs.data.ArtifactReadable;
import org.eclipse.osee.orcs.rest.model.writer.reader.OwArtifact;
import org.eclipse.osee.orcs.rest.model.writer.reader.OwArtifactToken;
import org.eclipse.osee.orcs.rest.model.writer.reader.OwArtifactType;
import org.eclipse.osee.orcs.rest.model.writer.reader.OwAttribute;
import org.eclipse.osee.orcs.rest.model.writer.reader.OwAttributeType;
import org.eclipse.osee.orcs.rest.model.writer.reader.OwCollector;
import org.eclipse.osee.orcs.rest.model.writer.reader.OwRelation;
import org.eclipse.osee.orcs.rest.model.writer.reader.OwRelationType;
import org.eclipse.osee.orcs.search.BranchQuery;
import org.eclipse.osee.orcs.search.QueryBuilder;
import org.eclipse.osee.orcs.transaction.TransactionBuilder;

public class OrcsCollectorWriter {
    private final OwCollector collector;
    private final OrcsApi orcsApi;
    private Map<Long, ArtifactId> idToArtifact;
    private TransactionBuilder transaction;
    private BranchId branch;
    private ArtifactReadable user;
    private final XResultData results;

    public OrcsCollectorWriter(OrcsApi orcsApi, OwCollector collector, XResultData results) {
        this.orcsApi = orcsApi;
        this.collector = collector;
        this.results = results;
        this.idToArtifact = new HashMap<Long, ArtifactId>();
    }

    public XResultData run() {
        this.processCreate(this.results);
        this.processUpdate(this.results);
        this.processDelete(this.results);
        this.getTransaction().commit();
        this.results.log("Complete");
        return this.results;
    }

    private void processDelete(XResultData results) {
        for (OwArtifactToken owArtifact : this.collector.getDelete()) {
            ArtifactReadable artifact = (ArtifactReadable)((QueryBuilder)this.orcsApi.getQueryFactory().fromBranch(this.getBranch()).andUuid(owArtifact.getId().longValue())).getResults().getAtMostOneOrNull();
            if (artifact == null) {
                results.warningf("Delete Artifact Token %s does not exist in database.  Skipping", new Object[]{owArtifact});
                continue;
            }
            this.getTransaction().deleteArtifact((ArtifactId)artifact);
            results.logf("Deleted artifact %s", new Object[]{owArtifact});
        }
    }

    private void processUpdate(XResultData results) {
        for (OwArtifact owArtifact : this.collector.getUpdate()) {
            ArtifactReadable artifact = (ArtifactReadable)((QueryBuilder)this.orcsApi.getQueryFactory().fromBranch(this.getBranch()).andUuid(owArtifact.getId().longValue())).getResults().getAtMostOneOrNull();
            if (artifact == null) {
                throw new OseeArgumentException("Artifact not found for OwArtifact %s", new Object[]{owArtifact});
            }
            if (Strings.isValid((String)owArtifact.getName()) && !owArtifact.getName().equals(artifact.getName())) {
                this.getTransaction().setName((ArtifactId)artifact, owArtifact.getName());
                this.logChange(artifact, (AttributeTypeId)CoreAttributeTypes.Name, artifact.getName(), owArtifact.getName());
            }
            try {
                this.createMissingRelations(owArtifact.getRelations(), (ArtifactId)artifact, results);
            }
            catch (Exception ex) {
                throw new OseeWrappedException((Throwable)ex, "Exception processing relations for [%s]", new Object[]{owArtifact});
            }
            try {
                for (OwAttribute owAttribute : owArtifact.getAttributes()) {
                    AttributeTypeId attrType = OrcsCollectorWriter.getAttributeType(this.orcsApi, owAttribute.getType());
                    if (artifact.getAttributeCount(attrType) <= 1 && owAttribute.getValues().size() <= 1) {
                        Comparable<Boolean> newVal;
                        Comparable<Boolean> currVal;
                        Object object;
                        String currValue = artifact.getSoleAttributeAsString(attrType, null);
                        String newValue = null;
                        if (owAttribute.getValues().size() == 1 && (object = owAttribute.getValues().iterator().next()) != null) {
                            newValue = owAttribute.getValues().iterator().next().toString();
                        }
                        if (Strings.isValid((String)currValue) && newValue == null) {
                            this.logChange(artifact, attrType, currValue, newValue);
                            this.getTransaction().deleteAttributes((ArtifactId)artifact, attrType);
                            continue;
                        }
                        if (this.orcsApi.getOrcsTypes().getAttributeTypes().isBooleanType(attrType)) {
                            currVal = this.getBoolean(currValue);
                            newVal = this.getBoolean(newValue);
                            if (currVal != null && ((Boolean)currVal).equals(newVal)) continue;
                            this.logChange(artifact, attrType, currValue, newValue);
                            this.getTransaction().setSoleAttributeValue((ArtifactId)artifact, attrType, (Object)newVal);
                            continue;
                        }
                        if (this.orcsApi.getOrcsTypes().getAttributeTypes().isFloatingType(attrType)) {
                            try {
                                currVal = this.getDouble(currValue);
                                newVal = this.getDouble(newValue);
                                if (currVal != null && ((Double)currVal).equals(newVal)) continue;
                                this.logChange(artifact, attrType, currValue, newValue);
                                this.getTransaction().setSoleAttributeValue((ArtifactId)artifact, attrType, (Object)newVal);
                                continue;
                            }
                            catch (Exception ex) {
                                throw new OseeArgumentException("Exception processing Double for OwAttribute %s Exception %s", new Object[]{owAttribute, ex});
                            }
                        }
                        if (this.orcsApi.getOrcsTypes().getAttributeTypes().isIntegerType(attrType)) {
                            try {
                                currVal = this.getInteger(currValue);
                                newVal = this.getInteger(newValue);
                                if (currVal != null && ((Integer)currVal).equals(newVal)) continue;
                                this.logChange(artifact, attrType, currValue, newValue);
                                this.getTransaction().setSoleAttributeValue((ArtifactId)artifact, attrType, (Object)newVal);
                                continue;
                            }
                            catch (Exception ex) {
                                throw new OseeArgumentException("Exception processing Integer for OwAttribute %s Exception %s", new Object[]{owAttribute, ex});
                            }
                        }
                        if (this.orcsApi.getOrcsTypes().getAttributeTypes().isDateType(attrType)) {
                            try {
                                currVal = (Date)artifact.getSoleAttributeValue(attrType, null);
                                newVal = this.getDate(newValue);
                                if (currVal != null && ((Date)currVal).compareTo((Date)newVal) == 0) continue;
                                this.logChange(artifact, attrType, DateUtil.getMMDDYYHHMM(currVal), DateUtil.getMMDDYYHHMM((Date)newVal));
                                TransactionBuilder tx = this.getTransaction();
                                tx.setSoleAttributeValue((ArtifactId)artifact, attrType, (Object)newVal);
                                continue;
                            }
                            catch (Exception ex) {
                                throw new OseeArgumentException("Exception processing Integer for OwAttribute %s Exception %s", new Object[]{owAttribute, ex});
                            }
                        }
                        if ((currValue != null || newValue == null) && (currValue == null || currValue.equals(newValue))) continue;
                        this.logChange(artifact, attrType, currValue, newValue);
                        this.getTransaction().setSoleAttributeValue((ArtifactId)artifact, attrType, (Object)newValue);
                        continue;
                    }
                    if (owAttribute.getValues().size() <= 1 || this.orcsApi.getOrcsTypes().getAttributeTypes().getMaxOccurrences(attrType) <= 1) continue;
                    if (this.orcsApi.getOrcsTypes().getAttributeTypes().isDateType(attrType)) {
                        throw new OseeArgumentException("Date attributes not supported for multi-value set for OwAttribute %s Exception %s", new Object[]{owAttribute});
                    }
                    LinkedList<String> values = new LinkedList<String>();
                    for (Object obj : owAttribute.getValues()) {
                        values.add(obj.toString());
                    }
                    this.getTransaction().setAttributesFromStrings((ArtifactId)artifact, attrType, values);
                    this.logChange(artifact, attrType, artifact.getAttributeValues(attrType).toString(), ((Object)values).toString());
                }
            }
            catch (Exception ex) {
                throw new OseeWrappedException((Throwable)ex, "Exception processing attributes for [%s]", new Object[]{owArtifact});
            }
        }
    }

    private void logChange(ArtifactReadable artifact, AttributeTypeId attrType, String currValue, String newValue) {
        this.results.log(String.format("Attribute Updated: Current [%s], New [%s] for attr type [%s] and artifact %s", currValue, newValue, attrType, artifact.toStringWithId()));
    }

    private Integer getInteger(String value) {
        Integer result = null;
        if (Strings.isValid((String)value)) {
            result = Integer.valueOf(value);
        }
        return result;
    }

    private Double getDouble(String value) {
        Double result = null;
        if (Strings.isValid((String)value)) {
            result = Double.valueOf(value);
        }
        return result;
    }

    private Boolean getBoolean(String value) {
        if (Strings.isValid((String)value)) {
            if (value.toLowerCase().equals("true")) {
                return true;
            }
            if (value.toLowerCase().equals("false")) {
                return false;
            }
            if (value.equals("1")) {
                return true;
            }
            if (value.equals("0")) {
                return false;
            }
        }
        return null;
    }

    protected static AttributeTypeId getAttributeType(OrcsApi orcsApi, OwAttributeType attributeType) {
        if (attributeType.getId() <= 0L) {
            for (AttributeTypeToken type : orcsApi.getOrcsTypes().getAttributeTypes().getAll()) {
                if (!type.getName().equals(attributeType.getName())) continue;
                return type;
            }
            throw new OseeArgumentException("Invalid attribute type name [%s]", new Object[]{attributeType});
        }
        return (AttributeTypeId)orcsApi.getOrcsTypes().getAttributeTypes().get(attributeType.getId());
    }

    private void processCreate(XResultData results) {
        for (OwArtifact owArtifact : this.collector.getCreate()) {
            OwArtifactType owArtType = owArtifact.getType();
            IArtifactType artType = (IArtifactType)this.orcsApi.getOrcsTypes().getArtifactTypes().get(owArtType.getId());
            long artifactId = owArtifact.getId();
            if (artifactId > 0L) {
                if (this.idToArtifact == null) {
                    this.idToArtifact = new HashMap<Long, ArtifactId>();
                }
            } else {
                artifactId = Lib.generateArtifactIdAsInt();
            }
            String name = owArtifact.getName();
            ArtifactToken artifact = this.getTransaction().createArtifact(artType, name, GUID.create(), artifactId);
            this.idToArtifact.put(artifactId, (ArtifactId)artifact);
            try {
                this.createAttributes(owArtifact, (ArtifactId)artifact, results);
            }
            catch (Exception ex) {
                throw new OseeWrappedException((Throwable)ex, "Exception creating attributes for [%s]", new Object[]{owArtifact});
            }
            try {
                this.createMissingRelations(owArtifact, (ArtifactId)artifact, results);
            }
            catch (Exception ex) {
                throw new OseeWrappedException((Throwable)ex, "Exception creating relations for [%s]", new Object[]{owArtifact});
            }
        }
    }

    private void createMissingRelations(OwArtifact owArtifact, ArtifactId artifact, XResultData results) {
        this.createMissingRelations(owArtifact.getRelations(), artifact, results);
    }

    private void createMissingRelations(List<OwRelation> relations, ArtifactId artifact, XResultData results) {
        for (OwRelation relation : relations) {
            RelationTypeSide relTypeSide;
            OwRelationType owRelType = relation.getType();
            IRelationType relType = (IRelationType)this.orcsApi.getOrcsTypes().getRelationTypes().get(owRelType.getId());
            OwArtifactToken artToken = relation.getArtToken();
            BranchId branchId = BranchId.valueOf((long)this.collector.getBranch().getId());
            ArtifactReadable otherArtifact = null;
            if (this.idToArtifact.containsKey(artToken.getId())) {
                otherArtifact = (ArtifactReadable)this.idToArtifact.get(artToken.getId());
            } else {
                otherArtifact = (ArtifactReadable)((QueryBuilder)this.orcsApi.getQueryFactory().fromBranch(branchId).andUuid(artToken.getId().longValue())).getResults().getExactlyOne();
                this.idToArtifact.put(artToken.getId(), (ArtifactId)otherArtifact);
            }
            if (relation.getType().isSideA()) {
                relTypeSide = RelationTypeSide.create((RelationSide)RelationSide.SIDE_A, (long)relation.getType().getId(), (String)relation.getType().getName());
                if (otherArtifact.areRelated(relTypeSide, (ArtifactReadable)artifact)) continue;
                this.getTransaction().relate((ArtifactId)otherArtifact, relType, artifact);
                continue;
            }
            relTypeSide = RelationTypeSide.create((RelationSide)RelationSide.SIDE_B, (long)relation.getType().getId(), (String)relation.getType().getName());
            if (otherArtifact.areRelated(relTypeSide, (ArtifactReadable)artifact)) continue;
            this.getTransaction().relate(artifact, relType, (ArtifactId)otherArtifact);
        }
    }

    private void createAttributes(OwArtifact owArtifact, ArtifactId artifact, XResultData results) {
        for (OwAttribute owAttribute : owArtifact.getAttributes()) {
            if (!CoreAttributeTypes.Name.notEqual(owAttribute.getType().getId().longValue())) continue;
            OwAttributeType owAttrType = owAttribute.getType();
            AttributeTypeId attrType = OrcsCollectorWriter.getAttributeType(this.orcsApi, owAttrType);
            List values = owAttribute.getValues();
            for (Object value : values) {
                String valueOf = String.valueOf(value);
                if (!Strings.isValid((String)valueOf) || valueOf.equals("null")) continue;
                if (this.orcsApi.getOrcsTypes().getAttributeTypes().isFloatingType(attrType)) {
                    this.getTransaction().setSoleAttributeValue(artifact, attrType, (Object)Double.valueOf((String)value));
                    continue;
                }
                if (this.orcsApi.getOrcsTypes().getAttributeTypes().isIntegerType(attrType)) {
                    this.getTransaction().setSoleAttributeValue(artifact, attrType, (Object)Integer.valueOf((String)value));
                    continue;
                }
                if (this.orcsApi.getOrcsTypes().getAttributeTypes().isBooleanType(attrType)) {
                    Boolean set = this.getBoolean((String)value);
                    if (set == null) continue;
                    this.getTransaction().setSoleAttributeValue(artifact, attrType, (Object)set);
                    continue;
                }
                if (this.orcsApi.getOrcsTypes().getAttributeTypes().isDateType(attrType)) {
                    Date date = this.getDate(value);
                    if (date != null) {
                        this.getTransaction().setSoleAttributeValue(artifact, attrType, (Object)date);
                        continue;
                    }
                    throw new OseeArgumentException("Unexpected date format [%s]", new Object[]{value});
                }
                if (this.orcsApi.getOrcsTypes().getAttributeTypes().getMaxOccurrences(attrType) == 1) {
                    this.getTransaction().setSoleAttributeValue(artifact, attrType, value);
                    continue;
                }
                this.getTransaction().createAttribute(artifact, attrType, value);
            }
        }
    }

    private Date getDate(Object value) {
        Date date = null;
        boolean resolved = false;
        if (Strings.isNumeric((String)((String)value))) {
            date = new Date(Long.valueOf((String)value));
        } else {
            try {
                date = DateUtil.getDate((String)"MM/dd/yyyy", (String)((String)value));
                resolved = true;
            }
            catch (Exception exception) {}
            if (date == null) {
                try {
                    date = DateUtil.getDate((String)"MM/dd/yy", (String)((String)value));
                    resolved = true;
                }
                catch (Exception exception) {}
            }
            if (date == null) {
                try {
                    date = DateUtil.getDate((String)"MM/dd/yyyy hh:mm a", (String)((String)value));
                    resolved = true;
                }
                catch (Exception exception) {}
            }
            if (date == null) {
                try {
                    Calendar calendar = DatatypeConverter.parseDateTime((String)((String)value));
                    date = calendar.getTime();
                    resolved = true;
                }
                catch (Exception exception) {}
            }
        }
        if (Strings.isValid((String)((String)value)) && !resolved) {
            throw new OseeArgumentException("Date format [%s] not supported.", new Object[]{value});
        }
        return date;
    }

    private BranchId getBranch() {
        if (this.branch == null) {
            this.branch = (BranchId)((BranchQuery)this.orcsApi.getQueryFactory().branchQuery().andId(BranchId.valueOf((long)this.collector.getBranch().getId()))).getResults().getAtMostOneOrNull();
        }
        return this.branch;
    }

    public TransactionBuilder getTransaction() throws OseeCoreException {
        if (this.transaction == null) {
            this.transaction = this.orcsApi.getTransactionFactory().createTransaction(this.getBranch(), (ArtifactId)this.getUser(), this.collector.getPersistComment());
        }
        return this.transaction;
    }

    private ArtifactReadable getUser() {
        if (this.user == null) {
            this.user = (ArtifactReadable)((QueryBuilder)this.orcsApi.getQueryFactory().fromBranch((BranchId)CoreBranches.COMMON).and((AttributeTypeId)CoreAttributeTypes.UserId, this.collector.getAsUserId(), new QueryOption[0])).getResults().getExactlyOne();
        }
        return this.user;
    }
}

