/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.orcs.rest.internal.search.artifact.predicate;

import java.util.Collection;
import java.util.List;
import org.eclipse.osee.framework.core.data.IArtifactType;
import org.eclipse.osee.framework.jdk.core.type.OseeArgumentException;
import org.eclipse.osee.framework.jdk.core.type.OseeCoreException;
import org.eclipse.osee.framework.jdk.core.util.Conditions;
import org.eclipse.osee.orcs.rest.internal.search.artifact.PredicateHandler;
import org.eclipse.osee.orcs.rest.internal.search.artifact.predicate.PredicateHandlerUtil;
import org.eclipse.osee.orcs.rest.model.search.artifact.Predicate;
import org.eclipse.osee.orcs.rest.model.search.artifact.SearchMethod;
import org.eclipse.osee.orcs.search.QueryBuilder;

public class TypeEqualsPredicateHandler
implements PredicateHandler {
    @Override
    public QueryBuilder handle(QueryBuilder builder, Predicate predicate) throws OseeCoreException {
        if (predicate.getType() != SearchMethod.TYPE_EQUALS) {
            throw new OseeArgumentException("This predicate handler only supports [%s]", new Object[]{SearchMethod.TYPE_EQUALS});
        }
        List values = predicate.getValues();
        Conditions.checkNotNull((Object)values, (String)"values");
        Collection<IArtifactType> artTypes = PredicateHandlerUtil.getIArtifactTypes(values);
        if (!artTypes.isEmpty()) {
            builder.andTypeEquals(artTypes);
        }
        return builder;
    }
}

