/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.orcs.rest.internal.search.artifact.predicate;

import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.osee.framework.core.data.ArtifactId;
import org.eclipse.osee.framework.core.data.RelationTypeSide;
import org.eclipse.osee.framework.jdk.core.type.OseeArgumentException;
import org.eclipse.osee.framework.jdk.core.type.OseeCoreException;
import org.eclipse.osee.framework.jdk.core.util.Conditions;
import org.eclipse.osee.framework.jdk.core.util.GUID;
import org.eclipse.osee.orcs.rest.internal.search.artifact.PredicateHandler;
import org.eclipse.osee.orcs.rest.internal.search.artifact.predicate.PredicateHandlerUtil;
import org.eclipse.osee.orcs.rest.model.search.artifact.Predicate;
import org.eclipse.osee.orcs.rest.model.search.artifact.SearchMethod;
import org.eclipse.osee.orcs.search.QueryBuilder;

public class RelatedToPredicateHandler
implements PredicateHandler {
    @Override
    public QueryBuilder handle(QueryBuilder builder, Predicate predicate) throws OseeCoreException {
        block7: {
            if (predicate.getType() != SearchMethod.RELATED_TO) {
                throw new OseeArgumentException("This predicate handler only supports [%s]", new Object[]{SearchMethod.EXISTS_TYPE});
            }
            List typeParameters = predicate.getTypeParameters();
            List values = predicate.getValues();
            Conditions.checkNotNull((Object)typeParameters, (String)"typeParameters");
            Conditions.checkNotNull((Object)values, (String)"values");
            Collection<RelationTypeSide> types = PredicateHandlerUtil.getRelationTypeSides(typeParameters);
            LinkedList<ArtifactId> artIds = new LinkedList<ArtifactId>();
            for (String value : values) {
                if (GUID.isValid((String)value)) {
                    throw new UnsupportedOperationException();
                }
                artIds.add(ArtifactId.valueOf((String)value));
            }
            if (artIds.isEmpty()) break block7;
            if (artIds.size() == 1) {
                for (RelationTypeSide rts : types) {
                    builder.andRelatedTo(rts, (ArtifactId)artIds.iterator().next());
                }
            } else {
                for (RelationTypeSide rts : types) {
                    builder.andRelatedTo(rts, artIds);
                }
            }
        }
        return builder;
    }
}

