/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.orcs.rest.internal.search.artifact.predicate;

import java.util.Collection;
import java.util.LinkedHashSet;
import org.eclipse.osee.framework.core.data.AttributeTypeId;
import org.eclipse.osee.framework.core.data.IArtifactType;
import org.eclipse.osee.framework.core.data.IRelationType;
import org.eclipse.osee.framework.core.data.RelationTypeSide;
import org.eclipse.osee.framework.core.data.TokenFactory;
import org.eclipse.osee.framework.core.enums.RelationSide;
import org.eclipse.osee.framework.jdk.core.type.OseeCoreException;

public class PredicateHandlerUtil {
    public static Collection<AttributeTypeId> getAttributeTypes(Collection<String> types) throws OseeCoreException {
        LinkedHashSet<AttributeTypeId> attrTypes = new LinkedHashSet<AttributeTypeId>();
        for (String value : types) {
            long uuid = PredicateHandlerUtil.parseUuid(value);
            if (uuid == -1L) continue;
            attrTypes.add(AttributeTypeId.valueOf((Long)uuid));
        }
        return attrTypes;
    }

    public static Collection<IArtifactType> getIArtifactTypes(Collection<String> types) throws OseeCoreException {
        LinkedHashSet<IArtifactType> artTypes = new LinkedHashSet<IArtifactType>();
        for (String value : types) {
            long uuid = PredicateHandlerUtil.parseUuid(value);
            if (uuid == -1L) continue;
            artTypes.add(TokenFactory.createArtifactType((long)uuid, (String)"SearchArtifactType"));
        }
        return artTypes;
    }

    public static Collection<IRelationType> getIRelationTypes(Collection<String> rels) throws OseeCoreException {
        LinkedHashSet<IRelationType> types = new LinkedHashSet<IRelationType>();
        for (String value : rels) {
            long longUuid = PredicateHandlerUtil.parseUuid(value);
            if (longUuid == -1L) continue;
            types.add((IRelationType)TokenFactory.createRelationType((long)longUuid, (String)"SearchRelationType"));
        }
        return types;
    }

    public static Collection<RelationTypeSide> getRelationTypeSides(Collection<String> rels) throws OseeCoreException {
        LinkedHashSet<RelationTypeSide> relSides = new LinkedHashSet<RelationTypeSide>();
        for (String value : rels) {
            long longUuid;
            char sideChar = value.charAt(0);
            String uuid = value.substring(1);
            RelationSide side = RelationSide.SIDE_A;
            if (sideChar == 'B') {
                side = RelationSide.SIDE_B;
            }
            if ((longUuid = PredicateHandlerUtil.parseUuid(uuid)) == -1L) continue;
            relSides.add(RelationTypeSide.create((RelationSide)side, (long)longUuid, (String)"SearchRelationTypeSide"));
        }
        return relSides;
    }

    private static long parseUuid(String uuid) throws OseeCoreException {
        if (uuid.matches("-?\\d+")) {
            return Long.parseLong(uuid);
        }
        return -1L;
    }
}

