/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.orcs.rest.internal.search.artifact.predicate;

import java.util.HashSet;
import java.util.List;
import org.eclipse.osee.framework.jdk.core.type.OseeArgumentException;
import org.eclipse.osee.framework.jdk.core.type.OseeCoreException;
import org.eclipse.osee.framework.jdk.core.util.Conditions;
import org.eclipse.osee.orcs.rest.internal.search.artifact.PredicateHandler;
import org.eclipse.osee.orcs.rest.model.search.artifact.Predicate;
import org.eclipse.osee.orcs.rest.model.search.artifact.SearchMethod;
import org.eclipse.osee.orcs.search.QueryBuilder;

public class IdsPredicateHandler
implements PredicateHandler {
    @Override
    public QueryBuilder handle(QueryBuilder builder, Predicate predicate) throws OseeCoreException {
        if (predicate.getType() != SearchMethod.IDS) {
            throw new OseeArgumentException("This predicate handler only supports [%s]", new Object[]{SearchMethod.IDS});
        }
        List values = predicate.getValues();
        Conditions.checkNotNull((Object)values, (String)"values");
        HashSet<Long> rawIds = new HashSet<Long>();
        for (String value : values) {
            if (value.matches("\\d+")) {
                rawIds.add(Long.parseLong(value));
                continue;
            }
            throw new OseeArgumentException("Non integer value passed for IDS search: [%s]", new Object[]{value});
        }
        if (!rawIds.isEmpty()) {
            builder.andUuids(rawIds);
        }
        return builder;
    }
}

