/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.orcs.rest.internal.search.artifact.predicate;

import java.util.Collection;
import java.util.List;
import org.eclipse.osee.framework.core.data.AttributeTypeId;
import org.eclipse.osee.framework.core.data.IRelationType;
import org.eclipse.osee.framework.core.data.RelationTypeSide;
import org.eclipse.osee.framework.core.enums.RelationSide;
import org.eclipse.osee.framework.jdk.core.type.OseeArgumentException;
import org.eclipse.osee.framework.jdk.core.type.OseeCoreException;
import org.eclipse.osee.framework.jdk.core.util.Conditions;
import org.eclipse.osee.orcs.rest.internal.search.artifact.PredicateHandler;
import org.eclipse.osee.orcs.rest.internal.search.artifact.predicate.PredicateHandlerUtil;
import org.eclipse.osee.orcs.rest.model.search.artifact.Predicate;
import org.eclipse.osee.orcs.rest.model.search.artifact.SearchMethod;
import org.eclipse.osee.orcs.search.QueryBuilder;

public class ExistenceTypePredicateHandler
implements PredicateHandler {
    @Override
    public QueryBuilder handle(QueryBuilder builder, Predicate predicate) throws OseeCoreException {
        block10: {
            String existsType;
            List values;
            List typeParameters;
            block11: {
                if (!predicate.getType().isOfType(new SearchMethod[]{SearchMethod.EXISTS_TYPE, SearchMethod.NOT_EXISTS_TYPE})) {
                    throw new OseeArgumentException("This predicate handler only supports [%s] and [%s]", new Object[]{SearchMethod.EXISTS_TYPE, SearchMethod.NOT_EXISTS_TYPE});
                }
                typeParameters = predicate.getTypeParameters();
                values = predicate.getValues();
                Conditions.checkNotNullOrEmpty((Collection)typeParameters, (String)"typeParameters");
                Conditions.checkNotNull((Object)values, (String)"values");
                if (typeParameters.size() < 1) break block10;
                existsType = (String)typeParameters.get(0);
                if (!"attrType".equals(existsType)) break block11;
                Collection<AttributeTypeId> attributeTypes = PredicateHandlerUtil.getAttributeTypes(values);
                if (attributeTypes.isEmpty()) break block10;
                if (this.checkExists(predicate.getType())) {
                    builder.andExists(attributeTypes);
                } else {
                    builder.andNotExists(attributeTypes);
                }
                break block10;
            }
            if ("relType".equals(existsType)) {
                Collection<IRelationType> iRelationTypes = PredicateHandlerUtil.getIRelationTypes(values);
                for (IRelationType rt : iRelationTypes) {
                    if (this.checkExists(predicate.getType())) {
                        builder.andExists(rt);
                        continue;
                    }
                    builder.andNotExists(rt);
                }
            } else if ("relTypeSide".equals(existsType)) {
                RelationSide side = ((String)typeParameters.get(1)).equals("A") ? RelationSide.SIDE_A : RelationSide.SIDE_B;
                for (IRelationType rt : PredicateHandlerUtil.getIRelationTypes(values)) {
                    RelationTypeSide rts = RelationTypeSide.create((RelationSide)side, (long)rt.getId(), (String)"SearchRelTypeSide");
                    if (this.checkExists(predicate.getType())) {
                        builder.andExists(rts);
                        continue;
                    }
                    builder.andNotExists(rts);
                }
            }
        }
        return builder;
    }

    private boolean checkExists(SearchMethod method) {
        return method == SearchMethod.EXISTS_TYPE;
    }
}

