/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.orcs.rest.internal.search.artifact.predicate;

import java.util.Collection;
import java.util.List;
import org.eclipse.osee.framework.core.data.AttributeTypeId;
import org.eclipse.osee.framework.jdk.core.type.OseeArgumentException;
import org.eclipse.osee.framework.jdk.core.type.OseeCoreException;
import org.eclipse.osee.framework.jdk.core.util.Conditions;
import org.eclipse.osee.orcs.rest.internal.search.artifact.PredicateHandler;
import org.eclipse.osee.orcs.rest.internal.search.artifact.predicate.PredicateHandlerUtil;
import org.eclipse.osee.orcs.rest.model.search.artifact.Predicate;
import org.eclipse.osee.orcs.rest.model.search.artifact.SearchMethod;
import org.eclipse.osee.orcs.search.QueryBuilder;

public class AttributeTypePredicateHandler
implements PredicateHandler {
    @Override
    public QueryBuilder handle(QueryBuilder builder, Predicate predicate) throws OseeCoreException {
        if (predicate.getType() != SearchMethod.ATTRIBUTE_TYPE) {
            throw new OseeArgumentException("This predicate handler only supports [%s]", new Object[]{SearchMethod.ATTRIBUTE_TYPE});
        }
        List typeParameters = predicate.getTypeParameters();
        Collection<AttributeTypeId> attributeTypes = PredicateHandlerUtil.getAttributeTypes(typeParameters);
        List values = predicate.getValues();
        Conditions.checkNotNull((Object)values, (String)"values");
        if (values.size() == 1) {
            builder = (QueryBuilder)builder.and(attributeTypes, (String)values.iterator().next(), predicate.getOptions());
        } else {
            for (AttributeTypeId type : attributeTypes) {
                builder = (QueryBuilder)builder.and(type, (Collection)values, predicate.getOptions());
            }
        }
        return builder;
    }
}

