/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.orcs.rest.internal.search.artifact;

import java.util.LinkedList;
import java.util.List;
import javax.ws.rs.Consumes;
import javax.ws.rs.POST;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Request;
import javax.ws.rs.core.UriInfo;
import org.eclipse.osee.framework.core.data.ArtifactId;
import org.eclipse.osee.framework.core.data.TransactionId;
import org.eclipse.osee.framework.jdk.core.type.OseeCoreException;
import org.eclipse.osee.framework.jdk.core.type.ResultSet;
import org.eclipse.osee.orcs.OrcsApi;
import org.eclipse.osee.orcs.data.AttributeReadable;
import org.eclipse.osee.orcs.rest.internal.search.artifact.ArtifactSearch;
import org.eclipse.osee.orcs.rest.internal.search.artifact.dsl.DslFactory;
import org.eclipse.osee.orcs.rest.internal.search.artifact.dsl.SearchQueryBuilder;
import org.eclipse.osee.orcs.rest.model.search.artifact.RequestType;
import org.eclipse.osee.orcs.rest.model.search.artifact.SearchMatch;
import org.eclipse.osee.orcs.rest.model.search.artifact.SearchRequest;
import org.eclipse.osee.orcs.rest.model.search.artifact.SearchResponse;
import org.eclipse.osee.orcs.search.Match;
import org.eclipse.osee.orcs.search.QueryBuilder;
import org.eclipse.osee.orcs.search.QueryFactory;

public class ArtifactSearch_V1
extends ArtifactSearch {
    private final SearchQueryBuilder searchQueryBuilder;
    private final OrcsApi orcsApi;

    public ArtifactSearch_V1(UriInfo uriInfo, Request request, OrcsApi orcsApi) {
        super(uriInfo, request);
        this.orcsApi = orcsApi;
        this.searchQueryBuilder = DslFactory.createQueryBuilder();
    }

    @POST
    @Produces(value={"application/xml", "application/json"})
    @Consumes(value={"application/xml", "application/json"})
    public SearchResponse getSearchWithMatrixParams(SearchRequest parameters) throws OseeCoreException {
        return this.search(parameters);
    }

    private SearchResponse search(SearchRequest params) throws OseeCoreException {
        long startTime = System.currentTimeMillis();
        QueryFactory qFactory = this.orcsApi.getQueryFactory();
        QueryBuilder builder = this.searchQueryBuilder.build(qFactory, params);
        builder.includeDeletedArtifacts(params.isIncludeDeleted());
        if (params.getFromTx() > 0) {
            builder.fromTransaction(TransactionId.valueOf((long)params.getFromTx()));
        }
        SearchResponse result = new SearchResponse();
        RequestType request = params.getRequestType();
        if (request != null) {
            LinkedList<ArtifactId> localIds = new LinkedList<ArtifactId>();
            switch (request) {
                case COUNT: {
                    int total = builder.getCount();
                    result.setTotal(total);
                    break;
                }
                case IDS: {
                    for (ArtifactId art : builder.getResultsAsLocalIds()) {
                        localIds.add(art);
                    }
                    result.setIds(localIds);
                    result.setTotal(localIds.size());
                    break;
                }
                case MATCHES: {
                    ResultSet matches = builder.getMatches();
                    LinkedList<SearchMatch> searchMatches = new LinkedList<SearchMatch>();
                    for (Match match : matches) {
                        ArtifactId artId = (ArtifactId)match.getItem();
                        localIds.add(artId);
                        for (AttributeReadable attribute : match.getElements()) {
                            int attrId = attribute.getLocalId();
                            List locations = match.getLocation((Object)attribute);
                            searchMatches.add(new SearchMatch(artId, attrId, locations));
                        }
                    }
                    result.setIds(localIds);
                    result.setMatches(searchMatches);
                    result.setTotal(searchMatches.size());
                    break;
                }
                default: {
                    throw new UnsupportedOperationException();
                }
            }
        }
        result.setSearchRequest(params);
        result.setSearchTime(System.currentTimeMillis() - startTime);
        return result;
    }
}

