/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.orcs.rest.internal;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.concurrent.Callable;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.StreamingOutput;
import org.eclipse.osee.framework.core.data.ArtifactId;
import org.eclipse.osee.framework.core.data.ArtifactToken;
import org.eclipse.osee.framework.core.data.ArtifactTypeId;
import org.eclipse.osee.framework.core.data.AttributeId;
import org.eclipse.osee.framework.core.data.AttributeTypeId;
import org.eclipse.osee.framework.core.data.AttributeTypeToken;
import org.eclipse.osee.framework.core.data.BranchId;
import org.eclipse.osee.framework.core.data.OrcsTypeSheet;
import org.eclipse.osee.framework.core.data.OrcsTypesConfig;
import org.eclipse.osee.framework.core.data.OrcsTypesData;
import org.eclipse.osee.framework.core.data.OrcsTypesSheet;
import org.eclipse.osee.framework.core.data.OrcsTypesVersion;
import org.eclipse.osee.framework.core.enums.CoreArtifactTypes;
import org.eclipse.osee.framework.core.enums.CoreAttributeTypes;
import org.eclipse.osee.framework.core.enums.CoreBranches;
import org.eclipse.osee.framework.core.enums.CoreTupleTypes;
import org.eclipse.osee.framework.core.enums.SystemUser;
import org.eclipse.osee.framework.core.enums.TxChange;
import org.eclipse.osee.framework.jdk.core.type.OseeCoreException;
import org.eclipse.osee.framework.jdk.core.type.OseeStateException;
import org.eclipse.osee.framework.jdk.core.type.ResultSet;
import org.eclipse.osee.framework.jdk.core.util.Collections;
import org.eclipse.osee.framework.jdk.core.util.GUID;
import org.eclipse.osee.framework.jdk.core.util.Lib;
import org.eclipse.osee.framework.jdk.core.util.Strings;
import org.eclipse.osee.framework.resource.management.IResource;
import org.eclipse.osee.jaxrs.OseeWebApplicationException;
import org.eclipse.osee.jdbc.JdbcService;
import org.eclipse.osee.orcs.OrcsApi;
import org.eclipse.osee.orcs.OrcsTypes;
import org.eclipse.osee.orcs.data.ArtifactReadable;
import org.eclipse.osee.orcs.data.AttributeReadable;
import org.eclipse.osee.orcs.data.AttributeTypes;
import org.eclipse.osee.orcs.data.EnumEntry;
import org.eclipse.osee.orcs.data.EnumType;
import org.eclipse.osee.orcs.data.JaxEnumAttribute;
import org.eclipse.osee.orcs.data.JaxEnumEntry;
import org.eclipse.osee.orcs.data.OrcsTopicEvents;
import org.eclipse.osee.orcs.rest.internal.OrcsRestUtil;
import org.eclipse.osee.orcs.rest.model.TypesEndpoint;
import org.eclipse.osee.orcs.search.QueryBuilder;
import org.eclipse.osee.orcs.transaction.TransactionBuilder;
import org.osgi.service.event.Event;
import org.osgi.service.event.EventAdmin;

public class TypesEndpointImpl
implements TypesEndpoint {
    private final OrcsApi orcsApi;
    private final EventAdmin eventAdmin;
    private final JdbcService jdbcService;
    public static final String LOAD_OSEE_TYPE_DEF_NAME_AND_ID = "select attr.value, attr.art_id, attr.attr_id, attr.attr_type_id from osee_attribute attr, osee_txs txs where txs.BRANCH_ID = ? and attr.gamma_id = txs.gamma_id and txs.TX_CURRENT = 1 and attr.art_id in (select distinct art_id from osee_attribute where attr_id in (ATTR_IDS)) order by attr_type_id desc";

    public TypesEndpointImpl(OrcsApi orcsApi, EventAdmin eventAdmin, JdbcService jdbcService) {
        this.orcsApi = orcsApi;
        this.eventAdmin = eventAdmin;
        this.jdbcService = jdbcService;
    }

    private OrcsTypes getOrcsTypes() {
        return this.orcsApi.getOrcsTypes();
    }

    public Response getTypes() {
        return Response.ok().entity((Object)new StreamingOutput(){

            public void write(OutputStream output) throws WebApplicationException {
                Callable op = TypesEndpointImpl.this.getOrcsTypes().writeTypes(output);
                OrcsRestUtil.executeCallable(op);
            }
        }).build();
    }

    public Response setTypes(InputStream inputStream) {
        IResource resource = this.asResource("http.osee.model", inputStream);
        Callable op = this.getOrcsTypes().loadTypes(resource);
        OrcsRestUtil.executeCallable(op);
        this.getOrcsTypes().invalidateAll();
        return Response.ok().build();
    }

    public Response invalidateCaches() {
        this.getOrcsTypes().invalidateAll();
        return Response.ok().build();
    }

    private IResource asResource(String fileName, InputStream inputStream) {
        byte[] bytes;
        try {
            String types = Lib.inputStreamToString((InputStream)inputStream);
            bytes = types.getBytes("UTF-8");
        }
        catch (IOException iOException) {
            throw new OseeWebApplicationException(Response.Status.BAD_REQUEST, "Error parsing data", new Object[0]);
        }
        return new ByteResource(fileName, bytes);
    }

    public Response getEnums() {
        ArrayList<JaxEnumAttribute> attributes = new ArrayList<JaxEnumAttribute>();
        AttributeTypes attributeTypes = this.orcsApi.getOrcsTypes().getAttributeTypes();
        for (AttributeTypeToken type : attributeTypes.getAll()) {
            if (!attributeTypes.isEnumerated((AttributeTypeId)type)) continue;
            JaxEnumAttribute enumAttr = this.createJaxEnumAttribute(attributeTypes, type);
            attributes.add(enumAttr);
        }
        return Response.ok(attributes).build();
    }

    private JaxEnumAttribute createJaxEnumAttribute(AttributeTypes attributeTypes, AttributeTypeToken type) {
        JaxEnumAttribute enumAttr = new JaxEnumAttribute();
        enumAttr.setName(type.getName());
        enumAttr.setDescription(type.getDescription());
        enumAttr.setUuid(type.getIdString());
        enumAttr.setDataProvider(attributeTypes.getAttributeProviderId((AttributeTypeId)type));
        enumAttr.setDefaultValue(attributeTypes.getDefaultValue((AttributeTypeId)type));
        enumAttr.setMax(attributeTypes.getMaxOccurrences((AttributeTypeId)type));
        enumAttr.setMin(attributeTypes.getMinOccurrences((AttributeTypeId)type));
        enumAttr.setMediaType(attributeTypes.getMediaType((AttributeTypeId)type));
        EnumType enumType = attributeTypes.getEnumType((AttributeTypeId)type);
        enumAttr.setEnumTypeName(enumType.getName());
        enumAttr.setEnumTypeUuid(enumType.getIdString());
        EnumEntry[] enumEntryArray = enumType.values();
        int n = enumEntryArray.length;
        int n2 = 0;
        while (n2 < n) {
            EnumEntry enumEntry = enumEntryArray[n2];
            JaxEnumEntry entry = new JaxEnumEntry();
            entry.setName(enumEntry.getName());
            String guid = enumEntry.getGuid();
            Long uuid = null;
            if (Strings.isNumeric((String)guid)) {
                uuid = Long.valueOf(guid);
            }
            if (uuid != null) {
                entry.setUuid(uuid);
            }
            enumAttr.getEntries().add(entry);
            ++n2;
        }
        return enumAttr;
    }

    public Response getEnums(Long uuid) {
        AttributeTypeToken attrType = (AttributeTypeToken)this.orcsApi.getOrcsTypes().getAttributeTypes().get(uuid);
        JaxEnumAttribute jaxEnumAttribute = this.createJaxEnumAttribute(this.orcsApi.getOrcsTypes().getAttributeTypes(), attrType);
        return Response.ok().entity((Object)jaxEnumAttribute).build();
    }

    public Response getEnumEntries(Long uuid) {
        AttributeTypeToken attrType = (AttributeTypeToken)this.orcsApi.getOrcsTypes().getAttributeTypes().get(uuid);
        JaxEnumAttribute jaxEnumAttribute = this.createJaxEnumAttribute(this.orcsApi.getOrcsTypes().getAttributeTypes(), attrType);
        return Response.ok().entity((Object)jaxEnumAttribute.getEntries()).build();
    }

    public Response importOrcsTypes(OrcsTypesData typesData) {
        TransactionBuilder tx = this.orcsApi.getTransactionFactory().createTransaction((BranchId)CoreBranches.COMMON, (ArtifactId)SystemUser.OseeSystem, "Add Types to Common Branch");
        for (OrcsTypeSheet sheet : typesData.getSheets()) {
            String guid = GUID.create();
            if (Strings.isValid((String)sheet.getGuid())) {
                guid = sheet.getGuid();
            }
            Long id = Lib.generateArtifactIdAsInt();
            if (Strings.isNumeric((String)sheet.getId())) {
                id = Long.valueOf(sheet.getId());
            }
            ArtifactToken artifact = tx.createArtifact(CoreArtifactTypes.OseeTypeDefinition, sheet.getName(), guid, id.longValue());
            tx.setSoleAttributeValue((ArtifactId)artifact, (AttributeTypeId)CoreAttributeTypes.Active, (Object)true);
            tx.setSoleAttributeFromString((ArtifactId)artifact, (AttributeTypeId)CoreAttributeTypes.UriGeneralStringData, sheet.getTypesSheet());
        }
        tx.commit();
        tx = this.orcsApi.getTransactionFactory().createTransaction((BranchId)CoreBranches.COMMON, (ArtifactId)SystemUser.OseeSystem, "Add OseeTypeDef Tuples to Common Branch");
        for (ArtifactReadable artifact : ((QueryBuilder)this.orcsApi.getQueryFactory().fromBranch((BranchId)CoreBranches.COMMON).andIsOfType(new ArtifactTypeId[]{CoreArtifactTypes.OseeTypeDefinition})).getResults()) {
            tx.addTuple2(CoreTupleTypes.OseeTypeDef, (Object)OrcsTypesData.OSEE_TYPE_VERSION, (Object)((AttributeId)artifact.getAttributes((AttributeTypeId)CoreAttributeTypes.UriGeneralStringData).iterator().next()));
        }
        tx.commit();
        return Response.ok().entity((Object)"Success").build();
    }

    public Response dbInit() {
        Event event = new Event(OrcsTopicEvents.DBINIT_IMPORT_TYPES, null);
        this.eventAdmin.postEvent(event);
        return Response.ok().entity((Object)"Success").build();
    }

    public Response getConfig() {
        OrcsTypesConfig config = new OrcsTypesConfig();
        config.setCurrentVersion(OrcsTypesData.OSEE_TYPE_VERSION.intValue());
        LinkedList attrIds = new LinkedList();
        this.jdbcService.getClient().runQuery(stmt1 -> {
            int version = stmt1.getInt("e1");
            OrcsTypesVersion typeVersion = new OrcsTypesVersion();
            config.getVersions().add(typeVersion);
            typeVersion.setVersionNum(version);
            this.jdbcService.getClient().runQuery(stmt2 -> {
                OrcsTypesSheet sheet = new OrcsTypesSheet();
                sheet.setAttrId((long)stmt2.getInt("attr_id"));
                attrIds.add(new Long(sheet.getAttrId()).intValue());
                typeVersion.getSheets().add(sheet);
            }, "select uri, attr.attr_id from osee_tuple2 t2, osee_txs txs1, osee_attribute attr, osee_txs txs2 where tuple_type = ? and t2.gamma_id = txs1.gamma_id and txs1.branch_id = ? and txs1.tx_current = ? and e1 = ? and e2 = attr.attr_id and attr.gamma_id = txs2.gamma_id and txs2.branch_id = txs1.branch_id and txs2.tx_current = ?", new Object[]{CoreTupleTypes.OseeTypeDef, CoreBranches.COMMON, TxChange.CURRENT.getValue(), typeVersion.getVersionNum(), TxChange.CURRENT.getValue()});
        }, "select distinct e1 from osee_tuple2 where tuple_type = ?", new Object[]{CoreTupleTypes.OseeTypeDef.getId()});
        String query = LOAD_OSEE_TYPE_DEF_NAME_AND_ID.replace("ATTR_IDS", Collections.toString((String)",", attrIds));
        this.jdbcService.getClient().runQuery(stmt -> {
            block3: {
                long artId;
                long attrTypeId;
                block2: {
                    long attrId = stmt.getLong("attr_id");
                    attrTypeId = stmt.getLong("attr_type_id");
                    artId = stmt.getLong("art_id");
                    if (!CoreAttributeTypes.UriGeneralStringData.getId().equals(attrTypeId)) break block2;
                    for (OrcsTypesSheet sheet : this.getSheetsFromAttrId(attrId, config)) {
                        sheet.setArtifactId(artId);
                    }
                    break block3;
                }
                if (!CoreAttributeTypes.Name.getId().equals(attrTypeId)) break block3;
                for (OrcsTypesSheet sheet : this.getSheetsFromArtId(artId, config)) {
                    sheet.setName(stmt.getString("value"));
                }
            }
        }, query, new Object[]{CoreBranches.COMMON.getId()});
        return Response.ok((Object)config).build();
    }

    private Collection<OrcsTypesSheet> getSheetsFromArtId(Long artId, OrcsTypesConfig config) {
        LinkedList<OrcsTypesSheet> sheets = new LinkedList<OrcsTypesSheet>();
        for (OrcsTypesVersion version : config.getVersions()) {
            for (OrcsTypesSheet sheet : version.getSheets()) {
                if (!artId.equals(sheet.getArtifactId())) continue;
                sheets.add(sheet);
            }
        }
        return sheets;
    }

    private Collection<OrcsTypesSheet> getSheetsFromAttrId(Long attrId, OrcsTypesConfig config) {
        LinkedList<OrcsTypesSheet> sheets = new LinkedList<OrcsTypesSheet>();
        for (OrcsTypesVersion version : config.getVersions()) {
            for (OrcsTypesSheet sheet : version.getSheets()) {
                if (!attrId.equals(sheet.getAttrId())) continue;
                sheets.add(sheet);
            }
        }
        return sheets;
    }

    public Response getConfigSheets() {
        LinkedList<OrcsTypesSheet> sheets = new LinkedList<OrcsTypesSheet>();
        for (ArtifactReadable art : ((QueryBuilder)this.orcsApi.getQueryFactory().fromBranch((BranchId)CoreBranches.COMMON).andIsOfType(new ArtifactTypeId[]{CoreArtifactTypes.OseeTypeDefinition})).getResults()) {
            OrcsTypesSheet sheet = new OrcsTypesSheet();
            sheet.setArtifactId(art.getId().longValue());
            sheet.setName(art.getName());
            ResultSet attributes = art.getAttributes((AttributeTypeId)CoreAttributeTypes.UriGeneralStringData);
            if (!attributes.isEmpty()) {
                sheet.setAttrId(((AttributeReadable)attributes.iterator().next()).getId().longValue());
            }
            sheets.add(sheet);
        }
        return Response.ok(sheets).build();
    }

    public Response setConfigSheets(OrcsTypesVersion version) {
        TransactionBuilder tx = this.orcsApi.getTransactionFactory().createTransaction((BranchId)CoreBranches.COMMON, (ArtifactId)SystemUser.OseeSystem, "Set OSEE Types Configuration");
        long verNum = version.getVersionNum();
        Iterable attrIds = this.orcsApi.getQueryFactory().tupleQuery().getTuple2Raw(CoreTupleTypes.OseeTypeDef, (BranchId)CoreBranches.COMMON, (Object)version.getVersionNum());
        Iterator iterator = attrIds.iterator();
        if (iterator.hasNext()) {
            Long cfr_ignored_0 = (Long)iterator.next();
            throw new OseeStateException("Configuration already exist for version %s; these need to be manually removed", new Object[]{version});
        }
        for (OrcsTypesSheet sheet : version.getSheets()) {
            tx.addTuple2(CoreTupleTypes.OseeTypeDef, (Object)verNum, (Object)AttributeId.valueOf((long)sheet.getAttrId()));
        }
        tx.commit();
        return Response.ok((Object)version).build();
    }

    private static final class ByteResource
    implements IResource {
        private final String filename;
        private final byte[] bytes;

        public ByteResource(String filename, byte[] bytes) {
            this.filename = filename;
            this.bytes = bytes;
        }

        public InputStream getContent() throws OseeCoreException {
            return new ByteArrayInputStream(this.bytes);
        }

        public URI getLocation() {
            String modelName = this.filename;
            if (!modelName.endsWith(".osee")) {
                modelName = String.valueOf(modelName) + ".osee";
            }
            try {
                return new URI("osee:/" + modelName);
            }
            catch (URISyntaxException ex) {
                throw new OseeCoreException((Throwable)ex, "Error creating URI for [%s]", new Object[]{modelName});
            }
        }

        public String getName() {
            return this.filename;
        }

        public boolean isCompressed() {
            return false;
        }
    }
}

