/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.orcs.rest.internal;

import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.UriInfo;
import org.eclipse.osee.framework.core.data.ArtifactId;
import org.eclipse.osee.framework.core.data.BranchId;
import org.eclipse.osee.framework.core.data.Tuple3Type;
import org.eclipse.osee.framework.core.data.Tuple4Type;
import org.eclipse.osee.framework.core.data.TupleFamilyId;
import org.eclipse.osee.framework.core.data.TupleTypeId;
import org.eclipse.osee.framework.core.enums.CoreBranches;
import org.eclipse.osee.framework.core.enums.CoreTupleFamilyTypes;
import org.eclipse.osee.framework.core.enums.SystemUser;
import org.eclipse.osee.framework.jdk.core.util.Strings;
import org.eclipse.osee.orcs.OrcsApi;
import org.eclipse.osee.orcs.data.ArtifactReadable;
import org.eclipse.osee.orcs.search.QueryBuilder;
import org.eclipse.osee.orcs.search.QueryFactory;
import org.eclipse.osee.orcs.transaction.TransactionBuilder;

public class TupleResource {
    private final OrcsApi orcsApi;
    @Context
    private UriInfo uriInfo;
    private final BranchId branch;

    public TupleResource(OrcsApi orcsApi, BranchId branch) {
        this.orcsApi = orcsApi;
        this.branch = branch;
    }

    @Path(value="init")
    @POST
    public void addTuples() {
        TransactionBuilder tx = this.orcsApi.getTransactionFactory().createTransaction(this.branch, (ArtifactId)this.getUser(), "Init Tuples");
        Tuple3Type ViewApplicability22 = Tuple3Type.valueOf((TupleFamilyId)CoreTupleFamilyTypes.ProductLineFamily, (long)20L);
        Tuple4Type OseeTypeDef22 = Tuple4Type.valueOf((TupleFamilyId)CoreTupleFamilyTypes.DefaultFamily, (long)40L);
        tx.addTuple3(ViewApplicability22, (Object)412215L, (Object)466L, (Object)4L);
        tx.addTuple4(OseeTypeDef22, (Object)222112L, (Object)44L, (Object)54445L, (Object)66L);
        tx.commit();
    }

    @Path(value="/tuple2")
    @POST
    public <E1, E2> Long addTuple2(@QueryParam(value="tupleType") Long tupleType, @QueryParam(value="e1") String e1, @QueryParam(value="e2") String e2) {
        Object element1 = e1;
        Object element2 = e2;
        if (Strings.isNumeric((String)e1)) {
            element1 = Long.parseLong(e1);
        }
        if (Strings.isNumeric((String)e2)) {
            element2 = Long.parseLong(e2);
        }
        TupleTypeId typleTypeId = TupleTypeId.valueOf((long)tupleType);
        TransactionBuilder tx = this.orcsApi.getTransactionFactory().createTransaction(this.branch, (ArtifactId)this.getUser(), "Add Tuple 2");
        Long toReturn = tx.addTuple(typleTypeId, new Object[]{element1, element2});
        tx.commit();
        return toReturn;
    }

    @Path(value="/tuple3")
    @POST
    public <E1, E2> Long addTuple3(@QueryParam(value="tupleType") Long tupleType, @QueryParam(value="e1") String e1, @QueryParam(value="e2") String e2, @QueryParam(value="e3") String e3) {
        Object element1 = e1;
        Object element2 = e2;
        Object element3 = e3;
        if (Strings.isNumeric((String)e1)) {
            element1 = Long.parseLong(e1);
        }
        if (Strings.isNumeric((String)e2)) {
            element2 = Long.parseLong(e2);
        }
        if (Strings.isNumeric((String)e3)) {
            element3 = Long.parseLong(e3);
        }
        TupleTypeId typleTypeId = TupleTypeId.valueOf((long)tupleType);
        TransactionBuilder tx = this.orcsApi.getTransactionFactory().createTransaction(this.branch, (ArtifactId)this.getUser(), "Add Tuple 3");
        Long toReturn = tx.addTuple(typleTypeId, new Object[]{element1, element2, element3});
        tx.commit();
        return toReturn;
    }

    @Path(value="/tuple4")
    @POST
    public <E1, E2> Long addTuple4(@QueryParam(value="tupleType") Long tupleType, @QueryParam(value="e1") String e1, @QueryParam(value="e2") String e2, @QueryParam(value="e3") String e3, @QueryParam(value="e4") String e4) {
        Object element1 = e1;
        Object element2 = e2;
        Object element3 = e3;
        Object element4 = e4;
        if (Strings.isNumeric((String)e1)) {
            element1 = Long.parseLong(e1);
        }
        if (Strings.isNumeric((String)e2)) {
            element2 = Long.parseLong(e2);
        }
        if (Strings.isNumeric((String)e3)) {
            element3 = Long.parseLong(e3);
        }
        if (Strings.isNumeric((String)e4)) {
            element4 = Long.parseLong(e4);
        }
        TupleTypeId typleTypeId = TupleTypeId.valueOf((long)tupleType);
        TransactionBuilder tx = this.orcsApi.getTransactionFactory().createTransaction(this.branch, (ArtifactId)this.getUser(), "Add Tuple 4");
        Long toReturn = tx.addTuple(typleTypeId, new Object[]{element1, element2, element3, element4});
        tx.commit();
        return toReturn;
    }

    private BranchId getAdminBranch() {
        return CoreBranches.COMMON;
    }

    private ArtifactReadable getUser() {
        return (ArtifactReadable)((QueryBuilder)this.getQuery().fromBranch(this.getAdminBranch()).andIds((ArtifactId)SystemUser.OseeSystem)).getResults().getExactlyOne();
    }

    private QueryFactory getQuery() {
        return this.orcsApi.getQueryFactory();
    }
}

