/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.orcs.rest.internal;

import java.io.Closeable;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.StringReader;
import java.util.List;
import java.util.Properties;
import javax.script.ScriptContext;
import javax.script.ScriptEngine;
import javax.script.ScriptException;
import javax.script.SimpleScriptContext;
import javax.ws.rs.Consumes;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.FormParam;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.HttpHeaders;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.StreamingOutput;
import org.eclipse.osee.framework.jdk.core.util.Lib;
import org.eclipse.osee.framework.jdk.core.util.Strings;

@Path(value="script")
public class OrcsScriptResource {
    private final ScriptEngine engine;

    public OrcsScriptResource(ScriptEngine engine) {
        this.engine = engine;
    }

    @GET
    @Produces(value={"application/json", "application/xml", "text/plain"})
    public Response getScriptResult(@Context HttpHeaders httpHeaders, @DefaultValue(value="") @QueryParam(value="script") String script, @DefaultValue(value="") @QueryParam(value="parameters") String parameters, @DefaultValue(value="") @QueryParam(value="filename") String filename, @DefaultValue(value="false") @QueryParam(value="debug") boolean debug) {
        return this.evaluateScript(httpHeaders, script, parameters, filename, debug);
    }

    @POST
    @Consumes(value={"application/x-www-form-urlencoded"})
    @Produces(value={"application/json", "application/xml", "text/plain"})
    public Response postScript(@Context HttpHeaders httpHeaders, @DefaultValue(value="") @FormParam(value="script") String script, @DefaultValue(value="") @FormParam(value="parameters") String parameters, @DefaultValue(value="") @FormParam(value="filename") String filename, @DefaultValue(value="false") @FormParam(value="debug") boolean debug) {
        return this.evaluateScript(httpHeaders, script, parameters, filename, debug);
    }

    private Response evaluateScript(@Context HttpHeaders httpHeaders, final String script, String parameters, String filename, final boolean debug) {
        final boolean isJsonOutput = this.isJsonMediaType(httpHeaders.getAcceptableMediaTypes());
        final Properties properties = this.parseParamaters(parameters);
        StreamingOutput output = new StreamingOutput(){

            public void write(OutputStream output) throws WebApplicationException {
                OutputStreamWriter writer = null;
                try {
                    writer = new OutputStreamWriter(output);
                    SimpleScriptContext context = new SimpleScriptContext();
                    context.setWriter(writer);
                    context.setErrorWriter(writer);
                    context.setAttribute("output.debug", debug, 100);
                    for (String key : properties.stringPropertyNames()) {
                        context.setAttribute(key, properties.getProperty(key), 100);
                    }
                    if (!isJsonOutput) {
                        context.setAttribute("output.mime-type", "excel-xml", 100);
                    }
                    OrcsScriptResource.this.engine.eval(script, (ScriptContext)context);
                }
                catch (ScriptException ex) {
                    throw new WebApplicationException((Throwable)ex);
                }
            }
        };
        Response.ResponseBuilder builder = Response.ok((Object)output);
        if (isJsonOutput) {
            builder.header("Content-Type", (Object)"application/json");
        } else {
            builder.header("Content-Type", (Object)"application/xml");
        }
        if (Strings.isValid((String)filename)) {
            StringBuilder fileBuilder = new StringBuilder("attachment; filename=");
            fileBuilder.append(Lib.removeExtension((String)filename));
            fileBuilder.append("_");
            fileBuilder.append(Lib.getDateTimeString());
            String extension = Lib.getExtension((String)filename);
            if (!Strings.isValid((String)extension)) {
                fileBuilder.append(".xml");
            } else {
                fileBuilder.append(extension);
            }
            builder.header("Content-Disposition", (Object)fileBuilder.toString());
        }
        return builder.build();
    }

    private boolean isJsonMediaType(List<MediaType> acceptableMediaTypes) {
        boolean result = true;
        for (MediaType type : acceptableMediaTypes) {
            if (!MediaType.APPLICATION_XML_TYPE.equals((Object)type)) continue;
            result = false;
            break;
        }
        return result;
    }

    private Properties parseParamaters(String parameters) {
        Properties properties = new Properties();
        if (Strings.isValid((String)parameters)) {
            StringReader reader = null;
            try {
                try {
                    reader = new StringReader(parameters);
                    properties.load(reader);
                }
                catch (IOException ex) {
                    throw new WebApplicationException((Throwable)ex, Response.Status.BAD_REQUEST);
                }
            }
            catch (Throwable throwable) {
                Lib.close(reader);
                throw throwable;
            }
            Lib.close((Closeable)reader);
        }
        return properties;
    }
}

