/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.orcs.rest.internal;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Callable;
import javax.ws.rs.core.Response;
import org.eclipse.osee.framework.core.data.TransactionId;
import org.eclipse.osee.framework.jdk.core.type.OseeCoreException;
import org.eclipse.osee.framework.jdk.core.type.ResultSet;
import org.eclipse.osee.orcs.data.BranchReadable;
import org.eclipse.osee.orcs.data.TransactionReadable;
import org.eclipse.osee.orcs.rest.model.Branch;
import org.eclipse.osee.orcs.rest.model.Transaction;

public final class OrcsRestUtil {
    private OrcsRestUtil() {
    }

    public static <T> T executeCallable(Callable<T> callable) {
        try {
            return callable.call();
        }
        catch (Exception ex) {
            throw OseeCoreException.wrap((Throwable)ex);
        }
    }

    public static Response asResponse(boolean modified) {
        Response.ResponseBuilder builder = modified ? Response.ok() : Response.notModified();
        return builder.build();
    }

    public static List<Transaction> asTransactions(ResultSet<? extends TransactionReadable> results) {
        ArrayList<Transaction> toReturn = new ArrayList<Transaction>(results.size());
        for (TransactionReadable data : results) {
            toReturn.add(OrcsRestUtil.asTransaction(data));
        }
        return toReturn;
    }

    public static List<Branch> asBranches(ResultSet<? extends BranchReadable> results) {
        ArrayList<Branch> toReturn = new ArrayList<Branch>(results.size());
        for (BranchReadable data : results) {
            toReturn.add(OrcsRestUtil.asBranch(data));
        }
        return toReturn;
    }

    public static Branch asBranch(BranchReadable src) {
        Branch data = new Branch();
        data.setArchiveState(src.getArchiveState());
        data.setAssociatedArtifact(src.getAssociatedArtifact());
        data.setBaseTransactionId(src.getBaseTransaction());
        data.setBranchState(src.getBranchState());
        data.setBranchType(src.getBranchType());
        data.setInheritAccessControl(src.isInheritAccessControl());
        data.setName(src.getName());
        data.setParentBranch(src.getParentBranch());
        data.setSourceTransactionId(src.getSourceTransaction());
        data.setBranchUuid(src.getGuid().longValue());
        return data;
    }

    public static Transaction asTransaction(TransactionReadable tx) {
        Transaction data = new Transaction();
        data.setTxId((TransactionId)tx);
        data.setAuthor(tx.getAuthor());
        data.setBranchUuid(tx.getBranch().getId().longValue());
        data.setComment(tx.getComment());
        data.setCommitArt(tx.getCommitArt());
        data.setTimeStamp(tx.getDate());
        data.setTxType(tx.getTxType());
        return data;
    }
}

