/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.orcs.rest.internal;

import java.util.HashSet;
import java.util.Set;
import javax.script.ScriptEngine;
import javax.ws.rs.ApplicationPath;
import javax.ws.rs.core.Application;
import org.eclipse.osee.activity.api.ActivityLog;
import org.eclipse.osee.framework.resource.management.IResourceManager;
import org.eclipse.osee.jdbc.JdbcService;
import org.eclipse.osee.orcs.OrcsApi;
import org.eclipse.osee.orcs.rest.admin.LinkUpdateResource;
import org.eclipse.osee.orcs.rest.internal.BranchEndpointImpl;
import org.eclipse.osee.orcs.rest.internal.BranchesResource;
import org.eclipse.osee.orcs.rest.internal.DatastoreEndpointImpl;
import org.eclipse.osee.orcs.rest.internal.IndexerEndpointImpl;
import org.eclipse.osee.orcs.rest.internal.KeyValueResource;
import org.eclipse.osee.orcs.rest.internal.OrcsScriptResource;
import org.eclipse.osee.orcs.rest.internal.ResourcesEndpointImpl;
import org.eclipse.osee.orcs.rest.internal.TransactionEndpointImpl;
import org.eclipse.osee.orcs.rest.internal.TypesEndpointImpl;
import org.eclipse.osee.orcs.rest.internal.writer.OrcsWriterEndpointImpl;
import org.osgi.service.event.EventAdmin;

@ApplicationPath(value="orcs")
public class OrcsApplication
extends Application {
    private final Set<Object> resources = new HashSet<Object>();
    private final Set<Class<?>> classes = new HashSet();
    private static OrcsApi orcsApi;
    private IResourceManager resourceManager;
    private ActivityLog activityLog;
    private JdbcService jdbcService;
    private EventAdmin eventAdmin;

    public void setOrcsApi(OrcsApi orcsApi) {
        OrcsApplication.orcsApi = orcsApi;
    }

    public void setJdbcService(JdbcService jdbcService) {
        this.jdbcService = jdbcService;
    }

    public void setActivityLog(ActivityLog activityLog) {
        this.activityLog = activityLog;
    }

    public void setEventAdmin(EventAdmin eventAdmin) {
        this.eventAdmin = eventAdmin;
    }

    public void setResourceManager(IResourceManager resourceManager) {
        this.resourceManager = resourceManager;
    }

    public static OrcsApi getOrcsApi() {
        return orcsApi;
    }

    public void start() {
        ScriptEngine engine = orcsApi.getScriptEngine();
        this.resources.add(new OrcsScriptResource(engine));
        this.classes.add(BranchesResource.class);
        this.resources.add(new BranchEndpointImpl(orcsApi, this.resourceManager, this.activityLog));
        this.resources.add(new OrcsWriterEndpointImpl(orcsApi));
        this.resources.add(new TransactionEndpointImpl(orcsApi));
        this.resources.add(new TypesEndpointImpl(orcsApi, this.eventAdmin, this.jdbcService));
        this.resources.add(new IndexerEndpointImpl(orcsApi));
        this.resources.add(new ResourcesEndpointImpl(this.resourceManager));
        this.resources.add(new DatastoreEndpointImpl(orcsApi, this.activityLog));
        this.resources.add(new KeyValueResource(orcsApi));
        this.resources.add(new LinkUpdateResource(orcsApi));
    }

    public void stop() {
        this.resources.clear();
        this.classes.clear();
    }

    public Set<Class<?>> getClasses() {
        return this.classes;
    }

    public Set<Object> getSingletons() {
        return this.resources;
    }
}

