/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.orcs.rest.internal;

import java.net.URI;
import java.util.HashMap;
import java.util.concurrent.Callable;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;
import org.eclipse.osee.activity.api.ActivityLog;
import org.eclipse.osee.orcs.OrcsAdmin;
import org.eclipse.osee.orcs.OrcsApi;
import org.eclipse.osee.orcs.OrcsMetaData;
import org.eclipse.osee.orcs.rest.internal.OrcsRestUtil;
import org.eclipse.osee.orcs.rest.model.DatastoreEndpoint;
import org.eclipse.osee.orcs.rest.model.DatastoreInfo;
import org.eclipse.osee.orcs.rest.model.DatastoreInitOptions;

public class DatastoreEndpointImpl
implements DatastoreEndpoint {
    private final OrcsApi orcsApi;
    @Context
    private UriInfo uriInfo;
    private final ActivityLog activityLog;

    public DatastoreEndpointImpl(OrcsApi orcsApi, ActivityLog activityLog) {
        this.orcsApi = orcsApi;
        this.activityLog = activityLog;
    }

    protected void setUriInfo(UriInfo uriInfo) {
        this.uriInfo = uriInfo;
    }

    protected UriInfo getUriInfo() {
        return this.uriInfo;
    }

    private OrcsAdmin getOrcsAdmin() {
        return this.orcsApi.getAdminOps();
    }

    public DatastoreInfo getInfo() {
        OrcsAdmin adminOps = this.getOrcsAdmin();
        Callable callable = adminOps.createFetchOrcsMetaData();
        OrcsMetaData metaData = (OrcsMetaData)OrcsRestUtil.executeCallable(callable);
        return this.asDatastoreInfo(metaData);
    }

    public Response initialize(DatastoreInitOptions options) {
        this.activityLog.setEnabled(false);
        OrcsAdmin adminOps = this.getOrcsAdmin();
        HashMap<String, String> parameters = new HashMap<String, String>();
        parameters.put("schema.table.data.namespace", options.getTableDataSpace());
        parameters.put("schema.index.data.namespace", options.getIndexDataSpace());
        parameters.put("schema.user.file.specified.schema.names", Boolean.toString(options.isUseFileSpecifiedSchemas()));
        Callable callable = adminOps.createDatastore(parameters);
        OrcsMetaData metaData = (OrcsMetaData)OrcsRestUtil.executeCallable(callable);
        this.activityLog.setEnabled(true);
        this.activityLog.unInitialize();
        UriInfo uriInfo = this.getUriInfo();
        URI location = this.getDatastoreLocation(uriInfo);
        return Response.created((URI)location).entity((Object)this.asDatastoreInfo(metaData)).build();
    }

    public Response migrate(DatastoreInitOptions options) {
        this.activityLog.setEnabled(false);
        OrcsAdmin adminOps = this.getOrcsAdmin();
        Callable callable = adminOps.migrateDatastore();
        OrcsMetaData metaData = (OrcsMetaData)OrcsRestUtil.executeCallable(callable);
        URI location = this.getDatastoreLocation(this.uriInfo);
        return Response.created((URI)location).entity((Object)this.asDatastoreInfo(metaData)).build();
    }

    private URI getDatastoreLocation(UriInfo uriInfo) {
        return uriInfo.getRequestUriBuilder().path("../").path("info").build(new Object[0]);
    }

    private DatastoreInfo asDatastoreInfo(OrcsMetaData metaData) {
        DatastoreInfo info = new DatastoreInfo();
        info.setProperties(metaData.getProperties());
        return info;
    }
}

