/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.orcs.rest.internal;

import javax.ws.rs.GET;
import javax.ws.rs.HeaderParam;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Request;
import javax.ws.rs.core.UriInfo;
import org.eclipse.osee.framework.core.data.BranchId;
import org.eclipse.osee.framework.core.data.UserId;
import org.eclipse.osee.framework.core.enums.BranchType;
import org.eclipse.osee.framework.jdk.core.type.OseeCoreException;
import org.eclipse.osee.framework.jdk.core.type.ResultSet;
import org.eclipse.osee.orcs.rest.internal.ApplicabilityEndpointImpl;
import org.eclipse.osee.orcs.rest.internal.BranchResource;
import org.eclipse.osee.orcs.rest.internal.HtmlWriter;
import org.eclipse.osee.orcs.rest.internal.OrcsApplication;
import org.eclipse.osee.orcs.rest.internal.TupleResource;
import org.eclipse.osee.orcs.rest.model.ApplicabilityEndpoint;
import org.eclipse.osee.orcs.search.BranchQuery;

@Path(value="branch")
public class BranchesResource {
    @Context
    UriInfo uriInfo;
    @Context
    Request request;

    @Path(value="{uuid}")
    public BranchResource getBranch(@PathParam(value="uuid") BranchId id) {
        return new BranchResource(this.uriInfo, this.request, id, OrcsApplication.getOrcsApi());
    }

    @GET
    @Produces(value={"text/html"})
    public String getAsHtml() throws OseeCoreException {
        BranchQuery query = OrcsApplication.getOrcsApi().getQueryFactory().branchQuery();
        ResultSet results = ((BranchQuery)query.andIsOfType(new BranchType[]{BranchType.BASELINE, BranchType.WORKING})).getResults();
        HtmlWriter writer = new HtmlWriter(this.uriInfo);
        return writer.toHtml((Iterable<? extends Object>)results);
    }

    @Path(value="{branch}/tuples")
    public TupleResource getTuples(@PathParam(value="branch") BranchId branch) {
        return new TupleResource(OrcsApplication.getOrcsApi(), branch);
    }

    @Path(value="{branch}/applic")
    public ApplicabilityEndpoint getApplicability(@PathParam(value="branch") BranchId branch, @HeaderParam(value="osee.account.id") UserId accountId) {
        return new ApplicabilityEndpointImpl(OrcsApplication.getOrcsApi(), branch, accountId);
    }
}

