/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.orcs.rest.internal;

import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Request;
import javax.ws.rs.core.UriInfo;
import org.eclipse.osee.framework.core.data.BranchId;
import org.eclipse.osee.framework.jdk.core.type.OseeCoreException;
import org.eclipse.osee.framework.jdk.core.type.ResultSet;
import org.eclipse.osee.orcs.OrcsApi;
import org.eclipse.osee.orcs.rest.internal.ArtifactsResource;
import org.eclipse.osee.orcs.rest.internal.HtmlWriter;
import org.eclipse.osee.orcs.search.BranchQuery;

public class BranchResource {
    @Context
    UriInfo uriInfo;
    @Context
    Request request;
    BranchId branchId;
    OrcsApi orcsApi;

    public BranchResource(UriInfo uriInfo, Request request, BranchId branchId, OrcsApi orcsApi) {
        this.uriInfo = uriInfo;
        this.request = request;
        this.branchId = branchId;
        this.orcsApi = orcsApi;
    }

    @Path(value="artifact")
    public ArtifactsResource getArtifacts() {
        return new ArtifactsResource(this.uriInfo, this.request, this.branchId, this.orcsApi);
    }

    @GET
    @Produces(value={"text/html"})
    public String getAsHtml() throws OseeCoreException {
        BranchQuery query = this.orcsApi.getQueryFactory().branchQuery();
        ResultSet results = ((BranchQuery)query.andId(this.branchId)).getResults();
        HtmlWriter writer = new HtmlWriter(this.uriInfo);
        return writer.toHtml((Iterable<? extends Object>)results);
    }
}

