/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.orcs.rest.internal;

import com.google.common.collect.Lists;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.logging.Level;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.HttpHeaders;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriBuilder;
import javax.ws.rs.core.UriInfo;
import org.eclipse.osee.activity.api.Activity;
import org.eclipse.osee.activity.api.ActivityLog;
import org.eclipse.osee.activity.api.ActivityType;
import org.eclipse.osee.framework.core.data.ArtifactId;
import org.eclipse.osee.framework.core.data.BranchId;
import org.eclipse.osee.framework.core.data.IOseeBranch;
import org.eclipse.osee.framework.core.data.TransactionId;
import org.eclipse.osee.framework.core.data.TransactionToken;
import org.eclipse.osee.framework.core.enums.BranchArchivedState;
import org.eclipse.osee.framework.core.enums.BranchState;
import org.eclipse.osee.framework.core.enums.BranchType;
import org.eclipse.osee.framework.core.model.change.CompareResults;
import org.eclipse.osee.framework.jdk.core.type.OseeArgumentException;
import org.eclipse.osee.framework.jdk.core.type.OseeCoreException;
import org.eclipse.osee.framework.jdk.core.type.PropertyStore;
import org.eclipse.osee.framework.jdk.core.type.ResultSet;
import org.eclipse.osee.framework.jdk.core.util.Compare;
import org.eclipse.osee.framework.jdk.core.util.Conditions;
import org.eclipse.osee.framework.jdk.core.util.Strings;
import org.eclipse.osee.framework.logging.OseeLevel;
import org.eclipse.osee.framework.logging.OseeLog;
import org.eclipse.osee.framework.resource.management.IResourceLocator;
import org.eclipse.osee.framework.resource.management.IResourceManager;
import org.eclipse.osee.jaxrs.OseeWebApplicationException;
import org.eclipse.osee.orcs.ExportOptions;
import org.eclipse.osee.orcs.ImportOptions;
import org.eclipse.osee.orcs.OrcsApi;
import org.eclipse.osee.orcs.OrcsBranch;
import org.eclipse.osee.orcs.data.ArchiveOperation;
import org.eclipse.osee.orcs.data.BranchReadable;
import org.eclipse.osee.orcs.data.CreateBranchData;
import org.eclipse.osee.orcs.data.TransactionReadable;
import org.eclipse.osee.orcs.rest.internal.OrcsRestUtil;
import org.eclipse.osee.orcs.rest.model.Branch;
import org.eclipse.osee.orcs.rest.model.BranchCommitOptions;
import org.eclipse.osee.orcs.rest.model.BranchEndpoint;
import org.eclipse.osee.orcs.rest.model.BranchExportOptions;
import org.eclipse.osee.orcs.rest.model.BranchImportOptions;
import org.eclipse.osee.orcs.rest.model.BranchQueryData;
import org.eclipse.osee.orcs.rest.model.NewBranch;
import org.eclipse.osee.orcs.rest.model.NewTransaction;
import org.eclipse.osee.orcs.rest.model.Transaction;
import org.eclipse.osee.orcs.search.BranchQuery;
import org.eclipse.osee.orcs.search.QueryFactory;
import org.eclipse.osee.orcs.search.TransactionQuery;
import org.eclipse.osee.orcs.transaction.TransactionBuilder;
import org.eclipse.osee.orcs.transaction.TransactionFactory;
import org.eclipse.osee.orcs.utility.RestUtil;

public class BranchEndpointImpl
implements BranchEndpoint {
    private final OrcsApi orcsApi;
    private final IResourceManager resourceManager;
    private final ActivityLog activityLog;
    @Context
    private UriInfo uriInfo;
    @Context
    private HttpHeaders httpHeaders;

    public BranchEndpointImpl(OrcsApi orcsApi, IResourceManager resourceManager, ActivityLog activityLog) {
        this.orcsApi = orcsApi;
        this.resourceManager = resourceManager;
        this.activityLog = activityLog;
    }

    public HttpHeaders getHeaders() {
        return this.httpHeaders;
    }

    public void setHeaders(HttpHeaders httpHeaders) {
        this.httpHeaders = httpHeaders;
    }

    public void setUriInfo(UriInfo uriInfo) {
        this.uriInfo = uriInfo;
    }

    public UriInfo getUriInfo() {
        return this.uriInfo;
    }

    private QueryFactory newQuery() {
        return this.orcsApi.getQueryFactory();
    }

    private BranchQuery newBranchQuery() {
        return this.newQuery().branchQuery();
    }

    private TransactionQuery newTxQuery() {
        return this.newQuery().transactionQuery();
    }

    private OrcsBranch getBranchOps() {
        return this.orcsApi.getBranchOps();
    }

    private BranchReadable getBranchById(BranchId branch) {
        ResultSet results = ((BranchQuery)((BranchQuery)((BranchQuery)this.newBranchQuery().andId(branch)).includeArchived()).includeDeleted()).getResults();
        return (BranchReadable)results.getExactlyOne();
    }

    private TransactionReadable getTxByBranchAndId(BranchId branch, TransactionId txId) {
        return (TransactionReadable)((TransactionQuery)((TransactionQuery)this.newTxQuery().andBranch(new BranchId[]{branch})).andTxId(txId)).getResults().getExactlyOne();
    }

    private TransactionFactory newTxFactory() {
        return this.orcsApi.getTransactionFactory();
    }

    public List<Branch> getBranches() {
        ResultSet results = ((BranchQuery)((BranchQuery)this.newBranchQuery().includeArchived()).includeDeleted()).getResults();
        return OrcsRestUtil.asBranches((ResultSet<? extends BranchReadable>)results);
    }

    public List<Branch> getBranches(BranchQueryData options) {
        ResultSet<BranchReadable> results = this.searchBranches(options);
        return OrcsRestUtil.asBranches(results);
    }

    public List<Branch> getBranches(String branchUuids, String branchTypes, String branchStates, boolean deleted, boolean archived, String nameEquals, String namePattern, Long childOf, Long ancestorOf) {
        int n;
        int n2;
        String[] stringArray;
        BranchQueryData options = new BranchQueryData();
        options.setBranchIds(org.eclipse.osee.framework.jdk.core.util.Collections.fromString((String)branchUuids, (String)",", BranchId::valueOf));
        if (Strings.isValid((String)branchTypes)) {
            LinkedList<BranchType> branchTypeVals = new LinkedList<BranchType>();
            stringArray = branchTypes.split(",");
            n2 = stringArray.length;
            n = 0;
            while (n < n2) {
                String branchType = stringArray[n];
                branchTypeVals.add(BranchType.valueOf((String)branchType.toUpperCase()));
                ++n;
            }
            options.setBranchTypes(branchTypeVals);
        }
        if (Strings.isValid((String)branchStates)) {
            LinkedList<BranchState> branchStateVals = new LinkedList<BranchState>();
            stringArray = branchStates.split(",");
            n2 = stringArray.length;
            n = 0;
            while (n < n2) {
                String branchState = stringArray[n];
                branchStateVals.add(BranchState.valueOf((String)branchState.toUpperCase()));
                ++n;
            }
            options.setBranchStates(branchStateVals);
        }
        options.setIncludeDeleted(deleted);
        options.setIncludeArchived(archived);
        if (Strings.isValid((String)nameEquals)) {
            options.setNameEquals(nameEquals);
        }
        if (Strings.isValid((String)namePattern)) {
            options.setNamePattern(namePattern);
        }
        if (childOf != null) {
            options.setIsChildOf(childOf);
        }
        if (ancestorOf != null) {
            options.setIsAncestorOf(ancestorOf);
        }
        return this.getBranches(options);
    }

    public List<Branch> getBaselineBranches() {
        ResultSet results = ((BranchQuery)((BranchQuery)((BranchQuery)this.newBranchQuery().includeArchived(false)).includeDeleted(false)).andIsOfType(new BranchType[]{BranchType.BASELINE})).getResults();
        return OrcsRestUtil.asBranches((ResultSet<? extends BranchReadable>)results);
    }

    public List<Branch> getWorkingBranches() {
        ResultSet results = ((BranchQuery)((BranchQuery)((BranchQuery)this.newBranchQuery().includeArchived(false)).includeDeleted(false)).andIsOfType(new BranchType[]{BranchType.WORKING})).getResults();
        return OrcsRestUtil.asBranches((ResultSet<? extends BranchReadable>)results);
    }

    public Branch getBranch(BranchId branch) {
        return OrcsRestUtil.asBranch(this.getBranchById(branch));
    }

    public List<Transaction> getAllBranchTxs(BranchId branch) {
        return OrcsRestUtil.asTransactions((ResultSet<? extends TransactionReadable>)((TransactionQuery)this.newTxQuery().andBranch(new BranchId[]{branch})).getResults());
    }

    public Transaction getBranchTx(BranchId branchUuid, TransactionId txId) {
        return OrcsRestUtil.asTransaction(this.getTxByBranchAndId(branchUuid, txId));
    }

    public CompareResults compareBranches(BranchId branch, BranchId branch2) {
        TransactionToken sourceTx = (TransactionToken)((TransactionQuery)this.newTxQuery().andIsHead(branch)).getResults().getExactlyOne();
        TransactionToken destinationTx = (TransactionToken)((TransactionQuery)this.newTxQuery().andIsHead(branch2)).getResults().getExactlyOne();
        Callable op = this.getBranchOps().compareBranch(sourceTx, destinationTx);
        List changes = (List)OrcsRestUtil.executeCallable(op);
        CompareResults data = new CompareResults();
        data.setChanges(changes);
        try {
            this.activityLog.createEntry((ActivityType)Activity.BRANCH_OPERATION, new Object[]{ActivityLog.INITIAL_STATUS, String.format("Branch Operation Compare Branches {sourceTx: %s, destTx: %s}", sourceTx.toString(), destinationTx.toString())});
        }
        catch (OseeCoreException ex) {
            OseeLog.log(ActivityLog.class, (Level)OseeLevel.SEVERE_POPUP, (Throwable)ex);
        }
        return data;
    }

    public Response createBranch(NewBranch data) {
        return this.createBranch(new CreateBranchData(), data);
    }

    public Response createBranchWithId(BranchId branch, NewBranch data) {
        if (branch.isInvalid()) {
            throw new OseeWebApplicationException(Response.Status.BAD_REQUEST, "branchUuid [%d] uuid must be > 0", new Object[]{branch});
        }
        CreateBranchData createData = new CreateBranchData(branch);
        return this.createBranch(createData, data);
    }

    private Response createBranch(CreateBranchData createData, NewBranch data) {
        createData.setName(data.getBranchName());
        createData.setBranchType(data.getBranchType());
        createData.setCreationComment(data.getCreationComment());
        createData.setAuthor(data.getAuthor());
        createData.setAssociatedArtifact(data.getAssociatedArtifact());
        createData.setFromTransaction(data.getSourceTransaction());
        createData.setParentBranch(data.getParentBranch());
        createData.setMergeDestinationBranchId(data.getMergeDestinationBranchId());
        createData.setMergeAddressingQueryId(data.getMergeAddressingQueryId());
        createData.setTxCopyBranchType(data.isTxCopyBranchType());
        Callable op = this.getBranchOps().createBranch(createData);
        BranchReadable result = (BranchReadable)OrcsRestUtil.executeCallable(op);
        UriInfo uriInfo = this.getUriInfo();
        URI uri = this.getBranchLocation(uriInfo, result);
        try {
            this.activityLog.createEntry((ActivityType)Activity.BRANCH_OPERATION, new Object[]{ActivityLog.INITIAL_STATUS, String.format("Branch Operation Create Branch {branchUUID: %s, branchName: %s accountId: %s serverId: %s clientId: %s}", createData.getBranch(), data.getBranchName(), RestUtil.getAccountId((HttpHeaders)this.httpHeaders), RestUtil.getServerId((HttpHeaders)this.httpHeaders), RestUtil.getClientId((HttpHeaders)this.httpHeaders))});
        }
        catch (OseeCoreException ex) {
            OseeLog.log(ActivityLog.class, (Level)OseeLevel.SEVERE_POPUP, (Throwable)ex);
        }
        return Response.created((URI)uri).entity((Object)OrcsRestUtil.asBranch(result)).build();
    }

    private URI getBranchLocation(UriInfo uriInfo, BranchReadable branch) {
        URI location = null;
        String path = uriInfo.getPath();
        if (Strings.isValid((String)path)) {
            String value = path.replace("branches", "");
            if (Strings.isNumeric((String)(value = value.replaceAll("/", "")))) {
                try {
                    Long id = Long.parseLong(value);
                    if (branch.getGuid().equals(id)) {
                        location = uriInfo.getRequestUri();
                    }
                }
                catch (Exception exception) {}
            }
        }
        if (location == null) {
            location = uriInfo.getRequestUriBuilder().path("{branch-uuid}").build(new Object[]{branch.getGuid()});
        }
        return location;
    }

    public Response commitBranch(BranchId branch, BranchId destinationBranch, BranchCommitOptions options) {
        BranchReadable srcBranch = this.getBranchById(branch);
        BranchReadable destBranch = this.getBranchById(destinationBranch);
        Callable op = this.getBranchOps().commitBranch(options.getCommitter(), (BranchId)srcBranch, (BranchId)destBranch);
        TransactionToken tx = (TransactionToken)OrcsRestUtil.executeCallable(op);
        if (options.isArchive()) {
            Callable op2 = this.getBranchOps().archiveUnarchiveBranch((BranchId)srcBranch, ArchiveOperation.ARCHIVE);
            OrcsRestUtil.executeCallable(op2);
        }
        UriInfo uriInfo = this.getUriInfo();
        URI location = this.getTxLocation(uriInfo, tx);
        try {
            this.activityLog.createEntry((ActivityType)Activity.BRANCH_OPERATION, new Object[]{ActivityLog.INITIAL_STATUS, String.format("Branch Operation Commit Branch {branchId: %s srcBranch: %s destBranch: %s accountId: %s serverId: %s clientId: %s}", branch, srcBranch, destBranch, RestUtil.getAccountId((HttpHeaders)this.httpHeaders), RestUtil.getServerId((HttpHeaders)this.httpHeaders), RestUtil.getClientId((HttpHeaders)this.httpHeaders))});
        }
        catch (OseeCoreException ex) {
            OseeLog.log(ActivityLog.class, (Level)OseeLevel.SEVERE_POPUP, (Throwable)ex);
        }
        return Response.created((URI)location).entity((Object)OrcsRestUtil.asTransaction(this.orcsApi.getTransactionFactory().getTx((TransactionId)tx))).build();
    }

    private URI getTxLocation(UriInfo uriInfo, TransactionToken tx) {
        UriBuilder builder = uriInfo.getRequestUriBuilder();
        URI location = builder.path("..").path("..").path("txs").path("{tx-id}").build(new Object[]{tx});
        return location;
    }

    public Response archiveBranch(BranchId branchId) {
        BranchReadable branch = this.getBranchById(branchId);
        boolean modified = false;
        BranchArchivedState currentState = branch.getArchiveState();
        if (BranchArchivedState.UNARCHIVED == currentState) {
            Callable op = this.getBranchOps().archiveUnarchiveBranch((BranchId)branch, ArchiveOperation.ARCHIVE);
            OrcsRestUtil.executeCallable(op);
            modified = true;
            try {
                this.activityLog.createEntry((ActivityType)Activity.BRANCH_OPERATION, new Object[]{ActivityLog.INITIAL_STATUS, String.format("Branch Operation Archive Branch {branchId: %s accountId: %s serverId: %s clientId: %s}", branchId, RestUtil.getAccountId((HttpHeaders)this.httpHeaders), RestUtil.getServerId((HttpHeaders)this.httpHeaders), RestUtil.getClientId((HttpHeaders)this.httpHeaders))});
            }
            catch (OseeCoreException ex) {
                OseeLog.log(ActivityLog.class, (Level)OseeLevel.SEVERE_POPUP, (Throwable)ex);
            }
        }
        return OrcsRestUtil.asResponse(modified);
    }

    public Response writeTx(BranchId branch, NewTransaction data) {
        String comment = data.getComment();
        ArtifactId userArtifact = null;
        TransactionFactory txFactory = this.newTxFactory();
        TransactionBuilder txBuilder = txFactory.createTransaction(branch, userArtifact, comment);
        TransactionReadable tx = txBuilder.commit();
        if (tx.isValid()) {
            URI location = this.uriInfo.getRequestUriBuilder().path("{tx-id}").build(new Object[]{tx});
            return Response.created((URI)location).entity((Object)OrcsRestUtil.asTransaction(tx)).build();
        }
        throw new OseeArgumentException("No Data Modified", new Object[0]);
    }

    public Response validateExchange(String path) {
        String exchangePath = this.asExchangeLocator(path);
        IResourceLocator locator = this.resourceManager.getResourceLocator(exchangePath);
        Callable op = this.getBranchOps().checkBranchExchangeIntegrity(locator.getLocation());
        URI verifyUri = (URI)OrcsRestUtil.executeCallable(op);
        UriInfo uriInfo = this.getUriInfo();
        URI location = this.getExchangeResourceURI(uriInfo, verifyUri);
        return Response.created((URI)location).build();
    }

    public Response deleteBranchExchange(String path) {
        boolean modified = false;
        String exchangePath = this.asExchangeLocator(path);
        IResourceLocator locator = this.resourceManager.getResourceLocator(exchangePath);
        if (locator != null) {
            int deleteResult = this.resourceManager.delete(locator);
            switch (deleteResult) {
                case 1: {
                    try {
                        this.activityLog.createEntry((ActivityType)Activity.BRANCH_OPERATION, new Object[]{ActivityLog.INITIAL_STATUS, String.format("Branch Operation Delete Branch Exachange Resource {resource: %s, locator %s}", path, locator.getLocation())});
                    }
                    catch (OseeCoreException ex) {
                        OseeLog.log(ActivityLog.class, (Level)OseeLevel.SEVERE_POPUP, (Throwable)ex);
                    }
                    modified = true;
                    break;
                }
                case 2: {
                    throw new OseeWebApplicationException(Response.Status.INTERNAL_SERVER_ERROR, "Error deleting exchange resource [%s] - locator [%s]", new Object[]{path, locator.getLocation()});
                }
            }
        }
        return OrcsRestUtil.asResponse(modified);
    }

    public Response exportBranches(BranchExportOptions options) {
        List<IOseeBranch> branches = this.getExportImportBranches(options.getBranchUuids());
        PropertyStore exportOptions = new PropertyStore();
        this.addOption(exportOptions, (Enum<?>)ExportOptions.MIN_TXS, options.getMinTx());
        this.addOption(exportOptions, (Enum<?>)ExportOptions.MAX_TXS, options.getMaxTx());
        this.addOption(exportOptions, (Enum<?>)ExportOptions.COMPRESS, options.isCompress());
        Callable op = this.getBranchOps().exportBranch(branches, exportOptions, options.getFileName());
        URI exportURI = (URI)OrcsRestUtil.executeCallable(op);
        UriInfo uriInfo = this.getUriInfo();
        URI location = this.getExchangeExportUri(uriInfo, exportURI, options.isCompress());
        try {
            this.activityLog.createEntry((ActivityType)Activity.BRANCH_OPERATION, new Object[]{ActivityLog.INITIAL_STATUS, String.format("Branch Operation Export Branches {branchUUID(s): %s accountId: %s serverId: %s, clientId: %s}", branches, RestUtil.getAccountId((HttpHeaders)this.httpHeaders), RestUtil.getServerId((HttpHeaders)this.httpHeaders), RestUtil.getClientId((HttpHeaders)this.httpHeaders))});
        }
        catch (OseeCoreException ex) {
            OseeLog.log(ActivityLog.class, (Level)OseeLevel.SEVERE_POPUP, (Throwable)ex);
        }
        return Response.created((URI)location).build();
    }

    public Response importBranches(BranchImportOptions options) {
        Response response;
        List<Object> branches = !options.getBranchUuids().isEmpty() ? this.getExportImportBranches(options.getBranchUuids()) : Collections.emptyList();
        String path = options.getExchangeFile();
        String exchangePath = this.asExchangeLocator(path);
        IResourceLocator locator = this.resourceManager.getResourceLocator(exchangePath);
        PropertyStore importOptions = new PropertyStore();
        this.addOption(importOptions, (Enum<?>)ImportOptions.MIN_TXS, options.getMinTx());
        this.addOption(importOptions, (Enum<?>)ImportOptions.MAX_TXS, options.getMaxTx());
        this.addOption(importOptions, (Enum<?>)ImportOptions.USE_IDS_FROM_IMPORT_FILE, options.isUseIdsFromImportFile());
        this.addOption(importOptions, (Enum<?>)ImportOptions.EXCLUDE_BASELINE_TXS, options.isExcludeBaselineTxs());
        this.addOption(importOptions, (Enum<?>)ImportOptions.ALL_AS_ROOT_BRANCHES, options.isAllAsRootBranches());
        this.addOption(importOptions, (Enum<?>)ImportOptions.CLEAN_BEFORE_IMPORT, options.isCleanBeforeImport());
        Callable op = this.getBranchOps().importBranch(locator.getLocation(), branches, importOptions);
        URI importURI = (URI)OrcsRestUtil.executeCallable(op);
        if (importURI != null) {
            UriInfo uriInfo = this.getUriInfo();
            URI location = this.getExchangeResourceURI(uriInfo, importURI);
            response = Response.created((URI)location).build();
        } else {
            response = Response.ok().build();
        }
        try {
            this.activityLog.createEntry((ActivityType)Activity.BRANCH_OPERATION, new Object[]{ActivityLog.INITIAL_STATUS, String.format("Branch Operation Import Branches {branchUUID(s): %s accountId: %s serverId: %s clientId: %s}", branches, RestUtil.getAccountId((HttpHeaders)this.httpHeaders), RestUtil.getServerId((HttpHeaders)this.httpHeaders), RestUtil.getClientId((HttpHeaders)this.httpHeaders))});
        }
        catch (OseeCoreException ex) {
            OseeLog.log(ActivityLog.class, (Level)OseeLevel.SEVERE_POPUP, (Throwable)ex);
        }
        return response;
    }

    private void addOption(PropertyStore data, Enum<?> enumKey, Object value) {
        if (value != null) {
            data.put(enumKey.name(), String.valueOf(value));
        }
    }

    private String asExchangeLocator(String path) {
        String toReturn = path;
        if (Strings.isValid((String)toReturn) && !toReturn.startsWith("exchange://")) {
            toReturn = "exchange://" + toReturn;
        }
        return toReturn;
    }

    private URI getExchangeResourceURI(UriInfo uriInfo, URI rawUri) {
        URI toReturn = rawUri;
        String path = rawUri.toASCIIString();
        int index = path.indexOf("exchange/");
        if (index > 0 && index < path.length()) {
            path = path.substring(index);
            toReturn = uriInfo.getBaseUriBuilder().path("resources").queryParam("path", new Object[]{path}).build(new Object[0]);
        }
        return toReturn;
    }

    private URI getExchangeExportUri(UriInfo uriInfo, URI rawUri, boolean isCompressed) {
        String path = rawUri.toASCIIString();
        path = path.replace("://", "/");
        path = isCompressed && !path.endsWith(".zip") ? String.valueOf(path) + ".zip" : String.valueOf(path) + "/export.manifest.xml";
        URI toReturn = uriInfo.getBaseUriBuilder().path("resources").queryParam("path", new Object[]{path}).build(new Object[0]);
        return toReturn;
    }

    private List<IOseeBranch> getExportImportBranches(Collection<BranchId> branchUids) {
        ResultSet resultsAsId = ((BranchQuery)((BranchQuery)((BranchQuery)this.newBranchQuery().andIds(branchUids)).includeArchived()).includeDeleted()).getResultsAsId();
        return Lists.newLinkedList((Iterable)resultsAsId);
    }

    public Response setBranchName(BranchId branchId, String newName) {
        BranchReadable branch = this.getBranchById(branchId);
        boolean modified = false;
        if (Compare.isDifferent((Object)branch.getName(), (Object)newName)) {
            Callable op = this.getBranchOps().changeBranchName((BranchId)branch, newName);
            OrcsRestUtil.executeCallable(op);
            modified = true;
            try {
                this.activityLog.createEntry((ActivityType)Activity.BRANCH_OPERATION, new Object[]{ActivityLog.INITIAL_STATUS, String.format("Branch Operation Set Branch Name {branchId: %s prevName: %s newName: %s accountId: %s serverId: %s clientId: %s}", branchId, branch.getName(), newName, RestUtil.getAccountId((HttpHeaders)this.httpHeaders), RestUtil.getServerId((HttpHeaders)this.httpHeaders), RestUtil.getClientId((HttpHeaders)this.httpHeaders))});
            }
            catch (OseeCoreException ex) {
                OseeLog.log(ActivityLog.class, (Level)OseeLevel.SEVERE_POPUP, (Throwable)ex);
            }
        }
        return OrcsRestUtil.asResponse(modified);
    }

    public Response setBranchType(BranchId branchId, BranchType newType) {
        BranchReadable branch = this.getBranchById(branchId);
        boolean modified = false;
        if (Compare.isDifferent((Object)branch.getBranchType(), (Object)newType)) {
            try {
                this.activityLog.createEntry((ActivityType)Activity.BRANCH_OPERATION, new Object[]{ActivityLog.INITIAL_STATUS, String.format("Branch Operation Set Branch Type {branchUUID: %s prevType: %s newType: %s accountId: %s serverId: %s clientId: %s}", branchId, branch.getBranchType(), newType, RestUtil.getAccountId((HttpHeaders)this.httpHeaders), RestUtil.getServerId((HttpHeaders)this.httpHeaders), RestUtil.getClientId((HttpHeaders)this.httpHeaders))});
            }
            catch (OseeCoreException ex) {
                OseeLog.log(ActivityLog.class, (Level)OseeLevel.SEVERE_POPUP, (Throwable)ex);
            }
            Callable op = this.getBranchOps().changeBranchType((BranchId)branch, newType);
            OrcsRestUtil.executeCallable(op);
            modified = true;
        }
        return OrcsRestUtil.asResponse(modified);
    }

    public Response setBranchState(BranchId branchId, BranchState newState) {
        BranchReadable branch = this.getBranchById(branchId);
        boolean modified = false;
        if (Compare.isDifferent((Object)branch.getBranchState(), (Object)newState)) {
            Callable op = this.getBranchOps().changeBranchState((BranchId)branch, newState);
            OrcsRestUtil.executeCallable(op);
            modified = true;
            try {
                this.activityLog.createEntry((ActivityType)Activity.BRANCH_OPERATION, new Object[]{ActivityLog.INITIAL_STATUS, String.format("Branch Operation Branch State Changed {branchId: %s prevState: %s newState: %s accountId: %s serverId: %s clientId: %s}", branchId, branch.getBranchType(), newState, RestUtil.getAccountId((HttpHeaders)this.httpHeaders), RestUtil.getServerId((HttpHeaders)this.httpHeaders), RestUtil.getClientId((HttpHeaders)this.httpHeaders))});
            }
            catch (OseeCoreException ex) {
                OseeLog.log(ActivityLog.class, (Level)OseeLevel.SEVERE_POPUP, (Throwable)ex);
            }
        }
        return OrcsRestUtil.asResponse(modified);
    }

    public Response associateBranchToArtifact(BranchId branchId, ArtifactId artifact) {
        BranchReadable branch = this.getBranchById(branchId);
        boolean modified = false;
        if (Compare.isDifferent((Object)branch.getAssociatedArtifact(), (Object)artifact)) {
            try {
                this.activityLog.createEntry((ActivityType)Activity.BRANCH_OPERATION, new Object[]{ActivityLog.INITIAL_STATUS, String.format("Branch Operation Associate Branch to Artifact {branchId: %s prevArt: %s newArt: %s accountId: %s serverId: %s clientId: %s}", branchId, branch.getAssociatedArtifact(), artifact, RestUtil.getAccountId((HttpHeaders)this.httpHeaders), RestUtil.getServerId((HttpHeaders)this.httpHeaders), RestUtil.getClientId((HttpHeaders)this.httpHeaders))});
            }
            catch (OseeCoreException ex) {
                OseeLog.log(ActivityLog.class, (Level)OseeLevel.SEVERE_POPUP, (Throwable)ex);
            }
            Callable op = this.getBranchOps().associateBranchToArtifact((BranchId)branch, artifact);
            OrcsRestUtil.executeCallable(op);
            modified = true;
        }
        return OrcsRestUtil.asResponse(modified);
    }

    public Response setTxComment(BranchId branch, TransactionId txId, String comment) {
        TransactionReadable tx = this.getTxByBranchAndId(branch, txId);
        boolean modified = false;
        if (Compare.isDifferent((Object)tx.getComment(), (Object)comment)) {
            try {
                this.activityLog.createEntry((ActivityType)Activity.BRANCH_OPERATION, new Object[]{ActivityLog.INITIAL_STATUS, String.format("Branch Operation Set Tx Comment {branchId: %s prevComment: %s newComment: %s accountId: %s serverId: %s clientId: %s}", branch, tx.getComment(), comment, RestUtil.getAccountId((HttpHeaders)this.httpHeaders), RestUtil.getServerId((HttpHeaders)this.httpHeaders), RestUtil.getClientId((HttpHeaders)this.httpHeaders))});
            }
            catch (OseeCoreException ex) {
                OseeLog.log(ActivityLog.class, (Level)OseeLevel.SEVERE_POPUP, (Throwable)ex);
            }
            TransactionFactory txFactory = this.newTxFactory();
            txFactory.setTransactionComment((TransactionId)tx, comment);
            modified = true;
        }
        return OrcsRestUtil.asResponse(modified);
    }

    public Response purgeBranch(BranchId branchId, boolean recurse) {
        boolean modified = false;
        BranchReadable branch = this.getBranchById(branchId);
        if (branch != null) {
            Callable op = this.getBranchOps().purgeBranch((BranchId)branch, recurse);
            OrcsRestUtil.executeCallable(op);
            modified = true;
        }
        try {
            this.activityLog.createEntry((ActivityType)Activity.BRANCH_OPERATION, new Object[]{ActivityLog.INITIAL_STATUS, String.format("Branch Operation Purge Branch {branchId: %s, accountId: %s serverId: %s clientId: %s}", branchId, RestUtil.getAccountId((HttpHeaders)this.httpHeaders), RestUtil.getServerId((HttpHeaders)this.httpHeaders), RestUtil.getClientId((HttpHeaders)this.httpHeaders))});
        }
        catch (OseeCoreException ex) {
            OseeLog.log(ActivityLog.class, (Level)OseeLevel.SEVERE_POPUP, (Throwable)ex);
        }
        return OrcsRestUtil.asResponse(modified);
    }

    public Response unarchiveBranch(BranchId branchId) {
        BranchReadable branch = this.getBranchById(branchId);
        BranchArchivedState state = branch.getArchiveState();
        boolean modified = false;
        if (BranchArchivedState.ARCHIVED == state) {
            Callable op = this.getBranchOps().archiveUnarchiveBranch((BranchId)branch, ArchiveOperation.UNARCHIVE);
            OrcsRestUtil.executeCallable(op);
            modified = true;
            try {
                this.activityLog.createEntry((ActivityType)Activity.BRANCH_OPERATION, new Object[]{ActivityLog.INITIAL_STATUS, String.format("Branch Operation Unarchive Branch {branchId: %s accountId: %s serverId: %s clientId: %s}", branchId, RestUtil.getAccountId((HttpHeaders)this.httpHeaders), RestUtil.getServerId((HttpHeaders)this.httpHeaders), RestUtil.getClientId((HttpHeaders)this.httpHeaders))});
            }
            catch (OseeCoreException ex) {
                OseeLog.log(ActivityLog.class, (Level)OseeLevel.SEVERE_POPUP, (Throwable)ex);
            }
        }
        return OrcsRestUtil.asResponse(modified);
    }

    public Response unCommitBranch(BranchId branch, BranchId destinationBranch) {
        throw new UnsupportedOperationException("Not yet implemented");
    }

    public Response unassociateBranch(BranchId branchId) {
        BranchReadable branch = this.getBranchById(branchId);
        boolean modified = false;
        if (branch.getAssociatedArtifact().isValid()) {
            Callable op = this.getBranchOps().unassociateBranch((BranchId)branch);
            OrcsRestUtil.executeCallable(op);
            modified = true;
            try {
                this.activityLog.createEntry((ActivityType)Activity.BRANCH_OPERATION, new Object[]{ActivityLog.INITIAL_STATUS, String.format("Branch Operation Unassociate Branch {branchId: %s, accountId: %s serverId: %s clientId: %s}", branchId, RestUtil.getAccountId((HttpHeaders)this.httpHeaders), RestUtil.getServerId((HttpHeaders)this.httpHeaders), RestUtil.getClientId((HttpHeaders)this.httpHeaders))});
            }
            catch (OseeCoreException ex) {
                OseeLog.log(ActivityLog.class, (Level)OseeLevel.SEVERE_POPUP, (Throwable)ex);
            }
        }
        return OrcsRestUtil.asResponse(modified);
    }

    public Response purgeTxs(BranchId branch, String txIds) {
        ResultSet results;
        boolean modified = false;
        List txsToDelete = org.eclipse.osee.framework.jdk.core.util.Collections.fromString((String)txIds, TransactionId::valueOf);
        if (!txsToDelete.isEmpty() && !(results = ((TransactionQuery)((TransactionQuery)this.newTxQuery().andBranch(new BranchId[]{branch})).andTxIds((Collection)txsToDelete)).getResults()).isEmpty()) {
            this.checkAllTxFoundAreOnBranch("Purge Transaction", branch, txsToDelete, (ResultSet<? extends TransactionId>)results);
            ArrayList list = Lists.newArrayList((Iterable)results);
            Callable op = this.newTxFactory().purgeTransaction((Collection)list);
            OrcsRestUtil.executeCallable(op);
            modified = true;
            try {
                this.activityLog.createEntry((ActivityType)Activity.BRANCH_OPERATION, new Object[]{ActivityLog.INITIAL_STATUS, String.format("Branch Operation Purge Txs {branchId: %s, txsToDelete: %s accountId: %s serverId: %s clientId: %s}", branch, txIds, RestUtil.getAccountId((HttpHeaders)this.httpHeaders), RestUtil.getServerId((HttpHeaders)this.httpHeaders), RestUtil.getClientId((HttpHeaders)this.httpHeaders))});
            }
            catch (OseeCoreException ex) {
                OseeLog.log(ActivityLog.class, (Level)OseeLevel.SEVERE_POPUP, (Throwable)ex);
            }
        }
        return OrcsRestUtil.asResponse(modified);
    }

    private void checkAllTxFoundAreOnBranch(String opName, BranchId branch, List<TransactionId> txIds, ResultSet<? extends TransactionId> result) {
        List difference;
        if (txIds.size() != result.size() && !(difference = org.eclipse.osee.framework.jdk.core.util.Collections.setComplement(txIds, (Collection)result.getList())).isEmpty()) {
            throw new OseeWebApplicationException(Response.Status.BAD_REQUEST, "%s Error - The following transactions from %s were not found on branch [%s] - txs %s - Please remove them from the request and try again.", new Object[]{opName, txIds, branch, difference});
        }
    }

    private ResultSet<BranchReadable> searchBranches(BranchQueryData options) {
        Long childOf;
        Long ancestorOf;
        String namePattern;
        String nameEquals;
        List branchTypes;
        List branchStates;
        BranchQuery query = this.orcsApi.getQueryFactory().branchQuery();
        List branchIds = options.getBranchIds();
        if (Conditions.hasValues((Collection)branchIds)) {
            query.andIds((Collection)branchIds);
        }
        if (Conditions.hasValues((Collection)(branchStates = options.getBranchStates()))) {
            query.andStateIs(branchStates.toArray(new BranchState[branchStates.size()]));
        }
        if (Conditions.hasValues((Collection)(branchTypes = options.getBranchTypes()))) {
            query.andIsOfType(branchTypes.toArray(new BranchType[branchTypes.size()]));
        }
        if (options.isIncludeArchived()) {
            query.includeArchived();
        }
        if (options.isIncludeDeleted()) {
            query.includeDeleted();
        }
        if (Strings.isValid((String)(nameEquals = options.getNameEquals()))) {
            query.andNameEquals(nameEquals);
        }
        if (Strings.isValid((String)(namePattern = options.getNamePattern()))) {
            query.andNamePattern(namePattern);
        }
        if ((ancestorOf = options.getIsAncestorOf()) > 0L) {
            BranchId ancestorOfToken = BranchId.valueOf((long)ancestorOf);
            query.andIsAncestorOf(ancestorOfToken);
        }
        if ((childOf = options.getIsChildOf()) > 0L) {
            BranchId childOfToken = BranchId.valueOf((long)ancestorOf);
            query.andIsAncestorOf(childOfToken);
        }
        return query.getResults();
    }

    public Response logBranchActivity(String comment) {
        try {
            comment = String.valueOf(comment) + String.format(" accountId: %s serverId: %s clientId: %s", RestUtil.getAccountId((HttpHeaders)this.httpHeaders), RestUtil.getServerId((HttpHeaders)this.httpHeaders), RestUtil.getClientId((HttpHeaders)this.httpHeaders));
            this.activityLog.createEntry((ActivityType)Activity.BRANCH_OPERATION, new Object[]{ActivityLog.INITIAL_STATUS, comment});
        }
        catch (OseeCoreException ex) {
            OseeLog.log(ActivityLog.class, (Level)OseeLevel.SEVERE_POPUP, (Throwable)ex);
        }
        return Response.ok().build();
    }
}

