/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.orcs.rest.internal;

import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Request;
import javax.ws.rs.core.UriInfo;
import org.eclipse.osee.framework.core.data.BranchId;
import org.eclipse.osee.framework.core.data.TransactionId;
import org.eclipse.osee.framework.jdk.core.type.OseeCoreException;
import org.eclipse.osee.orcs.data.ArtifactReadable;
import org.eclipse.osee.orcs.rest.internal.AttributeResource;
import org.eclipse.osee.orcs.rest.internal.AttributeTypeResource;
import org.eclipse.osee.orcs.rest.internal.HtmlWriter;
import org.eclipse.osee.orcs.rest.internal.OrcsApplication;
import org.eclipse.osee.orcs.search.QueryBuilder;
import org.eclipse.osee.orcs.search.QueryFactory;

@Path(value="attribute")
public class AttributesResource {
    @Context
    private final UriInfo uriInfo;
    @Context
    private final Request request;
    private final BranchId branchId;
    private final Long artifactUuid;

    public AttributesResource(UriInfo uriInfo, Request request, BranchId branchId, Long artifactUuid) {
        this.uriInfo = uriInfo;
        this.request = request;
        this.branchId = branchId;
        this.artifactUuid = artifactUuid;
    }

    @Path(value="{attributeId}")
    public AttributeResource getAttribute(@PathParam(value="attributeId") int attributeId) {
        return new AttributeResource(this.uriInfo, this.request, this.branchId, this.artifactUuid, attributeId);
    }

    @Path(value="{attributeId}/version/{transactionId}/text")
    public AttributeResource getAttributeWithGammaAsText(@PathParam(value="attributeId") int attributeId, @PathParam(value="transactionId") TransactionId transactionId) {
        AttributeResource toReturn = new AttributeResource(this.uriInfo, this.request, this.branchId, this.artifactUuid, attributeId, transactionId);
        toReturn.setTextOut(true);
        return toReturn;
    }

    @Path(value="{attributeId}/version/{transactionId}")
    public AttributeResource getAttributeWithGamma(@PathParam(value="attributeId") int attributeId, @PathParam(value="transactionId") TransactionId transactionId) {
        return new AttributeResource(this.uriInfo, this.request, this.branchId, this.artifactUuid, attributeId, transactionId);
    }

    @Path(value="type")
    @Produces(value={"text/html"})
    public AttributeTypeResource getAttributeTypes() {
        return new AttributeTypeResource(this.uriInfo, this.request, this.branchId, this.artifactUuid);
    }

    @Path(value="type/{attributeTypeId}")
    @Produces(value={"text/html"})
    public AttributeTypeResource getAttributeTypeValues(@PathParam(value="attributeTypeId") Long attributeTypeId) {
        return new AttributeTypeResource(this.uriInfo, this.request, this.branchId, this.artifactUuid, attributeTypeId);
    }

    @Path(value="type/{attributeTypeId}/version/{transactionId}")
    @Produces(value={"text/html"})
    public AttributeTypeResource getAttributeTypeValuesForTransaction(@PathParam(value="attributeTypeId") Long attributeTypeId, @PathParam(value="transactionId") TransactionId transactionId) {
        return new AttributeTypeResource(this.uriInfo, this.request, this.branchId, this.artifactUuid, attributeTypeId, transactionId);
    }

    @GET
    @Produces(value={"text/html"})
    public String getAllAttributes() throws OseeCoreException {
        QueryFactory factory = OrcsApplication.getOrcsApi().getQueryFactory();
        ArtifactReadable artifact = (ArtifactReadable)((QueryBuilder)factory.fromBranch(this.branchId).andUuid(this.artifactUuid.longValue())).getResults().getExactlyOne();
        HtmlWriter writer = new HtmlWriter(this.uriInfo);
        return writer.toHtml((Iterable<? extends Object>)artifact.getAttributes());
    }
}

