/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.orcs.rest.internal;

import java.net.URLEncoder;
import java.util.ArrayList;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Request;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;
import org.eclipse.osee.framework.core.data.AttributeTypeId;
import org.eclipse.osee.framework.core.data.AttributeTypeToken;
import org.eclipse.osee.framework.core.data.BranchId;
import org.eclipse.osee.framework.core.data.TransactionId;
import org.eclipse.osee.framework.core.enums.CoreAttributeTypes;
import org.eclipse.osee.framework.jdk.core.type.ResultSet;
import org.eclipse.osee.framework.jdk.core.util.AHTML;
import org.eclipse.osee.framework.jdk.core.util.Collections;
import org.eclipse.osee.orcs.data.ArtifactReadable;
import org.eclipse.osee.orcs.data.AttributeReadable;
import org.eclipse.osee.orcs.rest.internal.OrcsApplication;
import org.eclipse.osee.orcs.search.QueryBuilder;
import org.eclipse.osee.orcs.search.QueryFactory;

@Path(value="type")
public class AttributeTypeResource {
    @Context
    private final UriInfo uriInfo;
    @Context
    private final Request request;
    private final BranchId branchId;
    private final Long artifactUuid;
    private final Long attributeTypeId;
    private final TransactionId transactionId;

    public AttributeTypeResource(UriInfo uriInfo, Request request, BranchId branchId, Long artifactUuid) {
        this(uriInfo, request, branchId, artifactUuid, -1L, TransactionId.SENTINEL);
    }

    public AttributeTypeResource(UriInfo uriInfo, Request request, BranchId branchId, Long artifactUuid, Long attributeTypeId) {
        this(uriInfo, request, branchId, artifactUuid, attributeTypeId, TransactionId.SENTINEL);
    }

    public AttributeTypeResource(UriInfo uriInfo, Request request, BranchId branchId, Long artifactUuid, Long attributeTypeId, TransactionId transactionId) {
        this.uriInfo = uriInfo;
        this.request = request;
        this.branchId = branchId;
        this.artifactUuid = artifactUuid;
        this.attributeTypeId = attributeTypeId;
        this.transactionId = transactionId;
    }

    @GET
    @Produces(value={"text/html"})
    public Response getResponse() {
        Response.ResponseBuilder builder;
        block13: {
            builder = Response.noContent();
            try {
                AttributeTypeId attributeType;
                QueryFactory factory = OrcsApplication.getOrcsApi().getQueryFactory();
                QueryBuilder queryBuilder = (QueryBuilder)factory.fromBranch(this.branchId).andUuid(this.artifactUuid.longValue());
                if (this.transactionId.getId() > 0L) {
                    queryBuilder.fromTransaction(this.transactionId);
                }
                ArtifactReadable exactlyOne = (ArtifactReadable)queryBuilder.getResults().getExactlyOne();
                if (this.attributeTypeId <= 0L) {
                    StringBuilder sb = new StringBuilder();
                    sb.append(AHTML.beginMultiColumnTable((int)95));
                    sb.append(AHTML.addRowMultiColumnTable((String[])new String[]{AHTML.bold((String)"Valid Types")}));
                    sb.append(AHTML.addRowMultiColumnTable((String[])new String[]{""}));
                    for (AttributeTypeToken attrType : exactlyOne.getValidAttributeTypes()) {
                        sb.append(AHTML.addRowMultiColumnTable((String[])new String[]{AHTML.bold((String)"Name:"), attrType.getName()}));
                        sb.append(AHTML.addRowMultiColumnTable((String[])new String[]{AHTML.bold((String)"AttributeTypeId:"), AHTML.getHyperlink((String)String.format("/orcs/branch/%d/artifact/%d/attribute/type/%d", this.branchId, this.artifactUuid, attrType.getId()), (String)attrType.getIdString())}));
                        sb.append(AHTML.addRowMultiColumnTable((String[])new String[]{""}));
                    }
                    sb.append(AHTML.endMultiColumnTable());
                    return Response.ok((Object)AHTML.simplePage((String)sb.toString())).build();
                }
                ArrayList<AttributeReadable> attrs = new ArrayList<AttributeReadable>();
                if (this.attributeTypeId > 0L) {
                    attributeType = (AttributeTypeId)OrcsApplication.getOrcsApi().getOrcsTypes().getAttributeTypes().get(Long.valueOf(this.attributeTypeId));
                    for (AttributeReadable attr : exactlyOne.getAttributes(attributeType)) {
                        attrs.add(attr);
                    }
                } else {
                    attrs.addAll(exactlyOne.getAttributes().getList());
                }
                if (attrs.size() == 1) {
                    builder = Response.ok();
                    AttributeReadable attribute = (AttributeReadable)attrs.iterator().next();
                    String mediaType = OrcsApplication.getOrcsApi().getOrcsTypes().getAttributeTypes().getMediaType((AttributeTypeId)attribute.getAttributeType());
                    String fileExtension = OrcsApplication.getOrcsApi().getOrcsTypes().getAttributeTypes().getFileTypeExtension((AttributeTypeId)attribute.getAttributeType());
                    if (mediaType.isEmpty() || mediaType.startsWith("text")) {
                        builder.entity((Object)attribute.getDisplayableString());
                    } else {
                        ResultSet results = exactlyOne.getAttributes((AttributeTypeId)CoreAttributeTypes.Extension);
                        AttributeReadable extension = (AttributeReadable)results.getOneOrNull();
                        if (extension != null) {
                            fileExtension = extension.getDisplayableString();
                        }
                        Object content = attribute.getValue();
                        builder.entity(content);
                        builder.header("Content-type", (Object)mediaType);
                        String filename = URLEncoder.encode(String.valueOf(exactlyOne.getName()) + "." + fileExtension, "UTF-8");
                        builder.header("Content-Disposition", (Object)("attachment; filename=" + filename));
                    }
                    break block13;
                }
                if (attrs.size() > 1) {
                    String values = Collections.toString((String)"</br>", attrs);
                    return Response.ok((Object)AHTML.simplePage((String)values)).build();
                }
                attributeType = (AttributeTypeToken)OrcsApplication.getOrcsApi().getOrcsTypes().getAttributeTypes().get(Long.valueOf(this.attributeTypeId));
                return Response.ok((Object)AHTML.simplePage((String)String.format("No attributes of type [%s][%d] found.", attributeType.getName(), attributeType.getId()))).build();
            }
            catch (Exception ex) {
                throw new WebApplicationException((Throwable)ex);
            }
        }
        return builder.build();
    }
}

