/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.orcs.rest.internal;

import com.google.common.base.Optional;
import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import com.google.common.net.MediaType;
import java.net.URLEncoder;
import javax.ws.rs.GET;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Request;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;
import org.eclipse.osee.framework.core.data.AttributeTypeId;
import org.eclipse.osee.framework.core.data.BranchId;
import org.eclipse.osee.framework.core.data.TransactionId;
import org.eclipse.osee.framework.core.enums.CoreAttributeTypes;
import org.eclipse.osee.framework.jdk.core.type.ResultSet;
import org.eclipse.osee.orcs.data.ArtifactReadable;
import org.eclipse.osee.orcs.data.AttributeReadable;
import org.eclipse.osee.orcs.rest.internal.OrcsApplication;
import org.eclipse.osee.orcs.search.QueryBuilder;
import org.eclipse.osee.orcs.search.QueryFactory;

public class AttributeResource {
    @Context
    private final UriInfo uriInfo;
    @Context
    private final Request request;
    private final BranchId branchId;
    private final Long artifactUuid;
    private final int attrId;
    private final TransactionId transactionId;
    private boolean textOut = false;

    public AttributeResource(UriInfo uriInfo, Request request, BranchId branchId, Long artifactUuid, int attributeId) {
        this(uriInfo, request, branchId, artifactUuid, attributeId, TransactionId.SENTINEL);
    }

    public AttributeResource(UriInfo uriInfo, Request request, BranchId branchId, Long artifactUuid, int attributeId, TransactionId transactionId) {
        this.uriInfo = uriInfo;
        this.request = request;
        this.branchId = branchId;
        this.artifactUuid = artifactUuid;
        this.attrId = attributeId;
        this.transactionId = transactionId;
    }

    public void setTextOut(boolean value) {
        this.textOut = value;
    }

    @GET
    public Response getResponse() {
        Response.ResponseBuilder builder = Response.noContent();
        try {
            ArtifactReadable exactlyOne;
            Optional item;
            QueryFactory factory = OrcsApplication.getOrcsApi().getQueryFactory();
            QueryBuilder queryBuilder = (QueryBuilder)factory.fromBranch(this.branchId).andUuid(this.artifactUuid.longValue());
            if (this.transactionId.isValid()) {
                queryBuilder.fromTransaction(this.transactionId);
            }
            if ((item = Iterables.tryFind((Iterable)(exactlyOne = (ArtifactReadable)queryBuilder.getResults().getExactlyOne()).getAttributes(), (Predicate)new Predicate<AttributeReadable<Object>>(){

                public boolean apply(AttributeReadable<Object> attribute) {
                    return attribute.getLocalId() == AttributeResource.this.attrId;
                }
            })).isPresent()) {
                Object value = item.get();
                if (value instanceof AttributeReadable) {
                    builder = Response.ok();
                    AttributeReadable attribute = (AttributeReadable)value;
                    String mediaType = OrcsApplication.getOrcsApi().getOrcsTypes().getAttributeTypes().getMediaType((AttributeTypeId)attribute.getAttributeType());
                    String fileExtension = OrcsApplication.getOrcsApi().getOrcsTypes().getAttributeTypes().getFileTypeExtension((AttributeTypeId)attribute.getAttributeType());
                    if (mediaType.isEmpty() || mediaType.startsWith("text") || this.textOut) {
                        builder.entity((Object)attribute.getDisplayableString());
                        builder.header("Content-type", (Object)MediaType.PLAIN_TEXT_UTF_8);
                    } else {
                        ResultSet results = exactlyOne.getAttributes((AttributeTypeId)CoreAttributeTypes.Extension);
                        AttributeReadable extension = (AttributeReadable)results.getOneOrNull();
                        if (extension != null) {
                            fileExtension = extension.getDisplayableString();
                        }
                        Object content = attribute.getValue();
                        builder.entity(content);
                        builder.header("Content-type", (Object)mediaType);
                        String filename = URLEncoder.encode(String.valueOf(exactlyOne.getName()) + "." + fileExtension, "UTF-8");
                        builder.header("Content-Disposition", (Object)("attachment; filename=" + filename));
                    }
                }
            } else {
                builder = Response.status((Response.Status)Response.Status.NOT_FOUND);
            }
        }
        catch (Exception ex) {
            throw new WebApplicationException((Throwable)ex);
        }
        return builder.build();
    }
}

