/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.orcs.rest.internal;

import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Request;
import javax.ws.rs.core.UriInfo;
import org.eclipse.osee.framework.core.data.BranchId;
import org.eclipse.osee.framework.jdk.core.type.OseeCoreException;
import org.eclipse.osee.framework.jdk.core.type.ResultSet;
import org.eclipse.osee.orcs.OrcsApi;
import org.eclipse.osee.orcs.data.ArtifactReadable;
import org.eclipse.osee.orcs.rest.internal.ArtifactResource;
import org.eclipse.osee.orcs.rest.internal.HtmlWriter;
import org.eclipse.osee.orcs.rest.internal.search.artifact.ArtifactSearch_V1;
import org.eclipse.osee.orcs.search.QueryBuilder;

public class ArtifactsResource {
    @Context
    private final UriInfo uriInfo;
    @Context
    private final Request request;
    private final BranchId branchId;
    private final OrcsApi orcsApi;

    public ArtifactsResource(UriInfo uriInfo, Request request, BranchId branchId, OrcsApi orcsApi) {
        this.uriInfo = uriInfo;
        this.request = request;
        this.branchId = branchId;
        this.orcsApi = orcsApi;
    }

    @Path(value="search/v1")
    public ArtifactSearch_V1 getSearch() {
        return new ArtifactSearch_V1(this.uriInfo, this.request, this.orcsApi);
    }

    @Path(value="{uuid}")
    public ArtifactResource getArtifact(@PathParam(value="uuid") Long artifactUuid) {
        return new ArtifactResource(this.uriInfo, this.request, this.branchId, artifactUuid);
    }

    @GET
    @Produces(value={"text/html"})
    public String getAsHtml() throws OseeCoreException {
        ArtifactReadable rootArtifact = (ArtifactReadable)((QueryBuilder)this.orcsApi.getQueryFactory().fromBranch(this.branchId).andIsHeirarchicalRootArtifact()).getResults().getExactlyOne();
        ResultSet arts = rootArtifact.getChildren();
        HtmlWriter writer = new HtmlWriter(this.uriInfo);
        return writer.toHtml((Iterable<? extends Object>)arts);
    }
}

