/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.orcs.rest.internal;

import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Request;
import javax.ws.rs.core.UriInfo;
import org.eclipse.osee.framework.core.data.BranchId;
import org.eclipse.osee.framework.jdk.core.type.OseeCoreException;
import org.eclipse.osee.framework.jdk.core.type.ResultSet;
import org.eclipse.osee.orcs.rest.internal.AttributesResource;
import org.eclipse.osee.orcs.rest.internal.HtmlWriter;
import org.eclipse.osee.orcs.rest.internal.OrcsApplication;
import org.eclipse.osee.orcs.search.QueryBuilder;
import org.eclipse.osee.orcs.search.QueryFactory;

public class ArtifactResource {
    @Context
    UriInfo uriInfo;
    @Context
    Request request;
    BranchId branchId;
    Long artifactUuid;

    public ArtifactResource(UriInfo uriInfo, Request request, BranchId branchId, Long artifactUuid) {
        this.uriInfo = uriInfo;
        this.request = request;
        this.branchId = branchId;
        this.artifactUuid = artifactUuid;
    }

    @Path(value="attribute")
    public AttributesResource getAttributes() {
        return new AttributesResource(this.uriInfo, this.request, this.branchId, this.artifactUuid);
    }

    @GET
    @Produces(value={"text/html"})
    public String getAsHtml() throws OseeCoreException {
        QueryFactory factory = OrcsApplication.getOrcsApi().getQueryFactory();
        ResultSet arts = ((QueryBuilder)factory.fromBranch(this.branchId).andUuid(this.artifactUuid.longValue())).getResults();
        HtmlWriter writer = new HtmlWriter(this.uriInfo);
        return writer.toHtml((Iterable<? extends Object>)arts);
    }
}

