/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.orcs.rest.internal;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.ws.rs.core.Response;
import org.eclipse.osee.framework.core.data.ApplicabilityId;
import org.eclipse.osee.framework.core.data.ApplicabilityToken;
import org.eclipse.osee.framework.core.data.ArtifactId;
import org.eclipse.osee.framework.core.data.ArtifactToken;
import org.eclipse.osee.framework.core.data.ArtifactTypeId;
import org.eclipse.osee.framework.core.data.AttributeTypeId;
import org.eclipse.osee.framework.core.data.BranchId;
import org.eclipse.osee.framework.core.data.BranchViewData;
import org.eclipse.osee.framework.core.data.FeatureDefinitionData;
import org.eclipse.osee.framework.core.data.TransactionId;
import org.eclipse.osee.framework.core.data.TransactionToken;
import org.eclipse.osee.framework.core.data.UserId;
import org.eclipse.osee.framework.core.enums.BranchType;
import org.eclipse.osee.framework.core.enums.CoreArtifactTokens;
import org.eclipse.osee.framework.core.enums.CoreArtifactTypes;
import org.eclipse.osee.framework.core.enums.CoreAttributeTypes;
import org.eclipse.osee.framework.core.enums.CoreBranches;
import org.eclipse.osee.framework.core.enums.CoreTupleTypes;
import org.eclipse.osee.framework.core.enums.SystemUser;
import org.eclipse.osee.framework.jdk.core.type.Pair;
import org.eclipse.osee.orcs.OrcsApi;
import org.eclipse.osee.orcs.data.BranchReadable;
import org.eclipse.osee.orcs.rest.model.ApplicabilityEndpoint;
import org.eclipse.osee.orcs.search.BranchQuery;
import org.eclipse.osee.orcs.search.QueryBuilder;
import org.eclipse.osee.orcs.search.TupleQuery;
import org.eclipse.osee.orcs.transaction.TransactionBuilder;

public class ApplicabilityEndpointImpl
implements ApplicabilityEndpoint {
    private final OrcsApi orcsApi;
    private final BranchId branch;
    private final TupleQuery tupleQuery;
    private final UserId account;

    public ApplicabilityEndpointImpl(OrcsApi orcsApi, BranchId branch, UserId account) {
        this.orcsApi = orcsApi;
        this.branch = branch;
        this.tupleQuery = orcsApi.getQueryFactory().tupleQuery();
        this.account = account;
    }

    public void createDemoApplicability() {
        TransactionBuilder tx = this.orcsApi.getTransactionFactory().createTransaction(this.branch, (ArtifactId)SystemUser.OseeSystem, "Create Demo Applicability");
        ArtifactToken config1 = tx.createArtifact(CoreArtifactTypes.BranchView, "Config1");
        ArtifactToken config2 = tx.createArtifact(CoreArtifactTypes.BranchView, "Config2");
        ArtifactToken folder = tx.createArtifact(CoreArtifactTypes.Folder, "Product Line");
        ArtifactToken featureDefinition = tx.createArtifact(CoreArtifactTypes.FeatureDefinition, "Feature Definition_SAW_Bld_1");
        this.orcsApi.getKeyValueOps().putByKey(ApplicabilityToken.BASE.getId(), ApplicabilityToken.BASE.getName());
        tx.addChildren((ArtifactId)CoreArtifactTokens.DefaultHierarchyRoot, new ArtifactId[]{folder});
        tx.addChildren((ArtifactId)folder, new ArtifactId[]{config1, config2, featureDefinition});
        tx.addTuple2(CoreTupleTypes.ViewApplicability, (Object)config1, (Object)"Base");
        tx.addTuple2(CoreTupleTypes.ViewApplicability, (Object)config2, (Object)"Base");
        tx.addTuple2(CoreTupleTypes.ViewApplicability, (Object)config1, (Object)"Config = Config1");
        tx.addTuple2(CoreTupleTypes.ViewApplicability, (Object)config2, (Object)"Config = Config2");
        tx.addTuple2(CoreTupleTypes.ViewApplicability, (Object)config1, (Object)"A = Included");
        tx.addTuple2(CoreTupleTypes.ViewApplicability, (Object)config2, (Object)"A = Excluded");
        tx.addTuple2(CoreTupleTypes.ViewApplicability, (Object)config1, (Object)"B = Choice1");
        tx.addTuple2(CoreTupleTypes.ViewApplicability, (Object)config2, (Object)"B = Choice2");
        tx.addTuple2(CoreTupleTypes.ViewApplicability, (Object)config2, (Object)"B = Choice3");
        tx.addTuple2(CoreTupleTypes.ViewApplicability, (Object)config1, (Object)"C = Included");
        tx.addTuple2(CoreTupleTypes.ViewApplicability, (Object)config2, (Object)"C = Excluded");
        String featureDefJson = "[{\"name\": \"A\",\"type\": \"single\",\"values\": [\"Included\", \"Excluded\"],\"defaultValue\": \"Included\",\"description\": \"Test A\"}, {\"name\": \"B\",\"type\": \"multiple\",\"values\": [\"Choice1\", \"Choice2\", \"Choice3\"],\"defaultValue\": \"\",\"description\": \"Test B\"},{\"name\": \"C\",\"type\": \"single\",\"values\": [\"Included\", \"Excluded\"],\"defaultValue\": \"Included\",\"description\": \"Test C\"}]";
        tx.createAttribute((ArtifactId)featureDefinition, (AttributeTypeId)CoreAttributeTypes.GeneralStringData, (Object)featureDefJson);
        tx.commit();
        this.setView((ArtifactId)config1);
        this.setView((ArtifactId)config2);
    }

    public List<ApplicabilityToken> getApplicabilityTokens() {
        LinkedList<ApplicabilityToken> toReturn = new LinkedList<ApplicabilityToken>();
        this.tupleQuery.getTuple2UniqueE2Pair(CoreTupleTypes.ViewApplicability, this.branch, (id, name) -> {
            boolean bl = toReturn.add(new ApplicabilityToken(id, name));
        });
        return toReturn;
    }

    public ApplicabilityToken getApplicabilityToken(ArtifactId artId) {
        return this.orcsApi.getQueryFactory().applicabilityQuery().getApplicabilityToken(artId, this.branch);
    }

    public List<Pair<ArtifactId, ApplicabilityToken>> getApplicabilityTokensForArts(Collection<? extends ArtifactId> artIds) {
        ArrayList<Pair<ArtifactId, ApplicabilityToken>> artToApplicToken = new ArrayList<Pair<ArtifactId, ApplicabilityToken>>();
        for (ArtifactId artifactId : artIds) {
            artToApplicToken.add((Pair<ArtifactId, ApplicabilityToken>)new Pair((Object)artifactId, (Object)this.getApplicabilityToken(artifactId)));
        }
        return artToApplicToken;
    }

    public Collection<ApplicabilityToken> getApplicabilityTokenMap() {
        return this.orcsApi.getQueryFactory().applicabilityQuery().getApplicabilityTokens(this.branch).values();
    }

    public List<FeatureDefinitionData> getFeatureDefinitionData() {
        BranchId branchToUse = this.branch;
        BranchReadable br = (BranchReadable)((BranchQuery)this.orcsApi.getQueryFactory().branchQuery().andId(this.branch)).getResults().getOneOrNull();
        if (br.getBranchType().equals((Object)BranchType.MERGE)) {
            branchToUse = br.getParentBranch();
        }
        List featureDefinitionArts = ((QueryBuilder)this.orcsApi.getQueryFactory().fromBranch(branchToUse).andIsOfType(new ArtifactTypeId[]{CoreArtifactTypes.FeatureDefinition})).getResults().getList();
        return this.orcsApi.getQueryFactory().applicabilityQuery().getFeatureDefinitionData(featureDefinitionArts);
    }

    public Response setApplicability(ApplicabilityId applicId, List<? extends ArtifactId> artifacts) {
        TransactionBuilder tx = this.orcsApi.getTransactionFactory().createTransaction(this.branch, (ArtifactId)this.account, "Set Applicability Ids for Artifacts");
        for (ArtifactId artifactId : artifacts) {
            tx.setApplicability(artifactId, applicId);
        }
        tx.commit();
        return Response.ok().build();
    }

    public List<Pair<ArtifactId, ApplicabilityToken>> getApplicabilityTokens(Collection<? extends ArtifactId> artIds) {
        return this.orcsApi.getQueryFactory().applicabilityQuery().getApplicabilityTokens(artIds, this.branch);
    }

    public List<ApplicabilityId> getApplicabilitiesReferenced(ArtifactId artifact) {
        LinkedList<ApplicabilityId> appIds = new LinkedList<ApplicabilityId>();
        for (ApplicabilityId tuple2 : this.orcsApi.getQueryFactory().tupleQuery().getTuple2(CoreTupleTypes.ArtifactReferenceApplicabilityType, this.branch, (Object)artifact)) {
            appIds.add(tuple2);
        }
        return appIds;
    }

    public List<ApplicabilityToken> getApplicabilityReferenceTokens(ArtifactId artifact) {
        LinkedList<ApplicabilityToken> tokens = new LinkedList<ApplicabilityToken>();
        this.orcsApi.getQueryFactory().tupleQuery().getTuple2NamedId(CoreTupleTypes.ArtifactReferenceApplicabilityType, this.branch, (Object)artifact, (e2, value) -> {
            boolean bl = tokens.add(ApplicabilityToken.create((long)e2, (String)value));
        });
        return tokens;
    }

    public Response setApplicabilityReference(HashMap<ArtifactId, List<ApplicabilityId>> artToApplMap) {
        TransactionBuilder tx = this.orcsApi.getTransactionFactory().createTransaction(this.branch, (ArtifactId)this.account, "Set Reference Applicability Ids for Artifacts");
        for (Map.Entry<ArtifactId, List<ApplicabilityId>> entry : artToApplMap.entrySet()) {
            for (ApplicabilityId appId : entry.getValue()) {
                if (this.orcsApi.getQueryFactory().tupleQuery().doesTuple2Exist(CoreTupleTypes.ArtifactReferenceApplicabilityType, (Object)entry.getKey(), (Object)appId)) continue;
                tx.addTuple2(CoreTupleTypes.ArtifactReferenceApplicabilityType, (Object)entry.getKey(), (Object)appId);
            }
        }
        tx.commit();
        return Response.ok().build();
    }

    public List<ApplicabilityToken> getViewApplicabilityTokens(ArtifactId view) {
        return this.orcsApi.getQueryFactory().applicabilityQuery().getViewApplicabilityTokens(view, this.branch);
    }

    public List<BranchViewData> getViews() {
        return this.orcsApi.getQueryFactory().applicabilityQuery().getViews();
    }

    public void setView(ArtifactId branchView) {
        TransactionBuilder tx = this.orcsApi.getTransactionFactory().createTransaction((BranchId)CoreBranches.COMMON, (ArtifactId)SystemUser.OseeSystem, "Create Branch View");
        tx.addTuple2(CoreTupleTypes.BranchView, (Object)this.branch.getId(), (Object)branchView.getId());
        tx.commit();
    }

    public TransactionToken createNewApplicabilityForView(ArtifactId viewId, String applicability) {
        TransactionBuilder tx = this.orcsApi.getTransactionFactory().createTransaction(this.branch, (ArtifactId)SystemUser.OseeSystem, "Create new applicability");
        tx.addTuple2(CoreTupleTypes.ViewApplicability, (Object)viewId, (Object)applicability);
        return tx.commit();
    }

    public List<BranchId> getAffectedBranches(Long injectDateMs, Long removalDateMs, List<ApplicabilityId> applicabilityIds) {
        ArrayList<BranchId> toReturn = new ArrayList<BranchId>();
        Date injection = new Date(injectDateMs);
        Date removal = new Date(removalDateMs);
        List branchViews = this.orcsApi.getQueryFactory().applicabilityQuery().getViews();
        HashMap<Long, BranchReadable> childBaselineBranchIds = new HashMap<Long, BranchReadable>();
        for (BranchReadable childBranch : ((BranchQuery)this.orcsApi.getQueryFactory().branchQuery().andIsChildOf(this.branch)).getResults()) {
            if (!childBranch.getBranchType().equals((Object)BranchType.BASELINE)) continue;
            childBaselineBranchIds.put(childBranch.getId(), childBranch);
        }
        HashMap<Long, ApplicabilityId> applicabilityIdsMap = new HashMap<Long, ApplicabilityId>();
        for (ApplicabilityId applicId : applicabilityIds) {
            applicabilityIdsMap.put(applicId.getId(), applicId);
        }
        for (BranchViewData branchView : branchViews) {
            Date baseDate;
            BranchReadable baseBranch = (BranchReadable)childBaselineBranchIds.get(branchView.getBranch().getId());
            if (baseBranch == null || !(baseDate = this.orcsApi.getTransactionFactory().getTx(baseBranch.getBaseTransaction()).getDate()).after(injection) || removalDateMs != -1L && !baseDate.before(removal)) continue;
            block3: for (ArtifactId view : branchView.getBranchViews()) {
                List viewApplicabilityTokens = this.orcsApi.getQueryFactory().applicabilityQuery().getViewApplicabilityTokens(view, branchView.getBranch());
                for (ApplicabilityToken applicToken : viewApplicabilityTokens) {
                    if (!applicabilityIdsMap.containsKey(applicToken.getId())) continue;
                    toReturn.add(BranchId.create((long)branchView.getBranch().getId(), (ArtifactId)view));
                    continue block3;
                }
            }
        }
        return toReturn;
    }

    public List<BranchId> getAffectedBranches(TransactionId injectionTx, TransactionId removalTx, List<ApplicabilityId> applicabilityIds) {
        long timeInjectionMs = this.orcsApi.getTransactionFactory().getTx(injectionTx).getDate().getTime();
        long timeRemovalMs = removalTx.isInvalid() ? -1L : this.orcsApi.getTransactionFactory().getTx(removalTx).getDate().getTime();
        return this.getAffectedBranches(timeInjectionMs, timeRemovalMs, applicabilityIds);
    }
}

