/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.orcs.rest.admin;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.osee.framework.core.data.ArtifactTypeId;
import org.eclipse.osee.framework.core.data.AttributeTypeId;
import org.eclipse.osee.framework.core.data.AttributeTypeToken;
import org.eclipse.osee.framework.core.data.BranchId;
import org.eclipse.osee.framework.core.enums.CoreArtifactTypes;
import org.eclipse.osee.framework.core.enums.CoreAttributeTypes;
import org.eclipse.osee.framework.jdk.core.text.Rule;
import org.eclipse.osee.framework.jdk.core.text.change.ChangeSet;
import org.eclipse.osee.orcs.OrcsApi;
import org.eclipse.osee.orcs.data.ArtifactReadable;
import org.eclipse.osee.orcs.search.QueryBuilder;

public class UpdateLinksRule
extends Rule {
    private static final Pattern generalPattern = Pattern.compile("<a href=\"http://osee[^\"]+");
    private static final Pattern precisePattern = Pattern.compile(".+?guid=([^&]+)(?:&|&amp;)branchUuid=(\\d+)");
    private static final Pattern revPrecisePattern = Pattern.compile(".+?branch.uid=(\\d+)(?:&|&amp;)guid=(.+)");
    private final OrcsApi orcsApi;

    public UpdateLinksRule(OrcsApi orcsApi) {
        super("html");
        this.orcsApi = orcsApi;
    }

    private String generateLink(String branchIdString, String artifactGuid) {
        BranchId branchId = BranchId.valueOf((String)branchIdString);
        artifactGuid = artifactGuid.replaceAll("%2[Bb]", "+");
        artifactGuid = artifactGuid.replaceAll("%3[Dd]", "=");
        QueryBuilder query = (QueryBuilder)this.orcsApi.getQueryFactory().fromBranch(branchId).andGuid(artifactGuid);
        ArtifactReadable artifact = (ArtifactReadable)query.getResults().getExactlyOne();
        Long artifactId = artifact.getUuid();
        Long attributeId = this.getAttributeId(artifact);
        return String.format("<a href=\"http://osee.msc.az.boeing.com/orcs/branch/%s/artifact/%s/attribute/%s", branchId, artifactId, attributeId);
    }

    private Long getAttributeId(ArtifactReadable artifact) {
        AttributeTypeToken attributeType;
        if (artifact.isOfType(new ArtifactTypeId[]{CoreArtifactTypes.WholeWord})) {
            attributeType = CoreAttributeTypes.WholeWordContent;
        } else if (artifact.isOfType(new ArtifactTypeId[]{CoreArtifactTypes.NativeArtifact})) {
            attributeType = CoreAttributeTypes.NativeContent;
        } else {
            throw new RuntimeException("Unexpected Artifact type: " + artifact.getArtifactType());
        }
        return artifact.getSoleAttributeId((AttributeTypeId)attributeType);
    }

    private void applyTextSwap(ChangeSet set, Matcher matcher, String branchIdString, String artifactGuid) {
        this.ruleWasApplicable = true;
        String link = this.generateLink(branchIdString, artifactGuid);
        set.replace(matcher.start(), matcher.end(), link);
    }

    public ChangeSet computeChanges(CharSequence seq) {
        ChangeSet changeSet = new ChangeSet(seq);
        Matcher generalMatcher = generalPattern.matcher(seq);
        while (generalMatcher.find()) {
            Matcher preciseMatcher = precisePattern.matcher(generalMatcher.group());
            Matcher revPreciseMatcher = revPrecisePattern.matcher(generalMatcher.group());
            if (preciseMatcher.find()) {
                this.applyTextSwap(changeSet, generalMatcher, preciseMatcher.group(2), preciseMatcher.group(1));
                continue;
            }
            if (revPreciseMatcher.find()) {
                this.applyTextSwap(changeSet, generalMatcher, revPreciseMatcher.group(1), revPreciseMatcher.group(2));
                continue;
            }
            throw new RuntimeException("Unexpected Link Format: " + generalMatcher.group());
        }
        return changeSet;
    }
}

