/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.event.osgi.internal;

import java.util.Map;
import org.eclipse.osee.event.EventService;
import org.eclipse.osee.event.osgi.internal.EventOsgiUtil;
import org.eclipse.osee.logger.Log;
import org.osgi.service.event.EventAdmin;

public class EventServiceOverOsgi
implements EventService {
    private EventAdmin eventAdmin;
    private Log log;

    public void setEventAdmin(EventAdmin eventAdmin) {
        this.eventAdmin = eventAdmin;
    }

    public void setLogger(Log log) {
        this.log = log;
    }

    public Log getLogger() {
        return this.log;
    }

    public void start() {
    }

    public void stop() {
    }

    public void postEvent(String topic, Map<String, ?> data) {
        try {
            this.eventAdmin.postEvent(EventOsgiUtil.toOsgiEvent(topic, data));
        }
        catch (Throwable th) {
            this.handleError(th, "Error during postEvent for topic[%s] data[%s]", topic, data);
        }
    }

    public void sendEvent(String topic, Map<String, ?> data) {
        try {
            this.eventAdmin.sendEvent(EventOsgiUtil.toOsgiEvent(topic, data));
        }
        catch (Throwable th) {
            this.handleError(th, "Error during sendEvent for topic[%s] data[%s]", topic, data);
        }
    }

    private void handleError(Throwable th, String message, Object ... args) {
        Log log = this.getLogger();
        if (log != null) {
            log.error(th, message, args);
        }
    }
}

