/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.event.osgi.internal;

import java.util.Dictionary;
import java.util.Hashtable;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.eclipse.osee.event.EventHandler;
import org.eclipse.osee.event.osgi.internal.EventHandlerProxy;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceRegistration;

public class EventHandlerConsumer {
    private final Map<EventHandler, ServiceRegistration<?>> registered = new ConcurrentHashMap();
    private final Map<EventHandler, Dictionary<String, ?>> pending = new ConcurrentHashMap();
    private BundleContext context;
    private Thread thread;

    public void start(BundleContext context) {
        this.context = context;
        this.thread = new Thread("Register Pending Event Handlers"){

            @Override
            public void run() {
                for (Map.Entry entry : EventHandlerConsumer.this.pending.entrySet()) {
                    EventHandlerConsumer.this.registerHelper((EventHandler)entry.getKey(), (Dictionary)entry.getValue());
                }
                EventHandlerConsumer.this.pending.clear();
            }
        };
        this.thread.start();
    }

    public void stop() {
        if (this.thread != null && this.thread.isAlive()) {
            this.thread.interrupt();
        }
        this.context = null;
    }

    private boolean isReady() {
        return this.context != null;
    }

    public void registerHandler(EventHandler handler, Map<String, ?> properties) {
        Hashtable serviceProps = new Hashtable();
        serviceProps.putAll(properties);
        if (this.isReady()) {
            this.registerHelper(handler, serviceProps);
        } else {
            this.pending.put(handler, serviceProps);
        }
    }

    public void unregisterHandler(EventHandler handler, Map<String, ?> properties) {
        if (this.isReady()) {
            ServiceRegistration<?> registration = this.registered.remove(handler);
            if (registration != null) {
                registration.unregister();
            }
        } else {
            this.pending.remove(handler);
        }
    }

    private void registerHelper(EventHandler handler, Dictionary<String, ?> serviceProps) {
        try {
            EventHandlerProxy proxy = new EventHandlerProxy(handler);
            ServiceRegistration registration = this.context.registerService(org.osgi.service.event.EventHandler.class, (Object)proxy, serviceProps);
            this.registered.put(handler, registration);
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }
}

