/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.framework.jdk.core.validate;

import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.eclipse.osee.framework.jdk.core.util.Strings;
import org.eclipse.osee.framework.jdk.core.validate.ExpressionValidator;
import org.eclipse.osee.framework.jdk.core.validate.FieldValidator;
import org.eclipse.osee.framework.jdk.core.validate.IValidator;
import org.eclipse.osee.framework.jdk.core.validate.RequiredStringValidator;
import org.eclipse.osee.framework.jdk.core.validate.RequiredValidator;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class Validator {
    private final InputStream fileToRead;
    private final Map<String, List<IValidator>> validatorMap;

    public Validator(InputStream fileToRead) throws Exception {
        this.fileToRead = fileToRead;
        this.validatorMap = new HashMap<String, List<IValidator>>();
        this.parseFile();
    }

    private void storeValidator(String fieldName, IValidator validator) {
        List<Object> list = null;
        if (!this.validatorMap.containsKey(fieldName)) {
            list = new ArrayList();
            this.validatorMap.put(fieldName, list);
        } else {
            list = this.validatorMap.get(fieldName);
        }
        list.add(validator);
    }

    private void parseMessage(Element element, FieldValidator validator) {
        String message;
        Node node;
        NodeList messageList = element.getElementsByTagName(FieldValidatorEntries.message.name());
        if (messageList.getLength() == 1 && (node = messageList.item(0)) != null && Strings.isValid(message = node.getTextContent())) {
            validator.setMessage(message.trim());
        }
    }

    private void parseParams(Element element, FieldValidator validator) {
        NodeList paramList = element.getElementsByTagName(FieldValidatorEntries.param.name());
        int i = 0;
        while (i < paramList.getLength()) {
            String content;
            Element paramElement = (Element)paramList.item(i);
            String paramName = paramElement.getAttribute(ParamAttributes.name.name());
            if (Strings.isValid(paramName) && Strings.isValid(content = paramElement.getTextContent())) {
                validator.addParam(paramName.trim(), content.trim());
            }
            ++i;
        }
    }

    private void parseValidator(Element element, String fieldName, String validatorType) {
        FieldValidator validator = this.validatorFactory(fieldName, validatorType);
        if (validator != null) {
            this.parseMessage(element, validator);
            this.parseParams(element, validator);
            this.storeValidator(fieldName, validator);
        }
    }

    private void parseFile() throws Exception {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        DocumentBuilder builder = factory.newDocumentBuilder();
        Document document = builder.parse(this.fileToRead);
        NodeList fields = document.getElementsByTagName(EntryEnum.field.name());
        int i = 0;
        while (i < fields.getLength()) {
            Element fieldElement = (Element)fields.item(i);
            String fieldName = fieldElement.getAttribute(FieldAttributes.name.name());
            if (Strings.isValid(fieldName)) {
                NodeList validators = fieldElement.getElementsByTagName(FieldEntries.validator.name());
                int j = 0;
                while (j < validators.getLength()) {
                    Element validatorElement = (Element)validators.item(j);
                    String validatorType = validatorElement.getAttribute(FieldValidatorAttributes.type.name());
                    if (Strings.isValid(validatorType)) {
                        this.parseValidator(validatorElement, fieldName.trim(), validatorType.trim());
                    }
                    ++j;
                }
            }
            ++i;
        }
    }

    private FieldValidator validatorFactory(String name, String type) {
        FieldValidator toReturn = null;
        ValidationTypes validationType = ValidationTypes.valueOf(type);
        switch (validationType) {
            case requiredstring: {
                toReturn = new RequiredStringValidator(name);
                break;
            }
            case required: {
                toReturn = new RequiredValidator(name);
                break;
            }
            case expression: {
                toReturn = new ExpressionValidator(name);
            }
        }
        return toReturn;
    }

    public List<IValidator> getValidator(String fieldName) {
        ArrayList list = this.validatorMap.get(fieldName);
        return list != null ? list : new ArrayList();
    }

    private static enum EntryEnum {
        field;

    }

    private static enum FieldAttributes {
        name;

    }

    private static enum FieldEntries {
        validator;

    }

    private static enum FieldValidatorAttributes {
        type;

    }

    private static enum FieldValidatorEntries {
        message,
        param;

    }

    private static enum ParamAttributes {
        name;

    }

    private static enum ValidationTypes {
        requiredstring,
        required,
        expression;

    }
}

