/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.framework.jdk.core.validate;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.osee.framework.jdk.core.validate.IValidator;

public abstract class FieldValidator
implements IValidator {
    protected String fieldName;
    private String message;
    protected Map<String, Object> paramMap;

    FieldValidator(String fieldName) {
        this.fieldName = fieldName;
        this.message = "";
        this.paramMap = new HashMap<String, Object>();
    }

    @Override
    public String getFieldName() {
        return this.fieldName;
    }

    @Override
    public String getMessage() {
        for (String key : this.paramMap.keySet()) {
            this.message = this.message.replaceAll("\\$\\{" + key + "\\}", this.paramMap.get(key).toString());
        }
        return this.message;
    }

    void setMessage(String message) {
        this.message = message;
    }

    @Override
    public void setItemToValidate(Object object) {
        this.paramMap.put(this.fieldName, object);
    }

    void addParam(String paramName, Object value) {
        this.paramMap.put(paramName, value);
    }
}

